//////////////////////////////////////////////////
// drive_letters.js
//
// @author: Christopher Boumenot

function DriveLetters() {
    this.letters = new Array();
    this.letters["C"] = false;
    this.letters["D"] = false;
    this.letters["E"] = false;
    this.letters["F"] = false;
    this.letters["G"] = false;
    this.letters["H"] = false;
    this.letters["I"] = false;
    this.letters["J"] = false;
    this.letters["K"] = false;
    this.letters["L"] = false;
    this.letters["M"] = false;
    this.letters["N"] = false;
    this.letters["O"] = false;
    this.letters["P"] = false;
    this.letters["Q"] = false;
    this.letters["R"] = false;
    this.letters["S"] = false;
    this.letters["T"] = false;
    this.letters["U"] = false;
    this.letters["V"] = false;
    this.letters["W"] = false;
    this.letters["X"] = false;
    this.letters["Y"] = false;
    this.letters["Z"] = false;

    this.getNextLocal = function() {
        for (var i in this.letters) {
            if (this.letters[i] == false) {
                this.letters[i] = true;
                return i;
            }
        }

        throw Error(123, "getNextLocal() - no more drive letters available!");
    };

    this.getNextNetwork = function() {
        var reversed = new Array();
        for (var letter in this.letters) {
            reversed.unshift(letter);
        }

        for (var i = 0; i < reversed.length; i++) {
            if (this.letters[reversed[i]] == false) {
                this.letters[reversed[i]] = true;
                return reversed[i];
            }
        }

        throw Error(123, "getNextNetwork() - no more drive letters available!");
    };

    this.allocate = function(letter) {
        this.letters[letter] = true;
    };

    this.unallocate = function(letter) {
        this.letters[letter] = false;
    };

    this.isAllocated = function(letter) {
        return this.letters[letter];
    };

    //=============================================
    // c-tor
    var wmi = GetObject("winmgmts://./root/cimv2");    

    var logicalDisks = new Enumerator(wmi.execQuery("SELECT * FROM Win32_LogicalDisk"));
    for (; !logicalDisks.atEnd(); logicalDisks.moveNext()) {
        var letter = logicalDisks.item().deviceID.substr(0, 1);
        this.allocate(letter);
    }
}
