//////////////////////////////////////////////////
// This code sets up the RunOnce stuff in the unattend file
// to run the guest agent after reboot
// We have to add (or update) a FirstLogonCommands element, and some stuff under it, to
//	<settings pass="oobeSystem">
//		<component name="Microsoft-Windows-Shell-Setup" ...>
// So this code finds or creates the FirstLogonCommands element
// and then adds our agent startup command there
//////////////////////////////////////////////////

/** main *****************************************/
function DoRunOnce(xmlDoc, bag) {

		this.getNodeByAttribute = function(parent, nodeName, attName, attValue) {
		for (var iOne = 0; iOne < parent.length; iOne++) {
			if (parent[iOne].nodeName.toLowerCase() == nodeName.toLowerCase()) {
				if (parent[iOne].getAttribute(attName).toLowerCase() == attValue.toLowerCase()) {
					return iOne;
				}
			}
		}
		
		// didn't find it
		return -1;
	}

	this.getNode = function(parent, nodeName) {
		for (var iOne = 0; iOne < parent.length; iOne++) {
			if (parent[iOne].nodeName.toLowerCase() == nodeName.toLowerCase()) {
				return iOne;
			}
		}
		
		// didn't find it
		return -1;
	}
	
	this.load = function(xmlDoc, bag) {
		try {
			var one = xmlDoc.documentElement.childNodes;
			var iOne = this.getNodeByAttribute(one, "settings", "pass", "oobeSystem");
			if (iOne == -1) {
				throw("Required node not found");
			}
			var childOne = one[iOne];
			var two = childOne.childNodes;
			var iTwo = this.getNodeByAttribute(two, "component", "name", "Microsoft-Windows-Shell-Setup");
			if (iTwo == -1) {
				throw("Required node not found");
			}
			
			var firstLogonNode;							
			var three = two[iTwo].childNodes;
			var iThree = this.getNode(three, "FirstLogonCommands");
			
			if (iThree != -1) {
				firstLogonNode = three[iThree];
				debugalert("found first logon...");
			}							
			else {
				// didn't find it so make it
				firstLogonNode = xmlDoc.createElement("FirstLogonCommands");
				two[iTwo].appendChild(firstLogonNode);
				debugalert("created first logon...");
			}
								
			var syncNode = xmlDoc.createElement ("SynchronousCommand");
			syncNode.setAttribute("wcm:action", "add");
			firstLogonNode.appendChild(syncNode);
			debugalert("created sync node with attribute...");
								
			var googie = "c:\\VRMGuestAgent\\doagentc.bat";
			debugalert(googie);
									
			var newText = xmlDoc.createTextNode(googie);
			var newNode = xmlDoc.createElement ("CommandLine")
			newNode.appendChild(newText);
			syncNode.appendChild (newNode);
									
			newText = xmlDoc.createTextNode("Reboot the machine following VRM deployment.");
			newNode = xmlDoc.createElement ("Description")
			newNode.appendChild(newText);
			syncNode.appendChild (newNode);

			newText = xmlDoc.createTextNode("500");
			newNode = xmlDoc.createElement ("Order")
			newNode.appendChild(newText);
			syncNode.appendChild (newNode);

			debugalert("finished updating unattend.xml");										
		} catch (e) {
			WScript.Echo(e);
			throw e;
		}
	}
	
	this.load(xmlDoc, bag);
}

function debugalert(str) {
  //WScript.echo(str+"\n");
}