//////////////////////////////////////////////////
// script_writer.js
//
// @author: Christopher Boumenot

function right(s, count) {
    return s.slice(-1 * count);
}

function left(s, count) {
    return s.slice(0, count);
}

function ScriptWriter(prefix, suffix) {
    this.prefix = prefix;
    this.suffix = suffix;

    this.count = 0;
    this.filesystem = new ActiveXObject("Scripting.FileSystemObject");

    this.write = function(obj) {
        var filename = this.prefix + "." + right("000" + this.count, 3) + this.suffix;
        var file = this.filesystem.createTextFile(filename);
        file.write(obj.toString());
        
        this.count++;
    };
}
