//////////////////////////////////////////////////
// sysprep.js
//
// @author: john clark
/** utility **************************************/

function include(filename) {
	var fso = new ActiveXObject("Scripting.FileSystemObject");
	var f = fso.OpenTextFile(filename);
	var s = f.ReadAll();
	f.Close();
	return s;
};

/** include **************************************/

eval(include("workitem.js"));

/**********************************************/

function Sysprep(filename) {
	this.getSection = function(dottedString) {
		// return the middle node, which is the sysprep section name
		sectionName = dottedString.substring(dottedString.indexOf(".") + 1);
		return sectionName.substring (0, sectionName.indexOf("."));
	}
	
	this.getPropName = function(dottedString) {
		// return the last node
		sectionName = dottedString.substring(dottedString.indexOf(".") + 1);
		propname = sectionName.substring (sectionName.indexOf(".") + 1);
		return propname;
	}

    // can turn on lots of output and
    // pause processing by un-commenting
    // the call to WScript.echo below
    this.debugalert = function (str) {
        //WScript.echo(str + "\n");
    }


    this.load = function (filename) {
        this.sysprepprops = new Array();
        this.syspreppropscount = 0;
        this.sections = new Array();
        this.sectionsCount = 0;
        this.syspreppropsbag = new Array();
        bag = new WorkItem("properties.xml");

        var fso, ForReading;
        ForReading = 1;
        fso = new ActiveXObject("Scripting.FileSystemObject");

        // need to build some arrays of property data,
        // so that we can basically merge the sysprep file
        // with the sysprep properties from dcac
        try {
			var file = fso.OpenTextFile(filename, ForReading, false);
			while (true) {
				line = file.readline();
				var trimmed = line.replace(/^\s+|\s+$/g, '');
				var preptoprop = "sysprep.";
				var local;
				if (trimmed.indexOf("[") == 0) {
					//starting a new section, sysprep sections
					// start with [section_name]
					this.sections[this.sectionsCount] = trimmed.substring(1, trimmed.length - 1);
					local = preptoprop + this.sections[this.sectionsCount] + ".";
					this.sectionsCount++;
				}
				else if (trimmed.indexOf("=") != -1) { //ignore anything that isn't a section name or a section property
					local2 = local + trimmed.substring(0, trimmed.indexOf("="));

					// If sysprep file has joinworkgroup, and dcac sends joindomain
					// don't include the joinworkgroup, we won't use it
					if (local2.toLowerCase() == "sysprep.identification.joinworkgroup" &&
						bag.exists("sysprep.identification.joindomain")) {
						continue;
					}
                
					// If sysprep file has joindomain, and dcac sends joinworkgroup
					// don't include the joindomain, we won't use it
					if (local2.toLowerCase() == "sysprep.identification.joindomain" &&
						bag.exists("sysprep.identification.joinworkgroup")) {
						continue;
					}
                
					this.sysprepprops[this.syspreppropscount] = local2.toLowerCase();
					this.syspreppropsbag[this.sysprepprops[this.syspreppropscount]] = trimmed.substring(trimmed.indexOf("=") + 1);
					this.syspreppropscount++;
				}
			}
		}
		catch (e) {
			// assume that we reached EOF
			file.close();
			fso.DeleteFile(filename);
        }

        // make a simple indexed array of the dcac sysprep props		
        var xml = new ActiveXObject("Microsoft.XMLDOM");
        xml.async = false;
        xml.load("properties.xml");

        if (xml.parseError.errorCode != 0) {
            throw Error(xml.parseError.errorCode, xml.parseError.reason);
        }

        var nodes = xml.selectNodes("/properties/property");
        for (var i = 0; i < nodes.length; i++) {
            name = nodes[i].getAttribute("name");
            if (name.toLowerCase().indexOf("sysprep") == 0) {
                if (!(name.toLowerCase() in this.syspreppropsbag)) {
                    this.sysprepprops[this.sysprepprops.length] = name.toLowerCase();
                }
            }
        }

        // build a prop bag with values from either dcac 
        // or the original sysprep.inf file.  If prop exists in
        // both places, the values from dcac are used
        this.finalbag = new Array();
        for (var i = 0; i < this.sysprepprops.length; i++) {
            if (bag.exists(this.sysprepprops[i])) {
                this.finalbag[this.sysprepprops[i]] = bag.get(this.sysprepprops[i]);
            }
            else {
                this.finalbag[this.sysprepprops[i]] = this.syspreppropsbag[this.sysprepprops[i]];
            }
        }
		
		if (!bag.exists("sysprep.guiunattended.adminpassword")) {
			if (bag.exists("virtualmachine.admin.password")) {
				this.finalbag["sysprep.guiunattended.adminpassword"] = bag.get("virtualmachine.admin.password");
			}
		}

        // get the ou from sysprep.identification.machineobjectou
        // if it's there, else take it from infrastructure.admin.machineobjectou
        if ("sysprep.identification.joindomain" in this.finalbag) {
            this.debugalert("joining domain");
            this.sysprepprops[this.sysprepprops.length] = "sysprep.identification.machineobjectou";
            if (bag.exists("sysprep.identification.machineobjectou")) {
                this.debugalert("from sysprep prop");
                this.finalbag["sysprep.identification.machineobjectou"] = bag.get("sysprep.identification.machineobjectou");
            }
            else if (bag.exists("infrastructure.admin.machineobjectou")) {
                this.debugalert("from infrastructure prop");
                this.finalbag["sysprep.identification.machineobjectou"] = bag.get("infrastructure.admin.machineobjectou");
            }
        }

        // create the new sysprep file
        var file2 = fso.CreateTextFile(filename, true);
        file2.writeline(";SetupMgrTag");

        for (var j = 0; j < this.sections.length; j++) {
            file2.writeline("[" + this.sections[j] + "]");
            for (var i = 0; i < this.sysprepprops.length; i++) {
                if (this.getSection(this.sysprepprops[i]) == this.sections[j].toLowerCase()) {
					
					if ((this.getPropName(this.sysprepprops[i]).toLowerCase() == "computername") &&
						(this.getSection(this.sysprepprops[i]).toLowerCase() == "userdata") &&
						bag.exists("virtualmachine.admin.name")) {
                        file2.writeline("    " + this.getPropName(this.sysprepprops[i]) + "=" + bag.get("virtualmachine.admin.name"));
					}
                    // put quotes around passwords and ou - doesn't seem to work otherwise
                    else if ((this.sysprepprops[i].indexOf("machineobjectou") == -1) &&
					(this.sysprepprops[i].indexOf("domainadminpassword") == -1)) {
                        file2.writeline("    " + this.getPropName(this.sysprepprops[i]) + "=" + this.finalbag[this.sysprepprops[i]]);
                    }
                    else {
                        file2.writeline("    " + this.getPropName(this.sysprepprops[i]) + "=" + "\"" + this.finalbag[this.sysprepprops[i]] + "\"");
                    }
                }
            }
			
            file2.writeline("");
        }

        // append the runonce
        file2.writeline("[GuiRunOnce]");
        file2.writeline("    \"c:\\VRMGuestAgent\\doagentc.bat\"");  // call the agent

        // blank line for readability
        file2.writeline("");
        file2.close();
    };

    // c-tor
    this.load(filename);
}
