import os, string, re

class Version:
    REDHAT_RELEASE = '/etc/redhat-release'
    SUSE_RELEASE = '/etc/SuSE-release'

    def __init__(self):
        pass

    def get_version(self):
        if os.path.exists(Version.REDHAT_RELEASE):
            lines = open(Version.REDHAT_RELEASE).readlines()
            return self.get_redhat_version(lines)
        elif os.path.exists(Version.SUSE_RELEASE):
            lines = open(Version.SUSE_RELEASE).readlines()
            return self.get_suse_version(lines)
        else:
            raise "Cannot determine version!"

    def get_redhat_version(self, lines):
        """
        CentOS release 5.5 (Final)
        Red Hat Enterprise Linux Server release 5.5 (Tikanga) Red Hat Enterprise Linux Server release 6.0 (Santiago)
        """

        match = re.match(r'^.* release (\d+)\.(\d+)', lines[0])
        return ('RedHat', int(match.group(1)), int(match.group(2)))
        
    def get_suse_version(self, lines):
        """
        SUSE Linux Enterprise Server 10 (i586)
        VERSION = 10
        PATCHLEVEL = 3

        SUSE Linux Enterprise Server 11 (i586)
        VERSION = 11
        PATCHLEVEL = 1
        """

        def eol_digit(s):
            return int(string.split(s)[-1])

        major = 0
        minor = 0
        for line in lines:
            if line.startswith("VERSION"):
                major = eol_digit(line)
            elif line.startswith("PATCHLEVEL"):
                minor = eol_digit(line)

        return ('SuSE', major, minor)


# vim: sw=4 ts=4 et
