from xml.dom.minidom import parse

class Bag:
    """
    Front-end for properties.xml
    Implemented as a case-insensitive dictionary.
    """

    def __init__(self, filename):
        self.dict = {}

        for node in parse(filename).getElementsByTagName("property"):
            name = node.attributes['name'].nodeValue
            data = node.attributes['value'].nodeValue

            self.dict[name.lower()] = data

    def clear(self):
        self.dict.clear()

    def __contains__(self, key):
        return key.lower() in self.dict

    def __getitem__(self, key):
        return self.dict[key.lower()]

    def __len__(self):
        return len(self.dict)

    def __setitem__(self, key, value):
        self.dict[key.lower()] = value

    def __repr__(self):
        items = ", ".join([("%r: %r" % (k,v)) for k,v in self.items()])
        return "{%s}" % items

    def __str__(self):
        return repr(self)

    def get(self, key, default=None):
        try:
            return self[key]
        except KeyError:
            return default

    def has_key(self, key):
        return self.dict.has_key(key.lower())

    def keys(self):
        return self.dict.keys()

    def items(self):
        return self.dict.values()

    def values(self):
        return [x[1] for x in self.dict.values()]

# vim: sw=4 ts=4 et
