/*
Drops the database.

Script Input Variables:
	DBName  : The name of the database to drop
*/

:On Error exit

USE master;
GO

-- Drop the database $(DBName) if it already exists
IF  EXISTS (
	SELECT name 
		FROM sys.databases 
		WHERE name = N'$(DBName)'
)
BEGIN
	PRINT N'''$(DBName)'' found. Dropping database ''$(DBName)''.';
	-- Boot everyone out the database
	ALTER DATABASE [$(DBName)]
	SET SINGLE_USER WITH ROLLBACK IMMEDIATE;

	DROP DATABASE [$(DBName)];
END
ELSE
BEGIN
	PRINT N'''$(DBName)'' does not exist. Skipping...';
END;
GO