
-- Make sure that the VRM manager service
-- can execute the Windows Workflow Foundation stored procedures.

DECLARE @Use_Windows_Authen CHAR(1)

exec sp_addrolemember 'state_persistence_users', 'Vrm_Manager'
GO

-- Make sure that the VRM manager service
-- can execute the Task Execution stored procedures.
-- exec sp_addrolemember 'Task_Manager', 'Vrm_Manager'
--GO

/****** Object:  User [ServiceUser]    Script Date: 06/07/2007 10:34:38 ******/
/* The ServiceUser user allows ManagerService.exe access to SPs */

/* If login does not exist then create it */

SELECT @Use_Windows_Authen = '$(UseWindowsAuthentication)'

IF @Use_Windows_Authen = 'true'
BEGIN
	IF NOT EXISTS (SELECT * FROM sys.syslogins WHERE name='$(ServiceUser)')
	BEGIN
		CREATE LOGIN [$(ServiceUser)] FROM WINDOWS
	END
END
GO

/* If ServiceUser does not exist then create it */
IF NOT EXISTS (SELECT * FROM sys.database_principals WHERE name = N'ServiceUser')
BEGIN
	CREATE USER ServiceUser FOR LOGIN [$(ServiceUser)]
		WITH DEFAULT_SCHEMA=[dbo];
END
GO
/* If Vrm_Manager role does not exist then add this role */
IF NOT EXISTS( SELECT 1 FROM [dbo].[sysusers] WHERE name=N'Vrm_Manager' and issqlrole=1 )
BEGIN
	EXEC sp_addrole N'Vrm_Manager'
END
GO
-- add ServiceUser as a member of Vrm_Manager role
exec sp_addrolemember 'Vrm_Manager', 'ServiceUser'
-- add ServiceUser as a member db_owner role
exec sp_addrolemember 'db_owner', 'ServiceUser'
GO
