﻿----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[trg_UpdateStorageReservationSize]'))
DROP TRIGGER [dbo].[trg_UpdateStorageReservationSize]
GO
CREATE TRIGGER [dbo].[trg_UpdateStorageReservationSize] 
ON [dbo].[HostReservationToStorage] AFTER INSERT, UPDATE, DELETE
AS
      SET NOCOUNT ON;
      IF EXISTS (SELECT * FROM inserted) AND NOT UPDATE(MaxCapacity)
            RETURN

      UPDATE HostReservation 
      SET ReservationStorageSizeGB = 
      (
            SELECT 
                  CASE 
                        WHEN COUNT(s.MaxCapacity) != COUNT(*) THEN NULL  /* If any storage path capacities are null, the total capacity should be null (i.e. unlimited) */
                        ELSE SUM(s.MaxCapacity) 
                  END 
            FROM  HostReservationToStorage s 
            WHERE s.HostReservationID = r.HostReservationID 
            AND s.Enabled = 1
      )
      FROM HostReservation r 
      JOIN (
            SELECT HostReservationID FROM inserted UNION 
            SELECT HostReservationID FROM deleted 
            ) t ON r.HostReservationID = t.HostReservationID

GO

----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[trg_UpdateRequestFlags]'))
DROP TRIGGER [dbo].[trg_UpdateRequestFlags]
GO
CREATE TRIGGER [dbo].[trg_UpdateRequestFlags] 
ON Request AFTER INSERT, DELETE
AS
	-- Set the flag for reclamation request
	UPDATE VirtualMachine SET Flags = ISNULL(t.Flags, 0) + 2 FROM  
	(SELECT VirtualMachineID, Flags FROM VirtualMachine where VirtualMachineID in (SELECT VirtualMachineID FROM inserted WHERE RequestTypeID = 2) AND ISNULL(Flags,0) & 2 = 0) t 
	WHERE VirtualMachine.VirtualMachineID = t.VirtualMachineID
	UPDATE VirtualMachine SET Flags = ISNULL(t.Flags, 0) - 2 FROM  
	(SELECT VirtualMachineID, Flags FROM VirtualMachine where VirtualMachineID in (SELECT VirtualMachineID FROM deleted WHERE RequestTypeID = 2) AND ISNULL(Flags,0) & 2 = 2) t 
	WHERE VirtualMachine.VirtualMachineID = t.VirtualMachineID
GO

----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[trg_UpdateVirtualMachineFlags]'))
DROP TRIGGER [dbo].[trg_UpdateVirtualMachineFlags]
GO
CREATE TRIGGER [dbo].[trg_UpdateVirtualMachineFlags] 
ON VirtualMachine AFTER UPDATE
AS
	SET NOCOUNT ON;
	IF UPDATE(VirtualMachineState)
	BEGIN
		-- set flag for machine was turned on as well move the bit that reclamation was started
		UPDATE VirtualMachine SET Flags = ISNULL(t.Flags, 0) + 32 + (ISNULL(t.Flags, 0) & 2 * 4) FROM VirtualMachine t JOIN inserted i
		On t.VirtualMachineID = i.VirtualMachineID WHERE i.VirtualMachineState = N'On' and ISNULL(t.Flags, 0) & 32 = 0
	END 	
GO

----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[trg_DeleteVirtualMachine]'))
DROP TRIGGER [dbo].[trg_DeleteVirtualMachine]
GO
CREATE TRIGGER [dbo].[trg_DeleteVirtualMachine] 
ON VirtualMachine FOR DELETE
AS
	SET NOCOUNT ON;

	DELETE FROM VirtualMachineHistory 
	WHERE VirtualMachineID in 
		(SELECT VirtualMachineID FROM deleted)
	INSERT VirtualMachineHistory 
		SELECT * 
		FROM deleted 
		WHERE ISNULL(Flags, 0) & 32 = 32
	UPDATE VirtualMachineHistory 
		SET VMDeleteDate = GETDATE() 
		FROM VirtualMachineHistory v 
		JOIN deleted d 
		ON v.VirtualMachineID = d.VirtualMachineID	
		
	DELETE FROM VirtualMachineHistoryProperties
	WHERE EntityID in 
		(SELECT VirtualMachineID FROM deleted)
		
	INSERT VirtualMachineHistoryProperties
		SELECT EntityID, PropertyName, PropertyValue, IsHidden, IsRuntime, IsEncrypted 
		FROM VirtualMachineProperties vmp
		JOIN deleted on vmp.EntityID = deleted.VirtualMachineID
		WHERE EntityID IN
			(SELECT VirtualMachineID FROM deleted)
		AND
			ISNULL(deleted.Flags, 0) & 32 = 32

	DELETE FROM VirtualMachineProperties
	WHERE EntityID in
		(SELECT VirtualMachineID FROM deleted)

		
	INSERT VMDiskHardwareHistory
		SELECT vmd.VMToStorageId, vmd.VirtualMachineID, vmd.Capacity, vmd.DiskName, 
		vmd.Text1, vmd.Text2, vmd.HostToStorageID, vmd.UsedCapacity, vmd.ExternalDiskID, vmd.DeviceID, vmd.IsFixed
		FROM VMDiskHardware vmd
		JOIN deleted on vmd.VirtualMachineID = deleted.VirtualMachineID
		WHERE vmd.VirtualMachineID IN
			(SELECT VirtualMachineID FROM deleted)
		AND
			ISNULL(deleted.Flags, 0) & 32 = 32

	DELETE FROM VMDiskHardware
	WHERE VirtualMachineID in
		(SELECT VirtualMachineID FROM deleted)

	GO


