/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security.ruleset;

import com.sun.deploy.config.Config;
import com.sun.deploy.model.Resource;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.security.CertUtils;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.SystemUtils;
import com.sun.deploy.util.URLUtil;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.CodeSigner;
import java.security.cert.Certificate;
import java.util.List;

public class RuleId {
    protected String title;
    protected String location;
    protected String mainLocation;
    protected String mainVersion;
    protected String certAlgorithm;
    protected String certHash;
    protected String checksumAlg;
    protected String checksumHash;
    protected boolean isArtifactId;
    protected boolean isDocbaseId;

    public RuleId(String string, String string2, String string3, String string4) {
        this.title = string;
        this.location = string2;
        this.mainLocation = string3;
        this.mainVersion = string4;
        this.certAlgorithm = null;
        this.certHash = null;
        this.checksumAlg = null;
        this.checksumHash = null;
        this.isArtifactId = true;
        this.isDocbaseId = false;
    }

    public RuleId(String string, String string2, String string3, String string4, String string5, String string6) {
        this.title = string;
        this.location = string2;
        this.mainLocation = null;
        this.mainVersion = null;
        this.certAlgorithm = string3;
        this.certHash = string4;
        this.checksumAlg = string5;
        this.checksumHash = string6;
        this.isArtifactId = false;
        this.isDocbaseId = false;
    }

    public RuleId(String string) {
        this.title = null;
        this.location = string;
        this.mainLocation = null;
        this.mainVersion = null;
        this.certAlgorithm = null;
        this.certHash = null;
        this.checksumAlg = null;
        this.checksumHash = null;
        this.isArtifactId = false;
        this.isDocbaseId = true;
    }

    public boolean contains(RuleId ruleId) {
        Certificate[] certificateArray;
        Resource resource;
        if (!this.isArtifactId && ruleId.isDocbaseId) {
            try {
                if (this.title == null && this.certHash == null && this.checksumHash == null && (this.location == null || RuleId.compareStringToURL(this.location, new URL(ruleId.location)))) {
                    Trace.println("Matching Rule id for docbase only: " + this, TraceLevel.RULESET);
                    return true;
                }
            }
            catch (Exception exception) {
                Trace.ignored(exception);
            }
            Trace.println("Rule location: " + this.location + " doesn't match " + "docbase location: " + ruleId.location, TraceLevel.RULESET);
            return false;
        }
        if (this.isArtifactId || !ruleId.isArtifactId) {
            Trace.println("Id.contains() called with wrong id types ?");
            return false;
        }
        if (this.title != null && !this.title.equals(ruleId.title)) {
            Trace.println("Rule title: " + this.title + " doesn't match artifactId: " + ruleId.title, TraceLevel.RULESET);
            return false;
        }
        Trace.println("Rule title: " + this.title + " matches artifactId: " + ruleId.title, TraceLevel.RULESET);
        if (this.location != null) {
            try {
                if (ruleId.location == null) {
                    Trace.println("Rule location: " + this.location + " does not match UNKNOWN artifact location", TraceLevel.RULESET);
                    return false;
                }
                boolean bl = RuleId.compareStringToURL(this.location, new URL(ruleId.location));
                if (!bl) {
                    Trace.println("Rule location: " + this.location + " does not match artifact location: " + ruleId.location, TraceLevel.RULESET);
                    return false;
                }
            }
            catch (Exception exception) {
                Trace.ignored(exception);
                return false;
            }
        }
        Trace.println("Rule location: " + this.location + " matches artifactId: " + ruleId.location, TraceLevel.RULESET);
        if (this.certHash != null) {
            try {
                URL uRL = new URL(ruleId.mainLocation);
                resource = ResourceProvider.get().getResource(uRL, ruleId.mainVersion);
                certificateArray = null;
                boolean bl = false;
                String string = null;
                if (Config.isJavaVersionAtLeast15()) {
                    CodeSigner[] codeSignerArray = resource.getCodeSigners();
                    for (int i = 0; codeSignerArray != null && i < codeSignerArray.length; ++i) {
                        List<? extends Certificate> list = codeSignerArray[i].getSignerCertPath().getCertificates();
                        certificateArray = list.toArray(new Certificate[0]);
                        if (certificateArray == null || !this.certHash.equals(string = CertUtils.getMainCertHash(certificateArray, this.certAlgorithm))) continue;
                        bl = true;
                        break;
                    }
                } else {
                    certificateArray = resource.getCertificates();
                    if (certificateArray != null && this.certHash.equals(string = CertUtils.getMainCertHash(certificateArray, this.certAlgorithm))) {
                        bl = true;
                    }
                }
                if (certificateArray == null) {
                    Trace.println("Rule hash not matching certificate hash because cannot get certificates from resource: " + uRL, TraceLevel.RULESET);
                    return false;
                }
                if (!bl) {
                    Trace.println("Rule hash:\n         " + this.certHash + "\n" + "not matching artifact certificate hash:\n         " + string, TraceLevel.RULESET);
                    return false;
                }
                Trace.println("Rule hash matches certificate hash", TraceLevel.RULESET);
            }
            catch (IOException iOException) {
                Trace.println("IOException: " + iOException + "while finding hash for: " + ruleId.mainLocation, TraceLevel.RULESET);
                Trace.ignored(iOException);
                return false;
            }
        }
        if (this.checksumHash != null) {
            try {
                URL uRL = new URL(ruleId.mainLocation);
                resource = ResourceProvider.get().getResource(uRL, ruleId.mainVersion);
                certificateArray = SystemUtils.getFileChecksum(resource.getDataFile(), this.checksumAlg);
                if (!this.checksumHash.equals(certificateArray)) {
                    Trace.println("Rule checksum:  not equal artifact checksum:\n    " + (String)certificateArray, TraceLevel.RULESET);
                    return false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                Trace.println("invalid checksum in rule: " + this.checksumHash);
                return false;
            }
            catch (IOException iOException) {
                Trace.println("IOException: " + iOException + " while finding checksum for: " + ruleId.mainLocation, TraceLevel.RULESET);
                Trace.ignored(iOException);
                return false;
            }
        }
        Trace.println("Matching Rule ID: " + this, TraceLevel.RULESET);
        return true;
    }

    public String toString() {
        String string = "\n        title: " + this.title + "\n        location: " + this.location;
        if (this.mainLocation != null) {
            string = string + "\n        main location: " + this.mainLocation + "\n        main version: " + this.mainVersion;
        }
        if (this.certHash != null) {
            string = string + "\n        certificate algorithm: " + this.certAlgorithm + "\n        certertificate hash: " + this.certHash;
        }
        if (this.checksumHash != null) {
            string = string + "\n        checksum algorithm: " + this.checksumAlg + "\n        checksum hash: " + this.checksumHash;
        }
        string = string + "\n        isArtifact: " + this.isArtifactId;
        return string;
    }

    public static boolean compareStringToURL(String string, URL uRL) {
        int n;
        String string2 = uRL.getHost();
        String string3 = uRL.getProtocol();
        int n2 = uRL.getDefaultPort();
        int n3 = uRL.getPort();
        String string4 = uRL.getPath();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        URL uRL2 = null;
        try {
            uRL2 = new URL(string);
            string6 = uRL2.getProtocol();
            string5 = uRL2.getHost();
            n = uRL2.getPort();
            string7 = uRL2.getPath();
        }
        catch (MalformedURLException malformedURLException) {
            try {
                uRL2 = new URL("http://" + string);
                string6 = null;
                string5 = uRL2.getHost();
                n = uRL2.getPort();
                string7 = uRL2.getPath();
            }
            catch (MalformedURLException malformedURLException2) {
                Trace.println("invalid location: " + string, TraceLevel.RULESET);
                return false;
            }
        }
        Trace.println("RuleId compare: (" + string6 + ", " + string5 + ", " + n + ", " + string7 + ") to url: " + uRL, TraceLevel.RULESET);
        if (n == -1 || n == n3 || n == n2 && n3 == -1) {
            bl3 = true;
        }
        if (string6 == null || string6.equals(string3)) {
            bl = true;
        }
        if (string5.equals("*")) {
            bl2 = false;
        } else if (string5.startsWith("*.")) {
            String string8 = string5.substring(2);
            if (string2.toLowerCase().endsWith(string8.toLowerCase())) {
                bl2 = true;
            }
        } else if (string5.equalsIgnoreCase(string2)) {
            bl2 = true;
        }
        bl4 = RuleId.pathIncludes(string7, string4, string3, string2);
        return bl && bl2 && bl3 && bl4;
    }

    private static boolean pathIncludes(String string, String string2, String string3, String string4) {
        boolean bl = false;
        int n = string2.indexOf(37);
        if (n >= 0 && (string2.indexOf("%2E", n) >= 0 || string2.indexOf("%2e", n) >= 0 || string2.indexOf("%2F", n) >= 0 || string2.indexOf("%2f", n) >= 0)) {
            throw new SecurityException("Unsupported encoded character in path");
        }
        String string5 = URLUtil.decodePath(string2);
        for (int i = 0; i < string5.length(); ++i) {
            char c = string5.charAt(i);
            if (c > '\u001f' && c != '\u007f' && c != '?' && c != '%' && c != '\\' && c != '#') continue;
            throw new SecurityException("Unsupported character in decoded path");
        }
        try {
            string2 = new URI(string3, string4, string5, null).normalize().getPath();
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new SecurityException("unexpected excpetion", uRISyntaxException);
        }
        if (string == null || string.length() == 0 || string2.startsWith(string)) {
            bl = true;
        } else {
            Trace.println("Path mistach, actualPath: " + string2, TraceLevel.RULESET);
        }
        return bl;
    }
}

