/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.sharepoint;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xpath.XPathAPI;
import org.apache.xpath.objects.XObject;
import org.hyperic.sigar.win32.MetaBase;
import org.hyperic.sigar.win32.Win32Exception;
import org.hyperic.util.exec.Execute;
import org.hyperic.util.exec.ExecuteStreamHandler;
import org.hyperic.util.exec.ExecuteWatchdog;
import org.hyperic.util.exec.PumpStreamHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IisMetaBase {
    private static final Log log = LogFactory.getLog((String)IisMetaBase.class.getName());
    private static final String IIS_MKEY = "/LM/W3SVC";
    private static final int MD_SSL_ACCESS_PERM = 6030;
    private static final int MD_ACCESS_SSL = 8;
    protected static final String APPCMD = "C:/Windows/System32/inetsrv/appcmd.exe";
    private String id;
    private String ip;
    private String hostname;
    private String port;
    private String path;
    private boolean requireSSL = false;
    private String name;

    public String toString() {
        return "IisMetaBase{id=" + this.id + ", name=" + this.name + ", ip=" + this.ip + ", hostname=" + this.hostname + ", port=" + this.port + ", path=" + this.path + ", requireSSL=" + this.requireSSL + '}';
    }

    public String toUrlString() throws MalformedURLException {
        URL url = new URL(this.requireSSL ? "https" : "http", this.ip, Integer.parseInt(this.port), "/");
        String urlStr = url.toString();
        log.debug((Object)("web: '" + this + "'"));
        log.debug((Object)("urlStr: '" + urlStr + "'"));
        return urlStr;
    }

    public static Map<String, IisMetaBase> getWebSites() throws Win32Exception {
        if (new File(APPCMD).exists()) {
            try {
                return IisMetaBase.getWebSitesViaAppCmd();
            }
            catch (Exception e) {
                log.debug((Object)("C:/Windows/System32/inetsrv/appcmd.exe: " + e), (Throwable)e);
                throw new Win32Exception(e.getMessage());
            }
        }
        return IisMetaBase.getWebSitesViaMetaBase();
    }

    private static boolean parseBinding(IisMetaBase info, String entry) {
        if (entry == null) {
            return false;
        }
        int ix = entry.indexOf(":");
        if (ix == -1) {
            return false;
        }
        info.ip = entry.substring(0, ix);
        entry = entry.substring(ix + 1);
        ix = entry.indexOf(":");
        info.port = entry.substring(0, ix);
        info.hostname = entry.substring(ix + 1);
        if (info.hostname != null && info.hostname.length() == 0) {
            info.hostname = null;
        }
        if (info.ip == null || info.ip.length() == 0 || info.ip.equals("*")) {
            info.ip = "localhost";
        }
        return true;
    }

    private static Map getWebSitesViaAppCmd() throws Exception {
        String[] cmd = new String[]{APPCMD, "list", "config", "-section:system.applicationHost/sites"};
        HashMap<String, IisMetaBase> websites = new HashMap<String, IisMetaBase>();
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ExecuteWatchdog wdog = new ExecuteWatchdog(5000);
        Execute exec = new Execute((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)output), wdog);
        exec.setCommandline(cmd);
        try {
            int exitStatus = exec.execute();
            if (exitStatus != 0 || wdog.killedProcess()) {
                log.debug((Object)(Arrays.asList(cmd) + ": " + output));
                return websites;
            }
        }
        catch (Exception e) {
            log.debug((Object)(Arrays.asList(cmd) + ": " + e));
            return websites;
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document config = db.parse(new ByteArrayInputStream(output.toString().getBytes("UTF-8")));
        NodeList sites = XPathAPI.selectNodeList((Node)config, (String)"//sites/site");
        for (int i = 0; i < sites.getLength(); ++i) {
            String bindInfo;
            Element site = (Element)sites.item(i);
            String name = site.getAttribute("name");
            IisMetaBase info = new IisMetaBase();
            info.id = site.getAttribute("id");
            String sitePath = "//site[@name=\"" + name + "\"]/";
            String bindPath = sitePath + "bindings/binding[1]";
            String docPath = sitePath + "application[1]/virtualDirectory[1]/@physicalPath";
            Element binding = (Element)XPathAPI.selectSingleNode((Node)site, (String)bindPath);
            if (binding == null) {
                log.debug((Object)("No bindings defined for: " + name));
                continue;
            }
            String proto = binding.getAttribute("protocol");
            if (proto != null && "https".equals(proto.toString().trim())) {
                info.requireSSL = true;
            }
            if (!IisMetaBase.parseBinding(info, bindInfo = binding.getAttribute("bindingInformation"))) {
                log.debug((Object)("Failed to parse bindingInformation=" + bindInfo + " for: " + name));
                continue;
            }
            XObject docRoot = XPathAPI.eval((Node)site, (String)docPath);
            if (docRoot != null) {
                info.path = docRoot.toString();
            }
            log.debug((Object)(name + "=" + info));
            websites.put(name, info);
        }
        return websites;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, IisMetaBase> getWebSitesViaMetaBase() throws Win32Exception {
        String[] keys;
        HashMap<String, IisMetaBase> websites = new HashMap<String, IisMetaBase>();
        MetaBase mb = new MetaBase();
        try {
            mb.OpenSubKey(IIS_MKEY);
            keys = mb.getSubKeyNames();
        }
        finally {
            mb.close();
        }
        for (int i = 0; i < keys.length; ++i) {
            int id;
            String key = keys[i];
            if (!Character.isDigit(key.charAt(0))) continue;
            try {
                id = Integer.parseInt(key);
            }
            catch (NumberFormatException e) {
                continue;
            }
            String subkey = "/LM/W3SVC/" + id;
            MetaBase srv = null;
            try {
                String docroot;
                srv = new MetaBase();
                srv.OpenSubKey(subkey);
                String[] bindings = null;
                IisMetaBase info = new IisMetaBase();
                try {
                    int flags = srv.getIntValue(6030);
                    boolean bl = info.requireSSL = (flags & 8) != 0;
                    if (info.requireSSL) {
                        bindings = srv.getMultiStringValue(MetaBase.MD_SECURE_BINDINGS);
                    }
                }
                catch (Win32Exception e) {
                    // empty catch block
                }
                if (bindings == null) {
                    bindings = srv.getMultiStringValue(MetaBase.MD_SERVER_BINDINGS);
                }
                info.id = key;
                if (bindings.length == 0 || !IisMetaBase.parseBinding(info, bindings[0])) continue;
                String name = srv.getStringValue(MetaBase.MD_SERVER_COMMENT);
                info.setName(name);
                websites.put(name, info);
                srv.close();
                srv = null;
                srv = new MetaBase();
                srv.OpenSubKey(subkey + "/ROOT");
                info.path = docroot = srv.getStringValue(3001);
                continue;
            }
            catch (Win32Exception e) {
                continue;
            }
            finally {
                if (srv != null) {
                    srv.close();
                }
            }
        }
        return websites;
    }

    public static void main(String[] args) throws Exception {
        Map<String, IisMetaBase> websites = IisMetaBase.getWebSites();
        System.out.println(websites);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

