/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.sharepoint;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.hyperic.hq.agent.AgentKeystoreConfig;
import org.hyperic.hq.plugin.sharepoint.IisMetaBase;
import org.hyperic.hq.product.AutoServerDetector;
import org.hyperic.hq.product.GenericPlugin;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.ServerDetector;
import org.hyperic.hq.product.ServerResource;
import org.hyperic.hq.product.ServiceResource;
import org.hyperic.sigar.win32.Pdh;
import org.hyperic.sigar.win32.RegistryKey;
import org.hyperic.sigar.win32.Service;
import org.hyperic.sigar.win32.Win32Exception;
import org.hyperic.util.config.ConfigResponse;
import org.hyperic.util.http.HQHttpClient;
import org.hyperic.util.http.HttpConfig;
import org.hyperic.util.security.KeystoreConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SharePointServerDetectorDefault
extends ServerDetector
implements AutoServerDetector {
    private Log log = LogFactory.getLog(SharePointServerDetectorDefault.class);
    private static final List<String[]> statsServicesNameList = Arrays.asList({"Records Management Counters", null, "Search results processed / sec base"}, {"Publishing Cache", "_total", "Total object discards"}, {"Disk-Based Cache", null, "Old Blob Cache Folders Pending Delete"}, {"Foundation Search Gatherer Projects", "_total", "Gatherer Master Flag"}, {"Foundation Search Schema Plugin", "_total", "Total Documents"}, {"Foundation BDC Online", null, "Total calls failed"}, {"Foundation Search Gatherer", null, "Filter Processes Terminated 02"}, {"Foundation Search Indexer Plugin", "_total", "Persistent Indexes Propagated"}, {"Foundation Search Query Processor", null, "Security Descriptor Cache Misses"}, {"Foundation Search FAST Content Plugin", null, "Batches Failed Timeout"}, {"Foundation Search Archival Plugin", "_total", "Queues Committing"}, {"Foundation BDC Metadata", null, "Cache misses per second"}, {"Foundation Search Gatherer Databases", "_total", "Documents in the crawl history"});

    public final List getServerResources(ConfigResponse platformConfig) throws PluginException {
        this.log.debug((Object)("[discoverServices] config=" + platformConfig));
        ArrayList<ServerResource> servers = new ArrayList<ServerResource>();
        String installPath = null;
        String versionKey = this.getTypeProperty("version");
        try {
            RegistryKey key = RegistryKey.LocalMachine.openSubKey(versionKey);
            installPath = key.getStringValue("Location");
            key.close();
        }
        catch (Win32Exception ex) {
            this.log.debug((Object)("version registy key '" + versionKey + "' not found."), (Throwable)ex);
        }
        if (installPath != null) {
            ServerResource server = this.createServerResource(installPath);
            ConfigResponse pc = new ConfigResponse();
            pc.setValue("sharepoint.mainUrl", this.getMainUrl());
            this.setProductConfig(server, pc);
            this.setMeasurementConfig(server, new ConfigResponse());
            String websNames = "";
            List<IisMetaBase> webs = this.getWebServersNames();
            for (int i = 0; i < webs.size(); ++i) {
                IisMetaBase web = webs.get(i);
                if (websNames.length() > 0) {
                    websNames = websNames + ", ";
                }
                websNames = websNames + web.getName();
                this.log.debug((Object)(" => " + web.getName()));
            }
            String serviceNames = "";
            List<Service> winServices = this.getWinServiceList();
            for (int i = 0; i < winServices.size(); ++i) {
                Service service = winServices.get(i);
                if (serviceNames.length() > 0) {
                    serviceNames = serviceNames + ", ";
                }
                try {
                    this.log.debug((Object)(" *> " + service.getConfig().getName()));
                    serviceNames = serviceNames + service.getConfig().getName();
                    continue;
                }
                catch (Win32Exception ex) {
                    this.log.debug((Object)"Error", (Throwable)ex);
                }
            }
            this.log.debug((Object)(" -> websNames = " + websNames));
            this.log.debug((Object)(" -> serviceNames = " + serviceNames));
            ConfigResponse cc = new ConfigResponse();
            cc.setValue("sharepoint.control.webs", websNames);
            cc.setValue("sharepoint.control.services", serviceNames);
            this.setProductConfig(server, cc);
            this.setControlConfig(server, new ConfigResponse());
            if (webs.size() > 0 || winServices.size() > 0) {
                servers.add(server);
            }
        }
        return servers;
    }

    private List<IisMetaBase> getWebServersNames() {
        ArrayList<IisMetaBase> list = new ArrayList<IisMetaBase>();
        try {
            Map<String, IisMetaBase> websites = IisMetaBase.getWebSites();
            for (String siteName : websites.keySet()) {
                if (!siteName.startsWith("SharePoint")) continue;
                IisMetaBase web = websites.get(siteName);
                try {
                    if (this.testWebServer(web.toUrlString())) {
                        this.log.debug((Object)("web '" + siteName + "' is Running"));
                        web.setName(siteName);
                        list.add(web);
                        continue;
                    }
                    this.log.debug((Object)("web '" + siteName + "' is NOT running"));
                }
                catch (MalformedURLException ex) {
                    this.log.debug((Object)("Error formating URL for Webserver '" + siteName + "':'" + web + "'"), (Throwable)ex);
                }
            }
        }
        catch (Win32Exception ex) {
            this.log.debug((Object)"Error looking for Webservers", (Throwable)ex);
        }
        return list;
    }

    private List<Service> getWinServiceList() {
        ArrayList<Service> services = new ArrayList<Service>();
        try {
            List winServices = Service.getServiceNames();
            for (int i = 0; i < winServices.size(); ++i) {
                String name = (String)winServices.get(i);
                try {
                    Service winService = new Service(name);
                    String fullName = winService.getConfig().getDisplayName();
                    if (!fullName.startsWith(this.servicesPrefix())) continue;
                    if (winService.getStatus() == 4) {
                        this.log.debug((Object)(fullName + " (" + name + ") is RUNNING"));
                        services.add(winService);
                        continue;
                    }
                    this.log.debug((Object)(fullName + " (" + name + ") is NOT running"));
                    continue;
                }
                catch (Win32Exception ex) {
                    this.log.debug((Object)("Service '" + name + "' ignored: " + ex.getMessage()));
                }
            }
        }
        catch (Win32Exception ex) {
            this.log.debug((Object)("Error looking for Windows Services :" + (Object)((Object)ex)), (Throwable)ex);
        }
        return services;
    }

    protected final List discoverServices(ConfigResponse serverConfig) throws PluginException {
        this.log.debug((Object)("[discoverServices] config=" + serverConfig));
        ArrayList<ServiceResource> services = new ArrayList<ServiceResource>();
        List<IisMetaBase> webs = this.getWebServersNames();
        for (int i = 0; i < webs.size(); ++i) {
            IisMetaBase web = webs.get(i);
            ServiceResource service = new ServiceResource();
            service.setType((GenericPlugin)this, "Webserver");
            service.setServiceName("Webserver " + web.getName());
            services.add(service);
            try {
                ConfigResponse pc = new ConfigResponse();
                pc.setValue("url", web.toUrlString());
                pc.setValue("name", web.getName());
                this.setProductConfig(service, pc);
            }
            catch (MalformedURLException ex) {
                this.log.debug((Object)("Error formating URL for Webserver '" + web.getName() + "':'" + web + "'"), (Throwable)ex);
            }
            this.setMeasurementConfig(service, new ConfigResponse());
        }
        List<Service> winServices = this.getWinServiceList();
        for (int i = 0; i < winServices.size(); ++i) {
            try {
                Service winService = winServices.get(i);
                ServiceResource service = new ServiceResource();
                service.setType((GenericPlugin)this, "WindowsService");
                service.setServiceName("Windows Service " + winService.getConfig().getDisplayName());
                ConfigResponse pc = new ConfigResponse();
                pc.setValue("service_name", winService.getConfig().getName());
                this.setProductConfig(service, pc);
                service.setMeasurementConfig();
                service.setControlConfig();
                services.add(service);
                continue;
            }
            catch (Win32Exception ex) {
                this.log.debug((Object)("Error creating Window Service :" + (Object)((Object)ex)), (Throwable)ex);
            }
        }
        try {
            Pdh pdh = new Pdh();
            for (int i = 0; i < this.getStatsServicesNameList().size(); ++i) {
                String[] counter = this.getStatsServicesNameList().get(i);
                try {
                    StringBuilder obj = new StringBuilder("\\SharePoint ");
                    obj.append(counter[0]);
                    if (counter[1] != null) {
                        obj.append("(").append(counter[1]).append(")");
                    }
                    obj.append("\\").append(counter[2]);
                    this.log.debug((Object)("obj='" + obj + "'"));
                    pdh.getFormattedValue(obj.toString());
                    ServiceResource service = new ServiceResource();
                    service.setType((GenericPlugin)this, counter[0]);
                    service.setServiceName(counter[0]);
                    service.setMeasurementConfig();
                    service.setProductConfig();
                    services.add(service);
                    continue;
                }
                catch (Win32Exception ex) {
                    this.log.debug((Object)("ignoring service '" + counter[0] + "' error:" + (Object)((Object)ex)), (Throwable)ex);
                }
            }
        }
        catch (Win32Exception ex) {
            this.log.debug((Object)("Error accesing perfomance counters :" + (Object)((Object)ex)), (Throwable)ex);
        }
        return services;
    }

    private String getMainUrl() {
        this.log.debug((Object)"[getMainUrl]");
        String urlStr = null;
        try {
            Map<String, IisMetaBase> websites = IisMetaBase.getWebSites();
            for (String name : websites.keySet()) {
                IisMetaBase web = websites.get(name);
                if (!name.startsWith("SharePoint -")) continue;
                try {
                    urlStr = web.toUrlString();
                }
                catch (MalformedURLException ex) {
                    this.log.debug((Object)("Error formating URL for Webserver '" + name + "':'" + web + "'"), (Throwable)ex);
                }
            }
        }
        catch (Win32Exception ex) {
            this.log.debug((Object)"Error looking for URLs", (Throwable)ex);
        }
        return urlStr;
    }

    private boolean testWebServer(String url) {
        boolean res = false;
        HttpGet get = new HttpGet(url);
        AgentKeystoreConfig ksConfig = new AgentKeystoreConfig();
        HQHttpClient client = new HQHttpClient((KeystoreConfig)ksConfig, new HttpConfig(5000, 5000, null, 0), ksConfig.isAcceptUnverifiedCert());
        try {
            HttpResponse response = client.execute((HttpUriRequest)get, (HttpContext)new BasicHttpContext());
            int r = response.getStatusLine().getStatusCode();
            this.log.debug((Object)("[testWebServer] url='" + get.getURI() + "' statusCode='" + r + "' " + response.getStatusLine().getReasonPhrase()));
            res = r < 500;
        }
        catch (IOException ex) {
            this.log.debug((Object)ex.getMessage(), (Throwable)ex);
        }
        return res;
    }

    protected abstract String servicesPrefix();

    protected abstract List<String[]> getStatsServicesNameList();
}

