/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.hq.plugin.tcserver.plugin;

import com.springsource.hq.plugin.tcserver.plugin.wrapper.JmxUtils;
import com.springsource.hq.plugin.tcserver.plugin.wrapper.MxUtilJmxUtils;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.RuntimeMXBean;
import java.net.MalformedURLException;
import java.util.Properties;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.Metric;
import org.hyperic.hq.product.MetricInvalidException;
import org.hyperic.hq.product.MetricNotFoundException;
import org.hyperic.hq.product.MetricUnreachableException;
import org.hyperic.hq.product.MetricValue;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.jmx.MxMeasurementPlugin;

public class TomcatMeasurementPlugin
extends MxMeasurementPlugin {
    private static final String DEADLOCKED_DETECTION_COUNT = "deadlockedThreadCount";
    private static final String PERCENT_UP_TIME_IN_GARBAGE_COLLECTION_METRIC_NAME = "percentUpTimeSpent";
    private static final String PERCENT_ACTIVE_CONNECTIONS = "percentActiveConnections";
    private static final String PERCENT_ALLOCATED_THREADS = "percentAllocatedThreads";
    private static final String PERCENT_ACTIVE_THREADS = "percentActiveThreads";
    private static final String HEAP_FREE_MEMORY = "HeapMemoryUsage.free";
    private static final Log LOGGER = LogFactory.getLog(TomcatMeasurementPlugin.class);
    private final JmxUtils mxUtil;

    public TomcatMeasurementPlugin() {
        this(new MxUtilJmxUtils());
    }

    TomcatMeasurementPlugin(JmxUtils jmxUtils) {
        this.mxUtil = jmxUtils;
    }

    private MBeanServerConnection getConnection(Properties config) throws PluginException, MetricUnreachableException {
        try {
            return this.mxUtil.getMBeanServer(config);
        }
        catch (MalformedURLException e) {
            String msg = "Malformed URL: [" + config.getProperty(this.mxUtil.getJmxUrlProperty()) + "]";
            throw new PluginException(msg, (Throwable)e);
        }
        catch (IOException e) {
            String msg = "Can't connect to MBeanServer with url [" + config.getProperty(this.mxUtil.getJmxUrlProperty()) + "] and user [" + config.getProperty("jmx.username") + "]: " + e;
            throw new MetricUnreachableException(msg, (Throwable)e);
        }
    }

    private MetricValue percentUptimeInGarbageCollection(MBeanServerConnection connection) throws MetricUnreachableException, MetricNotFoundException, PluginException {
        double percentCollectionTime = 0.0;
        try {
            long totalGcTime = this.getTotalGarbageCollectionTime(connection);
            long upTime = this.getJvmUptime(connection);
            if (upTime > 0L) {
                percentCollectionTime = (double)totalGcTime / (double)upTime;
            }
        }
        catch (IllegalArgumentException e) {
            LOGGER.debug((Object)("Unable to retrieve metric percentUpTimeSpent" + e.getMessage()), (Throwable)e);
            throw new MetricUnreachableException("Unable to retrieve metric percentUpTimeSpent - " + e.getMessage(), (Throwable)e);
        }
        return new MetricValue(percentCollectionTime * 100.0);
    }

    private int getDeadlockedThreadCount(MBeanServerConnection connection) throws MetricInvalidException, MetricUnreachableException {
        int deadlockCount = 0;
        try {
            long[] deadlocks;
            try {
                deadlocks = (long[])connection.invoke(new ObjectName("java.lang:type=Threading"), "findDeadlockedThreads", null, null);
            }
            catch (MalformedObjectNameException e) {
                throw new MetricInvalidException("Error querying for deadlock thread mbean: " + e.getMessage(), (Throwable)e);
            }
            catch (JMException e) {
                LOGGER.debug((Object)"Method 'findDeadlockedThreads' for objectname 'java.lang:type=Threading'was not found. Trying method findMonitorDeadlockedThreads...", (Throwable)e);
                try {
                    deadlocks = (long[])connection.invoke(new ObjectName("java.lang:type=Threading"), "findMonitorDeadlockedThreads", null, null);
                }
                catch (MalformedObjectNameException me) {
                    throw new MetricInvalidException("Error querying for deadlock thread mbean: " + me.getMessage(), (Throwable)me);
                }
                catch (JMException ex) {
                    LOGGER.debug((Object)"Unable to retrieve DeadlockedThreads count: ", (Throwable)ex);
                    throw new MetricUnreachableException("Unable to reach deadlock thread mbean: " + ex.getMessage(), (Throwable)ex);
                }
            }
            if (deadlocks != null) {
                deadlockCount = deadlocks.length;
            }
            return deadlockCount;
        }
        catch (IOException e) {
            throw new MetricUnreachableException("Error querying for deadlock thread mbean: " + e.getMessage(), (Throwable)e);
        }
    }

    private long getJvmUptime(MBeanServerConnection connection) throws MetricUnreachableException {
        RuntimeMXBean bean;
        String upTimeQuery = "java.lang:type=Runtime";
        try {
            bean = this.getRuntimeMXBean(connection, upTimeQuery);
        }
        catch (IOException e) {
            throw new MetricUnreachableException("Error obtaining process UpTime:" + e.getMessage(), (Throwable)e);
        }
        return bean.getUptime();
    }

    private RuntimeMXBean getRuntimeMXBean(MBeanServerConnection connection, String upTimeQuery) throws IOException {
        return ManagementFactory.newPlatformMXBeanProxy(connection, upTimeQuery, RuntimeMXBean.class);
    }

    private long getTotalGarbageCollectionTime(MBeanServerConnection connection) throws MetricUnreachableException, MetricNotFoundException, PluginException {
        long totalGcTimeMillis = 0L;
        try {
            ObjectName gcObjName = new ObjectName("java.lang:type=GarbageCollector,*");
            Set<ObjectInstance> garbageCollectors = connection.queryMBeans(gcObjName, null);
            for (ObjectInstance instance : garbageCollectors) {
                ObjectName instanceName = instance.getObjectName();
                Long l = (Long)connection.getAttribute(instance.getObjectName(), "CollectionTime");
                long collectionTime = l;
                LOGGER.debug((Object)(instanceName + "::CollectionTime=" + collectionTime));
                if (collectionTime <= -1L) continue;
                totalGcTimeMillis += collectionTime;
            }
        }
        catch (MalformedObjectNameException e) {
            throw new MetricInvalidException("Error querying for GarbageCollector MBeans: " + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new MetricUnreachableException("Error querying for GarbageCollector MBeans:" + e.getMessage(), (Throwable)e);
        }
        catch (AttributeNotFoundException e) {
            throw new MetricNotFoundException("Error querying for GarbageCollector MBeans:" + e.getMessage(), (Throwable)e);
        }
        catch (InstanceNotFoundException e) {
            throw new MetricNotFoundException("Error querying for GarbageCollector MBeans:" + e.getMessage(), (Throwable)e);
        }
        catch (MBeanException e) {
            throw new PluginException("Error querying for GarbageCollector MBeans:" + e.getMessage(), (Throwable)e);
        }
        catch (ReflectionException e) {
            throw new PluginException("Error querying for GarbageCollector MBeans:" + e.getMessage(), (Throwable)e);
        }
        catch (NullPointerException e) {
            throw new PluginException("Error querying for GarbageCollector MBeans:" + e.getMessage(), (Throwable)e);
        }
        return totalGcTimeMillis;
    }

    private long getFreeHeapMemory(MBeanServerConnection connection) throws MetricUnreachableException {
        try {
            MemoryMXBean memoryBean = ManagementFactory.newPlatformMXBeanProxy(connection, "java.lang:type=Memory", MemoryMXBean.class);
            long max = memoryBean.getHeapMemoryUsage().getMax();
            long used = memoryBean.getHeapMemoryUsage().getUsed();
            return max - used;
        }
        catch (IOException e) {
            throw new MetricUnreachableException("Error retrieving Memory MBean" + e.getMessage(), (Throwable)e);
        }
    }

    private MetricValue getPercentActiveConnections(MBeanServerConnection connection, Metric metric) throws MetricUnreachableException, MetricNotFoundException, PluginException {
        int numActiveConnections = 0;
        int maxActiveConnections = 0;
        try {
            ObjectName dataSourceObjectName = new ObjectName(metric.getObjectName());
            numActiveConnections = (Integer)connection.getAttribute(dataSourceObjectName, "numActive");
            maxActiveConnections = (Integer)connection.getAttribute(dataSourceObjectName, "maxActive");
        }
        catch (MalformedObjectNameException e) {
            throw new MetricInvalidException("Error querying for DataSource MBeans: " + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new MetricUnreachableException("Error querying for DataSource MBeans:" + e.getMessage(), (Throwable)e);
        }
        catch (AttributeNotFoundException e) {
            throw new MetricNotFoundException("Error querying for DataSource MBeans:" + e.getMessage(), (Throwable)e);
        }
        catch (InstanceNotFoundException e) {
            throw new MetricNotFoundException("Error querying for DataSource MBeans:" + e.getMessage(), (Throwable)e);
        }
        catch (MBeanException e) {
            throw new PluginException("Error querying for DataSource MBeans:" + e.getMessage(), (Throwable)e);
        }
        catch (ReflectionException e) {
            throw new PluginException("Error querying for DataSource MBeans:" + e.getMessage(), (Throwable)e);
        }
        catch (NullPointerException e) {
            throw new PluginException("Error querying for DataSource MBeans:" + e.getMessage(), (Throwable)e);
        }
        return new MetricValue(100.0 * (double)numActiveConnections / (double)maxActiveConnections);
    }

    private MetricValue getPercentAllocatedThreads(MBeanServerConnection connection, Metric metric) throws MetricUnreachableException, MetricNotFoundException, PluginException {
        int currentThreadCount = 0;
        int maxThreads = 0;
        try {
            ObjectName threadPoolObjectName = new ObjectName(metric.getObjectName());
            currentThreadCount = (Integer)connection.getAttribute(threadPoolObjectName, "currentThreadCount");
            maxThreads = (Integer)connection.getAttribute(threadPoolObjectName, "maxThreads");
        }
        catch (MalformedObjectNameException e) {
            throw new MetricInvalidException("Error querying for Thread Pool MBeans: " + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new MetricUnreachableException("Error querying for Thread Pool MBeans:" + e.getMessage(), (Throwable)e);
        }
        catch (AttributeNotFoundException e) {
            throw new MetricNotFoundException("Error querying for Thread Pool MBeans:" + e.getMessage(), (Throwable)e);
        }
        catch (InstanceNotFoundException e) {
            throw new MetricNotFoundException("Error querying for Thread Pool MBeans:" + e.getMessage(), (Throwable)e);
        }
        catch (MBeanException e) {
            throw new PluginException("Error querying for Thread Pool MBeans:" + e.getMessage(), (Throwable)e);
        }
        catch (ReflectionException e) {
            throw new PluginException("Error querying for Thread Pool MBeans:" + e.getMessage(), (Throwable)e);
        }
        catch (NullPointerException e) {
            throw new PluginException("Error querying for Thread Pool MBeans:" + e.getMessage(), (Throwable)e);
        }
        return new MetricValue(100.0 * (double)currentThreadCount / (double)maxThreads);
    }

    private MetricValue getPercentActiveThreads(MBeanServerConnection connection, Metric metric) throws MetricUnreachableException, MetricNotFoundException, PluginException {
        int currentThreadsBusy = 0;
        int maxThreads = 0;
        try {
            ObjectName threadPoolObjectName = new ObjectName(metric.getObjectName());
            currentThreadsBusy = (Integer)connection.getAttribute(threadPoolObjectName, "currentThreadsBusy");
            maxThreads = (Integer)connection.getAttribute(threadPoolObjectName, "maxThreads");
        }
        catch (MalformedObjectNameException e) {
            throw new MetricInvalidException("Error querying for Thread Pool MBeans: " + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new MetricUnreachableException("Error querying for Thread Pool MBeans:" + e.getMessage(), (Throwable)e);
        }
        catch (AttributeNotFoundException e) {
            throw new MetricNotFoundException("Error querying for Thread Pool MBeans:" + e.getMessage(), (Throwable)e);
        }
        catch (InstanceNotFoundException e) {
            throw new MetricNotFoundException("Error querying for Thread Pool MBeans:" + e.getMessage(), (Throwable)e);
        }
        catch (MBeanException e) {
            throw new PluginException("Error querying for Thread Pool MBeans:" + e.getMessage(), (Throwable)e);
        }
        catch (ReflectionException e) {
            throw new PluginException("Error querying for Thread Pool MBeans:" + e.getMessage(), (Throwable)e);
        }
        catch (NullPointerException e) {
            throw new PluginException("Error querying for Thread Pool MBeans:" + e.getMessage(), (Throwable)e);
        }
        return new MetricValue(100.0 * (double)currentThreadsBusy / (double)maxThreads);
    }

    public MetricValue getValue(Metric metric) throws PluginException, MetricNotFoundException, MetricUnreachableException {
        if (PERCENT_UP_TIME_IN_GARBAGE_COLLECTION_METRIC_NAME.equals(metric.getAttributeName())) {
            return new MetricValue(this.percentUptimeInGarbageCollection(this.getConnection(metric.getProperties())));
        }
        if (DEADLOCKED_DETECTION_COUNT.equals(metric.getAttributeName())) {
            return new MetricValue((long)this.getDeadlockedThreadCount(this.getConnection(metric.getProperties())));
        }
        if (HEAP_FREE_MEMORY.equals(metric.getAttributeName())) {
            return new MetricValue(this.getFreeHeapMemory(this.getConnection(metric.getProperties())));
        }
        if (PERCENT_ACTIVE_CONNECTIONS.equals(metric.getAttributeName())) {
            return new MetricValue(this.getPercentActiveConnections(this.getConnection(metric.getProperties()), metric));
        }
        if (PERCENT_ALLOCATED_THREADS.equals(metric.getAttributeName())) {
            return new MetricValue(this.getPercentAllocatedThreads(this.getConnection(metric.getProperties()), metric));
        }
        if (PERCENT_ACTIVE_THREADS.equals(metric.getAttributeName())) {
            return new MetricValue(this.getPercentActiveThreads(this.getConnection(metric.getProperties()), metric));
        }
        return super.getValue(metric);
    }
}

