/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.hq.plugin.tcserver.plugin.serverconfig;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractXmlElementConverter {
    private final Log logger = LogFactory.getLog(AbstractXmlElementConverter.class);
    private PropertySubstituter propertySubstituter = new PropertySubstituter();

    protected void updateServletInitParam(Document document, Element servlet, String attributeName, Object attributeValue, Properties catalinaProperties) {
        List<Element> initParams = this.getChildElements(servlet, "init-param");
        boolean paramFound = false;
        int i = 0;
        while (i < initParams.size()) {
            Element initParam = initParams.get(i);
            String paramName = this.getChildElements(initParam, "param-name").get(0).getTextContent();
            if (paramName.equals(attributeName)) {
                paramFound = true;
                if (attributeValue != null && !"".equals(attributeValue)) {
                    Element paramValue = this.getChildElements(initParam, "param-value").get(0);
                    paramValue.setTextContent(this.determineNewValue(paramValue.getTextContent(), attributeValue, catalinaProperties));
                    break;
                }
                servlet.removeChild(initParam);
                break;
            }
            ++i;
        }
        if (!paramFound && attributeValue != null && !"".equals(attributeValue)) {
            Element initParam = document.createElement("init-param");
            Element paramName = document.createElement("param-name");
            Element paramValue = document.createElement("param-value");
            initParam.appendChild(paramName);
            initParam.appendChild(paramValue);
            paramName.setTextContent(attributeName);
            paramValue.setTextContent(this.determineNewValue(paramValue.getTextContent(), attributeValue, catalinaProperties));
            servlet.appendChild(initParam);
        }
    }

    protected void logNonNumericValue(String elementName, String attributeName, String attributeValue) {
        this.logger.warn((Object)("Error reading tc Runtime configuration.  " + elementName + " " + attributeName + " set to a non-numeric value: '" + attributeValue + "'.  Default value will be displayed instead."));
    }

    protected List<Element> getChildElements(Element element, String childName) {
        ArrayList<Element> childElements = new ArrayList<Element>();
        NodeList children = element.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            if (childName.equals(children.item(i).getNodeName())) {
                childElements.add((Element)children.item(i));
            }
            ++i;
        }
        return childElements;
    }

    protected void setAttribute(Element xmlElement, String attributeName, Object value, Properties catalinaProperties, boolean required) {
        String oldValue = xmlElement.getAttribute(attributeName);
        String valueToWrite = this.determineNewValue(oldValue, value, catalinaProperties);
        if (required || valueToWrite != null && !"".equals(valueToWrite)) {
            xmlElement.setAttribute(attributeName, valueToWrite);
        } else {
            xmlElement.removeAttribute(attributeName);
        }
    }

    private String determineNewValue(String exsistingValue, Object newValue, Properties catalinaProperties) {
        if (newValue == null) {
            return null;
        }
        String newValueStr = newValue.toString();
        if (exsistingValue == null) {
            return newValueStr;
        }
        if (newValue.equals(exsistingValue)) {
            return newValueStr;
        }
        if (newValueStr.equals(this.parseProperties(exsistingValue, catalinaProperties))) {
            return exsistingValue;
        }
        return this.substituteCatalinaPlaceholders(newValueStr, catalinaProperties);
    }

    protected String parseProperties(String strVal, Properties properties) {
        return this.propertySubstituter.parse(strVal, properties);
    }

    private String substituteCatalinaPlaceholders(String strVal, Properties properties) {
        if (strVal == null) {
            return strVal;
        }
        String catalinaBase = properties.getProperty("catalina.base");
        String catalinaHome = properties.getProperty("catalina.home");
        if (strVal.startsWith(catalinaBase)) {
            strVal = "${catalina.base}" + strVal.substring(catalinaBase.length());
        } else if (strVal.startsWith(catalinaHome)) {
            strVal = "${catalina.home}" + strVal.substring(catalinaHome.length());
        }
        return strVal;
    }

    private static class PropertySubstituter
    extends PropertyPlaceholderConfigurer {
        public PropertySubstituter() {
            this.setIgnoreUnresolvablePlaceholders(true);
            this.setSearchSystemEnvironment(false);
            this.setSystemPropertiesMode(0);
        }

        public String parse(String strVal, Properties properties) {
            return this.parseStringValue(strVal, properties, new HashSet());
        }
    }
}

