/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.hq.plugin.tcserver.plugin.serverconfig;

import com.springsource.hq.plugin.tcserver.plugin.serverconfig.ContextXmlParser;
import com.springsource.hq.plugin.tcserver.plugin.serverconfig.ServerXmlParser;
import com.springsource.hq.plugin.tcserver.plugin.serverconfig.SettingsFactory;
import com.springsource.hq.plugin.tcserver.plugin.serverconfig.WebXmlParser;
import com.springsource.hq.plugin.tcserver.plugin.serverconfig.XmlElementConverter;
import com.springsource.hq.plugin.tcserver.plugin.serverconfig.XmlParser;
import com.springsource.hq.plugin.tcserver.plugin.serverconfig.context.ContextContainerConverter;
import com.springsource.hq.plugin.tcserver.plugin.serverconfig.environment.EnvironmentFactory;
import com.springsource.hq.plugin.tcserver.plugin.serverconfig.environment.UnixFileReadingEnvironmentFactory;
import com.springsource.hq.plugin.tcserver.plugin.serverconfig.environment.WindowsFileReadingEnvironmentFactory;
import com.springsource.hq.plugin.tcserver.plugin.serverconfig.general.GeneralConfigConverter;
import com.springsource.hq.plugin.tcserver.plugin.serverconfig.resources.jdbc.DataSourcesConverter;
import com.springsource.hq.plugin.tcserver.plugin.serverconfig.serverdefaults.ServerDefaultsConverter;
import com.springsource.hq.plugin.tcserver.plugin.serverconfig.services.ServicesConverter;
import com.springsource.hq.plugin.tcserver.serverconfig.Settings;
import com.springsource.hq.plugin.tcserver.serverconfig.configuration.Configuration;
import com.springsource.hq.plugin.tcserver.serverconfig.configuration.context.ContextContainer;
import com.springsource.hq.plugin.tcserver.serverconfig.configuration.general.GeneralConfig;
import com.springsource.hq.plugin.tcserver.serverconfig.configuration.jvm.Environment;
import com.springsource.hq.plugin.tcserver.serverconfig.configuration.serverdefaults.ServerDefaults;
import com.springsource.hq.plugin.tcserver.serverconfig.resources.jdbc.DataSource;
import com.springsource.hq.plugin.tcserver.serverconfig.services.Service;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.codec.binary.Base64;
import org.hyperic.hq.product.Metric;
import org.hyperic.hq.product.PlatformDetector;
import org.hyperic.hq.product.PluginException;
import org.hyperic.util.config.ConfigResponse;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class FileReadingSettingsFactory
implements SettingsFactory {
    private XmlElementConverter<ContextContainer> contextContainerConverter = new ContextContainerConverter();
    private XmlElementConverter<Set<DataSource>> dataSourcesConverter = new DataSourcesConverter();
    private XmlElementConverter<GeneralConfig> generalConfigConverter = new GeneralConfigConverter();
    private EnvironmentFactory environmentFactory = PlatformDetector.IS_WIN32 ? new WindowsFileReadingEnvironmentFactory() : new UnixFileReadingEnvironmentFactory();
    private XmlElementConverter<ServerDefaults> serverDefaultsConverter = new ServerDefaultsConverter();
    private XmlElementConverter<Set<Service>> servicesConverter = new ServicesConverter();
    private XmlParser serverXmlParser = new ServerXmlParser();
    private XmlParser webXmlParser = new WebXmlParser();
    private XmlParser contextXmlParser = new ContextXmlParser();

    public Settings create(ConfigResponse config) throws PluginException {
        try {
            Settings settings = new Settings();
            Properties catalinaProperties = this.loadCatalinaProperties(config);
            this.loadServerXml(config, settings, catalinaProperties);
            this.loadContextXml(config, settings.getConfiguration(), catalinaProperties);
            this.loadWebXml(config, settings.getConfiguration(), catalinaProperties);
            settings.getConfiguration().setEnvironment(this.environmentFactory.create(config));
            return settings;
        }
        catch (Exception e) {
            throw new PluginException("Unable to read existing tc Runtime configuration.  Cause: " + e.getMessage(), (Throwable)e);
        }
    }

    public Environment createEnvironment(ConfigResponse config) throws PluginException {
        try {
            return this.environmentFactory.create(config);
        }
        catch (Exception e) {
            throw new PluginException("Unable to read existing tc Runtime configuration.  Cause: " + e.getMessage(), (Throwable)e);
        }
    }

    public String getFile(ConfigResponse config) throws PluginException {
        String filename = this.createSanitizedPath(Metric.decode((String)config.getValue("installpath")), config.getValue("FILE_NAME"));
        try {
            return this.readFileAsBase64(filename);
        }
        catch (Exception e) {
            throw new PluginException("Unable to read configuration file.  Cause: " + e.getMessage());
        }
    }

    private Configuration createConfiguration(Element server, Properties catalinaProperties) {
        Configuration configuration = new Configuration();
        configuration.setGeneralConfig(this.generalConfigConverter.convert(server, catalinaProperties));
        return configuration;
    }

    private String createSanitizedPath(String path, String file) throws PluginException {
        if (file.contains("..")) {
            throw new PluginException();
        }
        StringBuilder fullPath = new StringBuilder();
        fullPath.append(path);
        if (!file.startsWith("/")) {
            fullPath.append("/");
        }
        fullPath.append(file);
        return fullPath.toString();
    }

    private Properties loadCatalinaProperties(ConfigResponse config) throws IOException {
        FileSystemResource propResource = new FileSystemResource(String.valueOf(Metric.decode((String)config.getValue("installpath"))) + "/conf/catalina.properties");
        Properties catalinaProperties = propResource.exists() ? PropertiesLoaderUtils.loadProperties((Resource)propResource) : new Properties();
        catalinaProperties.put("catalina.home", Metric.decode((String)config.getValue("catalina.home")));
        catalinaProperties.put("catalina.base", Metric.decode((String)config.getValue("installpath")));
        return catalinaProperties;
    }

    private void loadContextXml(ConfigResponse config, Configuration configuration, Properties catalinaProperties) throws ParserConfigurationException, SAXException, IOException, PluginException {
        Element context = this.contextXmlParser.parse(this.contextXmlParser.createDocument(config));
        configuration.setContextContainer(this.contextContainerConverter.convert(context, catalinaProperties));
    }

    private void loadServerXml(ConfigResponse config, Settings settings, Properties catalinaProperties) throws ParserConfigurationException, SAXException, IOException, PluginException {
        Element server = this.serverXmlParser.parse(this.serverXmlParser.createDocument(config));
        settings.setConfiguration(this.createConfiguration(server, catalinaProperties));
        settings.setDataSources(this.dataSourcesConverter.convert(server, catalinaProperties));
        settings.setServices(this.servicesConverter.convert(server, catalinaProperties));
    }

    private void loadWebXml(ConfigResponse config, Configuration configuration, Properties catalinaProperties) throws ParserConfigurationException, SAXException, IOException, PluginException {
        Element webApp = this.webXmlParser.parse(this.webXmlParser.createDocument(config));
        configuration.setServerDefaults(this.serverDefaultsConverter.convert(webApp, catalinaProperties));
    }

    private String readFileAsBase64(String destinationFile) throws IOException {
        String string;
        block12: {
            InputStream in = null;
            try {
                int chunk;
                in = new FileInputStream(new File(destinationFile));
                int len = 0;
                byte[] buf = new byte[1024];
                while ((chunk = in.read(buf)) > 0) {
                    len += chunk;
                }
                try {
                    in.close();
                }
                catch (IOException iOException) {}
                in = new FileInputStream(new File(destinationFile));
                int pos = 0;
                byte[] data = new byte[len];
                while ((chunk = in.read(buf)) > 0) {
                    int i = 0;
                    while (i < chunk) {
                        data[pos++] = buf[i];
                        ++i;
                    }
                }
                string = new String(Base64.encodeBase64((byte[])data));
                if (in == null) break block12;
            }
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        return string;
    }
}

