/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.hq.plugin.tcserver.plugin.serverconfig.environment;

import com.springsource.hq.plugin.tcserver.plugin.serverconfig.environment.DefaultJvmOptionsConverter;
import com.springsource.hq.plugin.tcserver.plugin.serverconfig.environment.EnvironmentRepository;
import com.springsource.hq.plugin.tcserver.plugin.serverconfig.environment.JvmOptionsConverter;
import com.springsource.hq.plugin.tcserver.serverconfig.configuration.jvm.Environment;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.Metric;
import org.hyperic.hq.product.PluginException;
import org.hyperic.util.config.ConfigResponse;

public class UnixFileEnvironmentRepository
implements EnvironmentRepository {
    private JvmOptionsConverter jvmOptionsConverter = new DefaultJvmOptionsConverter();
    private final Log logger = LogFactory.getLog(UnixFileEnvironmentRepository.class);

    public void save(String backupFileName, ConfigResponse config, Environment environment) throws PluginException {
        BufferedReader envFileReader = null;
        FileOutputStream newSetEnv = null;
        try {
            try {
                envFileReader = new BufferedReader(new FileReader(backupFileName));
            }
            catch (FileNotFoundException e) {
                throw new PluginException("Unable to save setenv.  Error parsing existing file.  Cause: " + e.getMessage());
            }
            try {
                newSetEnv = new FileOutputStream(String.valueOf(Metric.decode((String)config.getValue("installpath"))) + "/bin/setenv.sh");
            }
            catch (FileNotFoundException e) {
                throw new PluginException("Unable to save setenv.  Error writing to existing file.  Cause: " + e.getMessage());
            }
            try {
                String line = envFileReader.readLine();
                boolean processedJavaHome = false;
                while (line != null) {
                    if (line.trim().startsWith("JVM_OPTS")) {
                        while (line != null && !line.trim().endsWith("\"")) {
                            line = envFileReader.readLine();
                        }
                        this.writeJvmOpts(environment, newSetEnv);
                    } else if (line.trim().startsWith("JAVA_HOME") || line.trim().startsWith("#JAVA_HOME")) {
                        processedJavaHome = true;
                        this.writeJavaHome(environment, newSetEnv);
                    } else {
                        newSetEnv.write(line.getBytes());
                        newSetEnv.write("\n".getBytes());
                    }
                    line = envFileReader.readLine();
                }
                if (!processedJavaHome) {
                    this.writeJavaHome(environment, newSetEnv);
                }
                newSetEnv.flush();
                newSetEnv.getFD().sync();
            }
            catch (IOException e) {
                throw new PluginException("Error writing JVM options to setenv.  Cause: " + e.getMessage());
            }
        }
        finally {
            try {
                if (envFileReader != null) {
                    envFileReader.close();
                }
            }
            catch (IOException e) {
                this.logger.warn((Object)("Error closing reader to backup setenv file.  Cause: " + e.getMessage()));
            }
            try {
                if (newSetEnv != null) {
                    newSetEnv.close();
                }
            }
            catch (IOException e) {
                this.logger.warn((Object)("Error closing output stream to setenv file.  Cause: " + e.getMessage()));
            }
        }
    }

    private void writeJvmOpts(Environment environment, FileOutputStream newSetEnv) throws IOException {
        List<String> jvmOpts = this.jvmOptionsConverter.convert(environment.getJvmOptions());
        StringBuilder jvmOptString = new StringBuilder("JVM_OPTS=\"");
        Iterator<String> optsIterator = jvmOpts.iterator();
        while (optsIterator.hasNext()) {
            jvmOptString.append(optsIterator.next());
            if (!optsIterator.hasNext()) continue;
            jvmOptString.append(" ");
        }
        jvmOptString.append("\"");
        newSetEnv.write(jvmOptString.toString().getBytes());
        newSetEnv.write("\n".getBytes());
    }

    public void save(ConfigResponse config, Environment environment) throws PluginException {
        FileOutputStream setenvStream;
        File setenv = new File(String.valueOf(Metric.decode((String)config.getValue("installpath"))) + "/bin/setenv.sh");
        try {
            setenv.createNewFile();
        }
        catch (IOException e) {
            throw new PluginException("Error creating new setenv file. Cause: " + e.getMessage());
        }
        try {
            setenvStream = new FileOutputStream(setenv);
        }
        catch (FileNotFoundException e) {
            throw new PluginException("Unable to save setenv.  Error writing to existing file.  Cause: " + e.getMessage());
        }
        StringBuilder setenvString = new StringBuilder();
        setenvString.append("JVM_OPTS=\"");
        List<String> jvmOpts = this.jvmOptionsConverter.convert(environment.getJvmOptions());
        for (String jvmOpt : jvmOpts) {
            setenvString.append(String.valueOf(jvmOpt) + " ");
        }
        setenvString.append("\"\n");
        setenvString.append("CATALINA_OPTS=\"$JVM_OPTS\"");
        setenvString.append("\n");
        if (environment.getJavaHome() != null && !"".equals(environment.getJavaHome().trim())) {
            setenvString.append("JAVA_HOME=\"" + environment.getJavaHome() + "\"");
        } else {
            setenvString.append("#JAVA_HOME=\"\"");
        }
        try {
            try {
                ((OutputStream)setenvStream).write(setenvString.toString().getBytes());
            }
            catch (IOException e) {
                throw new PluginException("Error writing to new setenv file.  Cause: " + e.getMessage());
            }
        }
        finally {
            try {
                ((OutputStream)setenvStream).close();
            }
            catch (IOException e) {
                this.logger.warn((Object)("Error closing output stream to setenv file.  Cause: " + e.getMessage()));
            }
        }
    }

    private void writeJavaHome(Environment environment, OutputStream newSetEnv) throws IOException {
        if (environment.getJavaHome() != null && !"".equals(environment.getJavaHome().trim())) {
            newSetEnv.write(("JAVA_HOME=\"" + environment.getJavaHome() + "\"").getBytes());
        } else {
            newSetEnv.write("#JAVA_HOME=\"\"".getBytes());
        }
        newSetEnv.write("\n".getBytes());
    }
}

