/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.hq.plugin.tcserver.plugin.serverconfig.resources.jdbc;

import com.springsource.hq.plugin.tcserver.plugin.serverconfig.AbstractXmlElementConverter;
import com.springsource.hq.plugin.tcserver.plugin.serverconfig.XmlElementConverter;
import com.springsource.hq.plugin.tcserver.serverconfig.resources.jdbc.DbcpConnectionPool;
import java.util.Properties;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbcpConnectionPoolConverter
extends AbstractXmlElementConverter
implements XmlElementConverter<DbcpConnectionPool> {
    private static final String DATA_SOURCE = "Data Source";
    private static final String TIME_BETWEEN_EVICTION_RUNS_MILLIS = "timeBetweenEvictionRunsMillis";
    private static final String TEST_ON_BORROW = "testOnBorrow";
    private static final String REMOVE_ABANDONED_TIMEOUT = "removeAbandonedTimeout";
    private static final String NUM_TESTS_PER_EVICTION_RUN = "numTestsPerEvictionRun";
    private static final String MIN_IDLE = "minIdle";
    private static final String MIN_EVICTABLE_IDLE_TIME_MILLIS = "minEvictableIdleTimeMillis";
    private static final String MAX_WAIT = "maxWait";
    private static final String MAX_OPEN_PREPARED_STATEMENTS = "maxOpenPreparedStatements";
    private static final String MAX_IDLE = "maxIdle";
    private static final String MAX_ACTIVE = "maxActive";
    private static final String INITIAL_SIZE = "initialSize";
    private static final String POOL_PREPARED_STATEMENTS = "poolPreparedStatements";
    private static final String LOG_ABANDONED = "logAbandoned";
    private static final String REMOVE_ABANDONED = "removeAbandoned";
    private static final String VALIDATION_QUERY = "validationQuery";
    private static final String TEST_WHILE_IDLE = "testWhileIdle";
    private static final String TEST_ON_RETURN = "testOnReturn";
    private static final String DEFAULT_CATALOG = "defaultCatalog";
    private static final String DEFAULT_TRANSACTION_ISOLATION = "defaultTransactionIsolation";
    private static final String DEFAULT_TRANSACTION_ISOLATION_DEFAULT = "DEFAULT";
    private static final String DEFAULT_READ_ONLY = "defaultReadOnly";
    private static final String DEFAULT_AUTO_COMMIT = "defaultAutoCommit";
    private static final String ACCESS_TO_UNDERLYING_CONNECTION_ALLOWED = "accessToUnderlyingConnectionAllowed";

    @Override
    public DbcpConnectionPool convert(Element resource, Properties catalinaProperties) {
        String timeBetweenEvictionRunsMillis;
        String testOnBorrow;
        String removeAbandonedTimeout;
        String numTestsPerEvictionRun;
        String minIdle;
        String minEvictableIdleTimeMillis;
        String maxWait;
        String maxOpenPreparedStatements;
        String maxIdle;
        String maxActive;
        String initialSize;
        String poolPreparedStatements;
        String logAbandoned;
        String removeAbandoned;
        String validationQuery;
        String testWhileIdle;
        String testOnReturn;
        String defaultTransactionIsolation;
        String defaultReadOnly;
        String defaultAutoCommit;
        DbcpConnectionPool connectionPool = new DbcpConnectionPool();
        String accessToUnderlyingConnectionAllowed = this.parseProperties(resource.getAttribute(ACCESS_TO_UNDERLYING_CONNECTION_ALLOWED), catalinaProperties);
        if (!"".equals(accessToUnderlyingConnectionAllowed)) {
            connectionPool.setAccessToUnderlyingConnectionAllowed(Boolean.valueOf(accessToUnderlyingConnectionAllowed));
        }
        if (!"".equals(defaultAutoCommit = this.parseProperties(resource.getAttribute(DEFAULT_AUTO_COMMIT), catalinaProperties))) {
            connectionPool.setDefaultAutoCommit(Boolean.valueOf(defaultAutoCommit));
        }
        if (!"".equals(defaultReadOnly = this.parseProperties(resource.getAttribute(DEFAULT_READ_ONLY), catalinaProperties))) {
            connectionPool.setDefaultReadOnly(Boolean.valueOf(defaultReadOnly));
        }
        if ("".equals(defaultTransactionIsolation = this.parseProperties(resource.getAttribute(DEFAULT_TRANSACTION_ISOLATION), catalinaProperties))) {
            connectionPool.setDefaultTransactionIsolation(DEFAULT_TRANSACTION_ISOLATION_DEFAULT);
        } else {
            connectionPool.setDefaultTransactionIsolation(defaultTransactionIsolation);
        }
        String defaultCatalog = this.parseProperties(resource.getAttribute(DEFAULT_CATALOG), catalinaProperties);
        if (!"".equals(defaultCatalog)) {
            connectionPool.setDefaultCatalog(defaultCatalog);
        }
        if (!"".equals(testOnReturn = this.parseProperties(resource.getAttribute(TEST_ON_RETURN), catalinaProperties))) {
            connectionPool.setTestOnReturn(Boolean.valueOf(testOnReturn));
        }
        if (!"".equals(testWhileIdle = this.parseProperties(resource.getAttribute(TEST_WHILE_IDLE), catalinaProperties))) {
            connectionPool.setTestWhileIdle(Boolean.valueOf(testWhileIdle));
        }
        if (!"".equals(validationQuery = this.parseProperties(resource.getAttribute(VALIDATION_QUERY), catalinaProperties))) {
            connectionPool.setValidationQuery(validationQuery);
        }
        if (!"".equals(removeAbandoned = this.parseProperties(resource.getAttribute(REMOVE_ABANDONED), catalinaProperties))) {
            connectionPool.setRemoveAbandoned(Boolean.valueOf(removeAbandoned));
        }
        if (!"".equals(logAbandoned = this.parseProperties(resource.getAttribute(LOG_ABANDONED), catalinaProperties))) {
            connectionPool.setLogAbandoned(Boolean.valueOf(logAbandoned));
        }
        if (!"".equals(poolPreparedStatements = this.parseProperties(resource.getAttribute(POOL_PREPARED_STATEMENTS), catalinaProperties))) {
            connectionPool.setPoolPreparedStatements(Boolean.valueOf(poolPreparedStatements));
        }
        if (!"".equals(initialSize = this.parseProperties(resource.getAttribute(INITIAL_SIZE), catalinaProperties))) {
            try {
                connectionPool.setInitialSize(Long.valueOf(initialSize));
            }
            catch (NumberFormatException numberFormatException) {
                this.logNonNumericValue(DATA_SOURCE, INITIAL_SIZE, initialSize);
            }
        }
        if (!"".equals(maxActive = this.parseProperties(resource.getAttribute(MAX_ACTIVE), catalinaProperties))) {
            try {
                connectionPool.setMaxActive(Long.valueOf(maxActive));
            }
            catch (NumberFormatException numberFormatException) {
                this.logNonNumericValue(DATA_SOURCE, MAX_ACTIVE, maxActive);
            }
        }
        if (!"".equals(maxIdle = this.parseProperties(resource.getAttribute(MAX_IDLE), catalinaProperties))) {
            try {
                connectionPool.setMaxIdle(Long.valueOf(maxIdle));
            }
            catch (NumberFormatException numberFormatException) {
                this.logNonNumericValue(DATA_SOURCE, MAX_IDLE, maxIdle);
            }
        }
        if (!"".equals(maxOpenPreparedStatements = this.parseProperties(resource.getAttribute(MAX_OPEN_PREPARED_STATEMENTS), catalinaProperties))) {
            try {
                connectionPool.setMaxOpenPreparedStatements(Long.valueOf(maxOpenPreparedStatements));
            }
            catch (NumberFormatException numberFormatException) {
                this.logNonNumericValue(DATA_SOURCE, MAX_OPEN_PREPARED_STATEMENTS, maxOpenPreparedStatements);
            }
        }
        if (!"".equals(maxWait = this.parseProperties(resource.getAttribute(MAX_WAIT), catalinaProperties))) {
            try {
                connectionPool.setMaxWait(Long.valueOf(maxWait));
            }
            catch (NumberFormatException numberFormatException) {
                this.logNonNumericValue(DATA_SOURCE, MAX_WAIT, maxWait);
            }
        }
        if (!"".equals(minEvictableIdleTimeMillis = this.parseProperties(resource.getAttribute(MIN_EVICTABLE_IDLE_TIME_MILLIS), catalinaProperties))) {
            try {
                connectionPool.setMinEvictableIdleTimeMillis(Long.valueOf(minEvictableIdleTimeMillis));
            }
            catch (NumberFormatException numberFormatException) {
                this.logNonNumericValue(DATA_SOURCE, MIN_EVICTABLE_IDLE_TIME_MILLIS, minEvictableIdleTimeMillis);
            }
        }
        if (!"".equals(minIdle = this.parseProperties(resource.getAttribute(MIN_IDLE), catalinaProperties))) {
            try {
                connectionPool.setMinIdle(Long.valueOf(minIdle));
            }
            catch (NumberFormatException numberFormatException) {
                this.logNonNumericValue(DATA_SOURCE, MIN_IDLE, minIdle);
            }
        }
        if (!"".equals(numTestsPerEvictionRun = this.parseProperties(resource.getAttribute(NUM_TESTS_PER_EVICTION_RUN), catalinaProperties))) {
            try {
                connectionPool.setNumTestsPerEvictionRun(Long.valueOf(numTestsPerEvictionRun));
            }
            catch (NumberFormatException numberFormatException) {
                this.logNonNumericValue(DATA_SOURCE, NUM_TESTS_PER_EVICTION_RUN, numTestsPerEvictionRun);
            }
        }
        if (!"".equals(removeAbandonedTimeout = this.parseProperties(resource.getAttribute(REMOVE_ABANDONED_TIMEOUT), catalinaProperties))) {
            try {
                connectionPool.setRemoveAbandonedTimeout(Long.valueOf(removeAbandonedTimeout));
            }
            catch (NumberFormatException numberFormatException) {
                this.logNonNumericValue(DATA_SOURCE, REMOVE_ABANDONED_TIMEOUT, removeAbandonedTimeout);
            }
        }
        if (!"".equals(testOnBorrow = this.parseProperties(resource.getAttribute(TEST_ON_BORROW), catalinaProperties))) {
            connectionPool.setTestOnBorrow(Boolean.valueOf(testOnBorrow));
        }
        if (!"".equals(timeBetweenEvictionRunsMillis = this.parseProperties(resource.getAttribute(TIME_BETWEEN_EVICTION_RUNS_MILLIS), catalinaProperties))) {
            try {
                connectionPool.setTimeBetweenEvictionRunsMillis(Long.valueOf(timeBetweenEvictionRunsMillis));
            }
            catch (NumberFormatException numberFormatException) {
                this.logNonNumericValue(DATA_SOURCE, TIME_BETWEEN_EVICTION_RUNS_MILLIS, timeBetweenEvictionRunsMillis);
            }
        }
        return connectionPool;
    }

    @Override
    public void convert(Document document, Element resource, DbcpConnectionPool from, Properties catalinaProperties) {
        this.setAttribute(resource, ACCESS_TO_UNDERLYING_CONNECTION_ALLOWED, from.getAccessToUnderlyingConnectionAllowed(), catalinaProperties, false);
        this.setAttribute(resource, DEFAULT_AUTO_COMMIT, from.getDefaultAutoCommit(), catalinaProperties, false);
        this.setAttribute(resource, DEFAULT_CATALOG, from.getDefaultCatalog(), catalinaProperties, false);
        this.setAttribute(resource, DEFAULT_READ_ONLY, from.getDefaultReadOnly(), catalinaProperties, false);
        if (!DEFAULT_TRANSACTION_ISOLATION_DEFAULT.equals(from.getDefaultTransactionIsolation())) {
            this.setAttribute(resource, DEFAULT_TRANSACTION_ISOLATION, from.getDefaultTransactionIsolation(), catalinaProperties, false);
        }
        this.setAttribute(resource, INITIAL_SIZE, from.getInitialSize(), catalinaProperties, false);
        this.setAttribute(resource, LOG_ABANDONED, from.getLogAbandoned(), catalinaProperties, false);
        this.setAttribute(resource, MAX_ACTIVE, from.getMaxActive(), catalinaProperties, false);
        this.setAttribute(resource, MAX_IDLE, from.getMaxIdle(), catalinaProperties, false);
        this.setAttribute(resource, MAX_OPEN_PREPARED_STATEMENTS, from.getMaxOpenPreparedStatements(), catalinaProperties, false);
        this.setAttribute(resource, MAX_WAIT, from.getMaxWait(), catalinaProperties, false);
        this.setAttribute(resource, MIN_EVICTABLE_IDLE_TIME_MILLIS, from.getMinEvictableIdleTimeMillis(), catalinaProperties, false);
        this.setAttribute(resource, MIN_IDLE, from.getMinIdle(), catalinaProperties, false);
        this.setAttribute(resource, NUM_TESTS_PER_EVICTION_RUN, from.getNumTestsPerEvictionRun(), catalinaProperties, false);
        this.setAttribute(resource, POOL_PREPARED_STATEMENTS, from.getPoolPreparedStatements(), catalinaProperties, false);
        this.setAttribute(resource, REMOVE_ABANDONED, from.getRemoveAbandoned(), catalinaProperties, false);
        this.setAttribute(resource, REMOVE_ABANDONED_TIMEOUT, from.getRemoveAbandonedTimeout(), catalinaProperties, false);
        this.setAttribute(resource, TEST_ON_BORROW, from.getTestOnBorrow(), catalinaProperties, false);
        this.setAttribute(resource, TEST_ON_RETURN, from.getTestOnReturn(), catalinaProperties, false);
        this.setAttribute(resource, TEST_WHILE_IDLE, from.getTestWhileIdle(), catalinaProperties, false);
        this.setAttribute(resource, TIME_BETWEEN_EVICTION_RUNS_MILLIS, from.getTimeBetweenEvictionRunsMillis(), catalinaProperties, false);
        this.setAttribute(resource, VALIDATION_QUERY, from.getValidationQuery(), catalinaProperties, false);
    }
}

