/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.hq.plugin.tcserver.plugin.serverconfig.resources.jdbc;

import com.springsource.hq.plugin.tcserver.plugin.serverconfig.AbstractXmlElementConverter;
import com.springsource.hq.plugin.tcserver.plugin.serverconfig.XmlElementConverter;
import com.springsource.hq.plugin.tcserver.serverconfig.resources.jdbc.TomcatConnectionPool;
import java.util.Properties;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TomcatConnectionPoolConverter
extends AbstractXmlElementConverter
implements XmlElementConverter<TomcatConnectionPool> {
    private static final String DATA_SOURCE = "Data Source";
    private static final String REMOVE_ABANDONED_TIMEOUT = "removeAbandonedTimeout";
    private static final String MIN_EVICTABLE_IDLE_TIME_MILLIS = "minEvictableIdleTimeMillis";
    private static final String TIME_BETWEEN_EVICTION_RUNS_MILLIS = "timeBetweenEvictionRunsMillis";
    private static final String TEST_ON_BORROW = "testOnBorrow";
    private static final String MAX_WAIT = "maxWait";
    private static final String MIN_IDLE = "minIdle";
    private static final String INITIAL_SIZE = "initialSize";
    private static final String MAX_IDLE = "maxIdle";
    private static final String MAX_ACTIVE = "maxActive";
    private static final String DEFAULT_AUTO_COMMIT = "defaultAutoCommit";
    private static final String LOG_ABANDONED = "logAbandoned";
    private static final String REMOVE_ABANDONED = "removeAbandoned";
    private static final String VALIDATION_QUERY = "validationQuery";
    private static final String TEST_WHILE_IDLE = "testWhileIdle";
    private static final String TEST_ON_RETURN = "testOnReturn";
    private static final String DEFAULT_CATALOG = "defaultCatalog";
    private static final String DEFAULT_TRANSACTION_ISOLATION = "defaultTransactionIsolation";
    private static final String DEFAULT_TRANSACTION_ISOLATION_DEFAULT = "DEFAULT";
    private static final String DEFAULT_READ_ONLY = "defaultReadOnly";
    private static final String JDBC_INTERCEPTORS = "jdbcInterceptors";
    private static final String VALIDATION_INTERVAL = "validationInterval";
    private static final String USE_EQUALS = "useEquals";
    private static final String JMX_ENABLED = "jmxEnabled";
    private static final String INIT_SQL = "initSQL";
    private static final String FAIR_QUEUE = "fairQueue";

    @Override
    public void convert(Document document, Element resource, TomcatConnectionPool from, Properties catalinaProperties) {
        this.setAttribute(resource, FAIR_QUEUE, from.getFairQueue(), catalinaProperties, false);
        this.setAttribute(resource, INIT_SQL, from.getInitSQL(), catalinaProperties, false);
        this.setAttribute(resource, JMX_ENABLED, from.getJmxEnabled(), catalinaProperties, false);
        this.setAttribute(resource, USE_EQUALS, from.getUseEquals(), catalinaProperties, false);
        this.setAttribute(resource, VALIDATION_INTERVAL, from.getValidationInterval(), catalinaProperties, false);
        this.setAttribute(resource, JDBC_INTERCEPTORS, from.getJdbcInterceptors(), catalinaProperties, false);
        this.setAttribute(resource, DEFAULT_AUTO_COMMIT, from.getDefaultAutoCommit(), catalinaProperties, false);
        this.setAttribute(resource, DEFAULT_CATALOG, from.getDefaultCatalog(), catalinaProperties, false);
        this.setAttribute(resource, DEFAULT_READ_ONLY, from.getDefaultReadOnly(), catalinaProperties, false);
        if (!DEFAULT_TRANSACTION_ISOLATION_DEFAULT.equals(from.getDefaultTransactionIsolation())) {
            this.setAttribute(resource, DEFAULT_TRANSACTION_ISOLATION, from.getDefaultTransactionIsolation(), catalinaProperties, false);
        }
        this.setAttribute(resource, INITIAL_SIZE, from.getInitialSize(), catalinaProperties, false);
        this.setAttribute(resource, LOG_ABANDONED, from.getLogAbandoned(), catalinaProperties, false);
        this.setAttribute(resource, MAX_ACTIVE, from.getMaxActive(), catalinaProperties, false);
        this.setAttribute(resource, MAX_IDLE, from.getMaxIdle(), catalinaProperties, false);
        this.setAttribute(resource, MAX_WAIT, from.getMaxWait(), catalinaProperties, false);
        this.setAttribute(resource, MIN_EVICTABLE_IDLE_TIME_MILLIS, from.getMinEvictableIdleTimeMillis(), catalinaProperties, false);
        this.setAttribute(resource, MIN_IDLE, from.getMinIdle(), catalinaProperties, false);
        this.setAttribute(resource, REMOVE_ABANDONED, from.getRemoveAbandoned(), catalinaProperties, false);
        this.setAttribute(resource, REMOVE_ABANDONED_TIMEOUT, from.getRemoveAbandonedTimeout(), catalinaProperties, false);
        this.setAttribute(resource, TEST_ON_BORROW, from.getTestOnBorrow(), catalinaProperties, false);
        this.setAttribute(resource, TEST_ON_RETURN, from.getTestOnReturn(), catalinaProperties, false);
        this.setAttribute(resource, TEST_WHILE_IDLE, from.getTestWhileIdle(), catalinaProperties, false);
        this.setAttribute(resource, TIME_BETWEEN_EVICTION_RUNS_MILLIS, from.getTimeBetweenEvictionRunsMillis(), catalinaProperties, false);
        this.setAttribute(resource, VALIDATION_QUERY, from.getValidationQuery(), catalinaProperties, false);
    }

    @Override
    public TomcatConnectionPool convert(Element resource, Properties catalinaProperties) {
        String removeAbandonedTimeout;
        String minEvictableIdleTimeMillis;
        String timeBetweenEvictionRunsMillis;
        String testOnBorrow;
        String maxWait;
        String minIdle;
        String initialSize;
        String maxIdle;
        String maxActive;
        String defaultAutoCommit;
        String logAbandoned;
        String removeAbandoned;
        String validationQuery;
        String testWhileIdle;
        String testOnReturn;
        String defaultTransactionIsolation;
        String defaultReadOnly;
        String jdbcInterceptors;
        String validationInterval;
        String useEquals;
        String jmxEnabled;
        String initSQL;
        TomcatConnectionPool connectionPool = new TomcatConnectionPool();
        String fairQueue = this.parseProperties(resource.getAttribute(FAIR_QUEUE), catalinaProperties);
        if (!"".equals(fairQueue)) {
            connectionPool.setFairQueue(Boolean.valueOf(fairQueue));
        }
        if (!"".equals(initSQL = this.parseProperties(resource.getAttribute(INIT_SQL), catalinaProperties))) {
            connectionPool.setInitSQL(initSQL);
        }
        if (!"".equals(jmxEnabled = this.parseProperties(resource.getAttribute(JMX_ENABLED), catalinaProperties))) {
            connectionPool.setJmxEnabled(Boolean.valueOf(jmxEnabled));
        }
        if (!"".equals(useEquals = this.parseProperties(resource.getAttribute(USE_EQUALS), catalinaProperties))) {
            connectionPool.setUseEquals(Boolean.valueOf(useEquals));
        }
        if (!"".equals(validationInterval = this.parseProperties(resource.getAttribute(VALIDATION_INTERVAL), catalinaProperties))) {
            try {
                connectionPool.setValidationInterval(Long.valueOf(validationInterval));
            }
            catch (NumberFormatException numberFormatException) {
                this.logNonNumericValue(DATA_SOURCE, VALIDATION_INTERVAL, validationInterval);
            }
        }
        if (!"".equals(jdbcInterceptors = this.parseProperties(resource.getAttribute(JDBC_INTERCEPTORS), catalinaProperties))) {
            connectionPool.setJdbcInterceptors(jdbcInterceptors);
        }
        if (!"".equals(defaultReadOnly = this.parseProperties(resource.getAttribute(DEFAULT_READ_ONLY), catalinaProperties))) {
            connectionPool.setDefaultReadOnly(Boolean.valueOf(defaultReadOnly));
        }
        if ("".equals(defaultTransactionIsolation = this.parseProperties(resource.getAttribute(DEFAULT_TRANSACTION_ISOLATION), catalinaProperties))) {
            connectionPool.setDefaultTransactionIsolation(DEFAULT_TRANSACTION_ISOLATION_DEFAULT);
        } else {
            connectionPool.setDefaultTransactionIsolation(defaultTransactionIsolation);
        }
        String defaultCatalog = this.parseProperties(resource.getAttribute(DEFAULT_CATALOG), catalinaProperties);
        if (!"".equals(defaultCatalog)) {
            connectionPool.setDefaultCatalog(defaultCatalog);
        }
        if (!"".equals(testOnReturn = this.parseProperties(resource.getAttribute(TEST_ON_RETURN), catalinaProperties))) {
            connectionPool.setTestOnReturn(Boolean.valueOf(testOnReturn));
        }
        if (!"".equals(testWhileIdle = this.parseProperties(resource.getAttribute(TEST_WHILE_IDLE), catalinaProperties))) {
            connectionPool.setTestWhileIdle(Boolean.valueOf(testWhileIdle));
        }
        if (!"".equals(validationQuery = this.parseProperties(resource.getAttribute(VALIDATION_QUERY), catalinaProperties))) {
            connectionPool.setValidationQuery(validationQuery);
        }
        if (!"".equals(removeAbandoned = this.parseProperties(resource.getAttribute(REMOVE_ABANDONED), catalinaProperties))) {
            connectionPool.setRemoveAbandoned(Boolean.valueOf(removeAbandoned));
        }
        if (!"".equals(logAbandoned = this.parseProperties(resource.getAttribute(LOG_ABANDONED), catalinaProperties))) {
            connectionPool.setLogAbandoned(Boolean.valueOf(logAbandoned));
        }
        if (!"".equals(defaultAutoCommit = this.parseProperties(resource.getAttribute(DEFAULT_AUTO_COMMIT), catalinaProperties))) {
            connectionPool.setDefaultAutoCommit(Boolean.valueOf(defaultAutoCommit));
        }
        if (!"".equals(maxActive = this.parseProperties(resource.getAttribute(MAX_ACTIVE), catalinaProperties))) {
            try {
                connectionPool.setMaxActive(Long.valueOf(maxActive));
            }
            catch (NumberFormatException numberFormatException) {
                this.logNonNumericValue(DATA_SOURCE, MAX_ACTIVE, maxActive);
            }
        }
        if (!"".equals(maxIdle = this.parseProperties(resource.getAttribute(MAX_IDLE), catalinaProperties))) {
            try {
                connectionPool.setMaxIdle(Long.valueOf(maxIdle));
            }
            catch (NumberFormatException numberFormatException) {
                this.logNonNumericValue(DATA_SOURCE, MAX_IDLE, maxIdle);
            }
        }
        if (!"".equals(initialSize = this.parseProperties(resource.getAttribute(INITIAL_SIZE), catalinaProperties))) {
            try {
                connectionPool.setInitialSize(Long.valueOf(initialSize));
            }
            catch (NumberFormatException numberFormatException) {
                this.logNonNumericValue(DATA_SOURCE, INITIAL_SIZE, initialSize);
            }
        }
        if (!"".equals(minIdle = this.parseProperties(resource.getAttribute(MIN_IDLE), catalinaProperties))) {
            try {
                connectionPool.setMinIdle(Long.valueOf(minIdle));
            }
            catch (NumberFormatException numberFormatException) {
                this.logNonNumericValue(DATA_SOURCE, MIN_IDLE, minIdle);
            }
        }
        if (!"".equals(maxWait = this.parseProperties(resource.getAttribute(MAX_WAIT), catalinaProperties))) {
            try {
                connectionPool.setMaxWait(Long.valueOf(maxWait));
            }
            catch (NumberFormatException numberFormatException) {
                this.logNonNumericValue(DATA_SOURCE, MAX_WAIT, maxWait);
            }
        }
        if (!"".equals(testOnBorrow = this.parseProperties(resource.getAttribute(TEST_ON_BORROW), catalinaProperties))) {
            connectionPool.setTestOnBorrow(Boolean.valueOf(testOnBorrow));
        }
        if (!"".equals(timeBetweenEvictionRunsMillis = this.parseProperties(resource.getAttribute(TIME_BETWEEN_EVICTION_RUNS_MILLIS), catalinaProperties))) {
            try {
                connectionPool.setTimeBetweenEvictionRunsMillis(Long.valueOf(timeBetweenEvictionRunsMillis));
            }
            catch (NumberFormatException numberFormatException) {
                this.logNonNumericValue(DATA_SOURCE, TIME_BETWEEN_EVICTION_RUNS_MILLIS, timeBetweenEvictionRunsMillis);
            }
        }
        if (!"".equals(minEvictableIdleTimeMillis = this.parseProperties(resource.getAttribute(MIN_EVICTABLE_IDLE_TIME_MILLIS), catalinaProperties))) {
            try {
                connectionPool.setMinEvictableIdleTimeMillis(Long.valueOf(minEvictableIdleTimeMillis));
            }
            catch (NumberFormatException numberFormatException) {
                this.logNonNumericValue(DATA_SOURCE, MIN_EVICTABLE_IDLE_TIME_MILLIS, minEvictableIdleTimeMillis);
            }
        }
        if (!"".equals(removeAbandonedTimeout = this.parseProperties(resource.getAttribute(REMOVE_ABANDONED_TIMEOUT), catalinaProperties))) {
            try {
                connectionPool.setRemoveAbandonedTimeout(Long.valueOf(removeAbandonedTimeout));
            }
            catch (NumberFormatException numberFormatException) {
                this.logNonNumericValue(DATA_SOURCE, REMOVE_ABANDONED_TIMEOUT, removeAbandonedTimeout);
            }
        }
        return connectionPool;
    }
}

