/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.rabbitmq.collect;

import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.plugin.rabbitmq.collect.RabbitMQDefaultCollector;
import org.hyperic.hq.plugin.rabbitmq.core.HypericRabbitAdmin;
import org.hyperic.hq.plugin.rabbitmq.core.RabbitExchange;

public class ExchangeCollector
extends RabbitMQDefaultCollector {
    private static final Log logger = LogFactory.getLog(ExchangeCollector.class);

    public void collect(HypericRabbitAdmin rabbitAdmin) {
        Properties props = this.getProperties();
        String vhost = (String)props.get("vhost");
        String exch = (String)props.get("exchange");
        if (exch == null) {
            exch = "";
        }
        if (logger.isDebugEnabled()) {
            String node = (String)props.get("node");
            logger.debug((Object)("[collect] exch='" + exch + "' vhost='" + vhost + "' node='" + node + "'"));
        }
        try {
            RabbitExchange e = rabbitAdmin.getExchange(vhost, exch);
            this.setAvailability(true);
            if (e.getMessageStatsIn() != null) {
                this.setValue("in_publish_details", e.getMessageStatsIn().getPublishDetails().get("rate"));
            } else {
                this.setValue("in_publish_details", 0.0);
            }
            if (e.getMessageStatsOut() != null) {
                this.setValue("out_publish_details", e.getMessageStatsOut().getPublishDetails().get("rate"));
            } else {
                this.setValue("out_publish_details", 0.0);
            }
        }
        catch (Exception ex) {
            this.setAvailability(false);
            logger.debug((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    public Log getLog() {
        return logger;
    }
}

