/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.rabbitmq.collect;

import java.util.Map;
import org.hyperic.hq.plugin.rabbitmq.collect.RabbitMQDefaultCollector;
import org.hyperic.hq.plugin.rabbitmq.core.HypericRabbitAdmin;
import org.hyperic.hq.plugin.rabbitmq.core.MessageStats;
import org.hyperic.hq.plugin.rabbitmq.core.RabbitStatsObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RabbitStatsCollector
extends RabbitMQDefaultCollector {
    @Override
    public void collect(HypericRabbitAdmin rabbitAdmin) {
        RabbitStatsObject o = this.collectStats(rabbitAdmin);
        if (o != null) {
            this.processMessageStatsMetrics(o.getMessageStats());
        }
    }

    public abstract RabbitStatsObject collectStats(HypericRabbitAdmin var1);

    private void processMessageStatsMetrics(MessageStats stats) {
        if (stats != null) {
            this.setVal("publishDetails", stats.getPublishDetails());
            this.setVal("confirmDetails", stats.getConfirmDetails());
            this.setVal("deliverDetails", stats.getDeliverDetails());
            this.setVal("ackDetails", stats.getAckDetails());
            this.setVal("getDetails", stats.getGetDetails());
            this.setVal("getNoAckDetails", stats.getGetNoAckDetails());
            this.setVal("deliverNoAckDetails", stats.getDeliverNoAckDetails());
            this.setVal("deliverGetDetails", stats.getDeliverGetDetails());
        }
    }

    private void setVal(String string, Map<String, Double> detail) {
        if (detail != null) {
            this.setValue(string, detail.get("rate"));
        } else {
            this.setValue(string, 0.0);
        }
    }
}

