/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.rabbitmq.detect;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;

public class RabbitVersionDetector {
    private static final Log logger = LogFactory.getLog(RabbitVersionDetector.class);

    public static String detectVersion(String rabbitHome, String node) {
        String version = RabbitVersionDetector.inferVersionFromRabbitmqctl(rabbitHome);
        if (version == null) {
            version = RabbitVersionDetector.inferVersionFromRabbitAppFile(rabbitHome);
        }
        Assert.notNull((Object)version, (String)"RabbitMQ version must not be null.");
        Assert.hasText((String)version, (String)"RabbitMQ version must have text.");
        return version;
    }

    protected static String inferVersionFromRabbitmqctl(String rabbitHome) {
        Assert.hasText((String)rabbitHome);
        String version = null;
        try {
            Process process = Runtime.getRuntime().exec("rabbitmqctl status");
            BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String input = null;
            while ((input = in.readLine()) != null) {
                if (!input.contains("{rabbit,\"RabbitMQ\",")) continue;
                Pattern p = Pattern.compile("\"RabbitMQ\",\\s*\"(\\d+\\.\\d+(?:\\.\\d+)?)\"");
                Matcher m = p.matcher(input);
                version = m.find() ? m.group(1) : null;
            }
            in.close();
        }
        catch (IOException e) {
            logger.info((Object)("Unable to dermine version from rabbitmqctl " + e));
        }
        return version;
    }

    protected static String inferVersionFromRabbitAppFile(String rabbitHome) {
        Assert.hasText((String)rabbitHome);
        String version = null;
        StringBuilder app = new StringBuilder(rabbitHome).append(File.separator).append("ebin").append(File.separator);
        try {
            File fromSrc;
            File file = null;
            File fromBin = new File(app.append("rabbit.app").toString());
            if (fromBin.exists()) {
                file = fromBin;
            }
            if ((fromSrc = new File(app.append("rabbit_app.in").toString())).exists()) {
                file = fromSrc;
            }
            if (file != null && file.exists()) {
                BufferedReader in = new BufferedReader(new FileReader(file));
                String input = null;
                while ((input = in.readLine()) != null) {
                    if (!input.contains("{vsn")) continue;
                    Pattern p = Pattern.compile("[{]vsn,\\s*\"(\\d+\\.\\d+(?:\\.\\d+)?)\"}");
                    Matcher m = p.matcher(input);
                    version = m.find() ? m.group(1) : null;
                }
                in.close();
            }
        }
        catch (IOException e) {
            logger.info((Object)("Unable to dermine version from rabbitmqclt " + e));
        }
        return version;
    }
}

