/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.storage.file;

import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import org.eclipse.jgit.errors.ObjectWritingException;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.storage.file.FileObjectDatabase;
import org.eclipse.jgit.storage.file.ObjectDirectoryPackParser;
import org.eclipse.jgit.storage.file.WriteConfig;
import org.eclipse.jgit.transport.PackParser;
import org.eclipse.jgit.util.FileUtils;

class ObjectDirectoryInserter
extends ObjectInserter {
    private final FileObjectDatabase db;
    private final WriteConfig config;
    private Deflater deflate;

    ObjectDirectoryInserter(FileObjectDatabase dest, Config cfg) {
        this.db = dest;
        this.config = cfg.get(WriteConfig.KEY);
    }

    public ObjectId insert(int type, long len, InputStream is) throws IOException {
        MessageDigest md = this.digest();
        File tmp = this.toTemp(md, type, len, is);
        ObjectId id = ObjectId.fromRaw(md.digest());
        switch (this.db.insertUnpackedObject(tmp, id, false)) {
            case INSERTED: 
            case EXISTS_PACKED: 
            case EXISTS_LOOSE: {
                return id;
            }
        }
        File dst = this.db.fileFor(id);
        throw new ObjectWritingException("Unable to create new object: " + dst);
    }

    public PackParser newPackParser(InputStream in) throws IOException {
        return new ObjectDirectoryPackParser(this.db, in);
    }

    public void flush() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        if (this.deflate != null) {
            try {
                this.deflate.end();
            }
            finally {
                this.deflate = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File toTemp(MessageDigest md, int type, long len, InputStream is) throws IOException, FileNotFoundException, Error {
        boolean delete = true;
        File tmp = this.newTempFile();
        try {
            FileOutputStream fOut = new FileOutputStream(tmp);
            try {
                OutputStream out = fOut;
                if (this.config.getFSyncObjectFiles()) {
                    out = Channels.newOutputStream(fOut.getChannel());
                }
                DeflaterOutputStream cOut = this.compress(out);
                DigestOutputStream dOut = new DigestOutputStream(cOut, md);
                this.writeHeader(dOut, type, len);
                byte[] buf = this.buffer();
                while (len > 0L) {
                    int n = is.read(buf, 0, (int)Math.min(len, (long)buf.length));
                    if (n <= 0) {
                        throw ObjectDirectoryInserter.shortInput(len);
                    }
                    dOut.write(buf, 0, n);
                    len -= (long)n;
                }
                dOut.flush();
                cOut.finish();
            }
            finally {
                if (this.config.getFSyncObjectFiles()) {
                    fOut.getChannel().force(true);
                }
                fOut.close();
            }
            delete = false;
            File file = tmp;
            return file;
        }
        finally {
            if (delete) {
                FileUtils.delete(tmp);
            }
        }
    }

    void writeHeader(OutputStream out, int type, long len) throws IOException {
        out.write(Constants.encodedTypeString(type));
        out.write(32);
        out.write(Constants.encodeASCII(len));
        out.write(0);
    }

    File newTempFile() throws IOException {
        return File.createTempFile("noz", null, this.db.getDirectory());
    }

    DeflaterOutputStream compress(OutputStream out) {
        if (this.deflate == null) {
            this.deflate = new Deflater(this.config.getCompression());
        } else {
            this.deflate.reset();
        }
        return new DeflaterOutputStream(out, this.deflate);
    }

    private static EOFException shortInput(long missing) {
        return new EOFException("Input did not match supplied length. " + missing + " bytes are missing.");
    }
}

