/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Comparator;

public final class JavaBeanPropertyComparator
implements Comparator {
    public static final int ASCENDING = 0;
    public static final int DESCENDING = 1;
    private String propertyName;
    private int sortOrder = 0;

    public JavaBeanPropertyComparator(String propertyName) {
        this(propertyName, 0);
    }

    public JavaBeanPropertyComparator(String propertyName, int sortOrder) {
        if (null == propertyName || 0 == propertyName.length()) {
            throw new IllegalArgumentException("propertyName cannot be null or empty");
        }
        this.propertyName = propertyName;
        this.sortOrder = sortOrder;
    }

    public int compare(Object o1, Object o2) {
        String val1 = this.getProperty(o1);
        String val2 = this.getProperty(o2);
        int retVal = null == val1 ? (null == val2 ? 0 : 1) : (null == val2 ? -1 : val1.compareTo(val2));
        if (0 == this.sortOrder) {
            return retVal;
        }
        return 0 - retVal;
    }

    public boolean equals(Object obj) {
        try {
            JavaBeanPropertyComparator that = (JavaBeanPropertyComparator)obj;
            return this.propertyName.equals(that.propertyName) && this.sortOrder == that.sortOrder;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    private String getProperty(Object obj) {
        try {
            PropertyDescriptor pd = new PropertyDescriptor(this.propertyName, obj.getClass());
            Method m = pd.getReadMethod();
            Object value = m.invoke(obj, (Object[])null);
            return String.valueOf(value);
        }
        catch (IntrospectionException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            return null;
        }
    }

    public static void main(String[] args) {
        JavaBeanPropertyComparator asc = new JavaBeanPropertyComparator("foo", 0);
        JavaBeanPropertyComparator desc = new JavaBeanPropertyComparator("foo", 1);
        Foo foo1 = new Foo("aaa");
        Foo foo2 = new Foo("aaa");
        Foo foo3 = new Foo("bbb");
        NoFoo noFoo = new NoFoo();
        System.out.println("ascending compare(foo1, foo2)=" + asc.compare(foo1, foo2));
        System.out.println("ascending compare(foo1, foo3)=" + asc.compare(foo1, foo3));
        System.out.println("ascending compare(foo1, noFoo)=" + asc.compare(foo1, noFoo));
        System.out.println("descending compare(foo1, foo2)=" + desc.compare(foo1, foo2));
        System.out.println("descending compare(foo1, foo3)=" + desc.compare(foo1, foo3));
        System.out.println("descending compare(foo1, noFoo)=" + desc.compare(foo1, noFoo));
    }

    private static class NoFoo {
    }

    private static class Foo {
        private String foo;

        public Foo(String foo) {
            this.foo = foo;
        }

        public void setFoo(String foo) {
            this.foo = foo;
        }

        public String getFoo() {
            return this.foo;
        }
    }
}

