/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.config;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.hyperic.util.config.ConfigOption;
import org.hyperic.util.config.InvalidOptionValueException;

public class EnumerationConfigOption
extends ConfigOption
implements Serializable {
    private List _values = new ArrayList();

    public EnumerationConfigOption(String optName, String optDesc, String defValue, String[] enumValues) {
        super(optName, optDesc, defValue);
        for (int i = 0; i < enumValues.length; ++i) {
            if (enumValues[i] == null || enumValues[i].length() <= 0) continue;
            this._values.add(enumValues[i]);
        }
    }

    public EnumerationConfigOption(String optName, String optDesc, String defValue, String[] enumValues, String confirm) {
        this(optName, optDesc, defValue, enumValues);
        this.setConfirm(confirm);
    }

    public void checkOptionIsValid(String value) throws InvalidOptionValueException {
        if (!this._values.contains(value)) {
            throw this.invalidOption("must be one of: " + this._values);
        }
    }

    public String getDefault() {
        String defVal = super.getDefault();
        if (defVal == null && this._values.size() != 0) {
            defVal = (String)this._values.get(0);
        }
        return defVal;
    }

    public void addValue(String option) {
        this._values.add(option);
    }

    public List getValues() {
        return this._values;
    }
}

