/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class PointbaseSequence {
    private static final String CREATE_SEQUENCE_TABLE = "CREATE TABLE COV_SEQUENCE (NAME VARCHAR(128) PRIMARY KEY, NEXTVAL INTEGER NOT NULL, INCREMENT INTEGER NOT NULL)";
    private static final String DROP_SEQUENCE_TABLE = "DROP TABLE COV_SEQUENCE";
    private static final String SELECT_SEQUENCE_COUNT = "SELECT COUNT(*) FROM COV_SEQUENCE";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanupSequences(Connection conn) throws SQLException {
        ResultSet rset = null;
        Statement stmt = null;
        Statement stmtQuery = conn.createStatement();
        try {
            rset = stmtQuery.executeQuery(SELECT_SEQUENCE_COUNT);
            if (rset.next()) {
                int cnt = rset.getInt(1);
                rset.close();
                if (cnt == 0) {
                    stmt = conn.createStatement();
                    stmt.executeUpdate(DROP_SEQUENCE_TABLE);
                }
            }
        }
        catch (SQLException e) {
        }
        finally {
            if (rset != null) {
                rset.close();
            }
            if (stmt != null) {
                stmt.close();
            }
            if (stmtQuery != null) {
                stmtQuery.close();
            }
        }
    }

    public static void create(Connection conn, String name, int startVal, int increment) throws SQLException {
        PointbaseSequence.initSequences(conn);
        Statement stmt = null;
        try {
            stmt = conn.createStatement();
            stmt.executeUpdate(PointbaseSequence.getCreateCommand(name, startVal, increment));
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    public static void drop(Connection conn, String name) throws SQLException {
        Statement stmt = null;
        try {
            stmt = conn.createStatement();
            stmt.executeUpdate("DELETE FROM COV_SEQUENCE WHERE NAME = '" + name.toUpperCase() + '\'');
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
        PointbaseSequence.cleanupSequences(conn);
    }

    public static String getCreateCommand(String name, int startVal, int increment) {
        return "INSERT INTO COV_SEQUENCE VALUES ('" + name.toUpperCase() + "', " + startVal + ", " + increment + ')';
    }

    public static String getDropCommand(String name) {
        return "DELETE FROM COV_SEQUENCE WHERE NAME = '" + name.toUpperCase() + '\'';
    }

    public static String getIncrementCommand(String name, int increment) {
        return "UPDATE COV_SEQUENCE SET NEXTVAL = NEXTVAL + " + increment + " WHERE NAME = '" + name.toUpperCase() + '\'';
    }

    public static String getSelectNextValCommand(String name) {
        return "SELECT NEXTVAL FROM COV_SEQUENCE WHERE NAME = '" + name.toUpperCase() + '\'';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initSequences(Connection conn) throws SQLException {
        Statement stmt = conn.createStatement();
        try {
            stmt.executeUpdate(CREATE_SEQUENCE_TABLE);
        }
        catch (SQLException sQLException) {
        }
        finally {
            stmt.close();
        }
    }
}

