/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.security;

import java.lang.reflect.Method;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.Provider;
import java.security.Security;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.util.security.DbKeyStoreSpi;
import org.hyperic.util.security.DbKeystoreManager;

public class DbKeyStore
extends KeyStore {
    private static Log log = LogFactory.getLog(DbKeyStore.class);

    protected DbKeyStore(KeyStoreSpi keyStoreSpi, Provider provider, String type) {
        super(keyStoreSpi, provider, type);
    }

    public static KeyStore getInstance(String type, AtomicBoolean isDb) throws KeyStoreException {
        DbKeystoreManager dbKeystoreManager = null;
        try {
            Class<?> bootstrapClass = Class.forName("org.hyperic.hq.context.Bootstrap");
            Method method = bootstrapClass.getMethod("getBean", String.class);
            dbKeystoreManager = (DbKeystoreManager)method.invoke(null, "dbKeystoreManager");
        }
        catch (Exception e) {
            log.debug((Object)("could not instantiate DbKeystoreManager class: " + e), (Throwable)e);
        }
        if (dbKeystoreManager == null) {
            isDb.set(false);
            return KeyStore.getInstance(type);
        }
        try {
            DbKeyStoreSpi dbKeyStoreSpi = new DbKeyStoreSpi(dbKeystoreManager);
            Provider[] providers = Security.getProviders("KeyStore." + type);
            isDb.set(true);
            return new DbKeyStore(dbKeyStoreSpi, providers[0], type);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

