/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.units;

import java.math.BigDecimal;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import org.hyperic.util.units.FormatSpecifics;
import org.hyperic.util.units.FormattedNumber;
import org.hyperic.util.units.Formatter;
import org.hyperic.util.units.ParseSpecifics;
import org.hyperic.util.units.UnitNumber;
import org.hyperic.util.units.UnitsUtil;

public abstract class SimpleFormatter
implements Formatter {
    protected abstract int getUnitType();

    protected abstract int getUnitScale();

    public FormattedNumber format(UnitNumber val, Locale locale, FormatSpecifics specifics) {
        NumberFormat fmt = this.getNumberFormat(locale);
        return this.formatNumber(val.getValue(), fmt);
    }

    public FormattedNumber[] formatSame(double[] vals, int unitType, int scale, Locale locale, FormatSpecifics specifics) {
        if (unitType != this.getUnitType()) {
            throw new IllegalArgumentException("Invalid unit specified");
        }
        if (scale != this.getUnitScale()) {
            throw new IllegalArgumentException("Invalid scale specified");
        }
        NumberFormat fmt = UnitsUtil.getNumberFormat(vals, locale);
        FormattedNumber[] res = new FormattedNumber[vals.length];
        for (int i = 0; i < vals.length; ++i) {
            res[i] = this.formatNumber(vals[i], fmt);
        }
        return res;
    }

    protected abstract FormattedNumber formatNumber(double var1, NumberFormat var3);

    protected NumberFormat getNumberFormat(Locale locale) {
        NumberFormat res = NumberFormat.getInstance(locale);
        res.setMinimumFractionDigits(1);
        res.setMaximumFractionDigits(1);
        return res;
    }

    public BigDecimal getBaseValue(double value, int scale) {
        if (scale != this.getUnitScale()) {
            throw new IllegalArgumentException("Invalid scale specified");
        }
        return new BigDecimal(value);
    }

    public BigDecimal getScaledValue(BigDecimal value, int targScale) {
        if (targScale != this.getUnitScale()) {
            throw new IllegalArgumentException("Invalid scale specified");
        }
        return value;
    }

    public UnitNumber parse(String val, Locale locale, ParseSpecifics specifics) throws ParseException {
        NumberFormat fmt = NumberFormat.getInstance(locale);
        return new UnitNumber(fmt.parse(val).doubleValue(), this.getUnitType(), this.getUnitScale());
    }
}

