/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.xmlparser;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Set;
import org.hyperic.util.StringUtil;
import org.hyperic.util.xmlparser.XmlAttr;
import org.hyperic.util.xmlparser.XmlAttrException;
import org.hyperic.util.xmlparser.XmlAttrHandler;
import org.hyperic.util.xmlparser.XmlEndAttrHandler;
import org.hyperic.util.xmlparser.XmlFilterHandler;
import org.hyperic.util.xmlparser.XmlMissingTagException;
import org.hyperic.util.xmlparser.XmlParseException;
import org.hyperic.util.xmlparser.XmlRequiredAttrException;
import org.hyperic.util.xmlparser.XmlTagEntryHandler;
import org.hyperic.util.xmlparser.XmlTagException;
import org.hyperic.util.xmlparser.XmlTagExitHandler;
import org.hyperic.util.xmlparser.XmlTagHandler;
import org.hyperic.util.xmlparser.XmlTagInfo;
import org.hyperic.util.xmlparser.XmlTextHandler;
import org.hyperic.util.xmlparser.XmlTooManyTagException;
import org.hyperic.util.xmlparser.XmlUnAttrHandler;
import org.hyperic.util.xmlparser.XmlUnknownAttrException;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.xml.sax.EntityResolver;

public class XmlParser {
    private XmlParser() {
    }

    private static void checkAttributes(Element elem, XmlTagHandler tag, XmlFilterHandler filter) throws XmlAttrException {
        boolean found;
        boolean handlesAttrs = tag instanceof XmlAttrHandler;
        XmlAttr[] attrs = handlesAttrs ? ((XmlAttrHandler)((Object)tag)).getAttributes() : new XmlAttr[]{};
        for (int i = 0; i < attrs.length; ++i) {
            Attribute a2 = null;
            found = false;
            for (Attribute a2 : elem.getAttributes()) {
                if (!a2.getName().equalsIgnoreCase(attrs[i].getName())) continue;
                found = true;
                break;
            }
            if (!found && attrs[i].getType() == 0) {
                throw new XmlRequiredAttrException(elem, attrs[i].getName());
            }
            if (!found || !handlesAttrs) continue;
            String val = filter.filterAttrValue(tag, a2.getName(), a2.getValue());
            ((XmlAttrHandler)((Object)tag)).handleAttribute(i, val);
        }
        for (Attribute a2 : elem.getAttributes()) {
            found = false;
            for (int j = 0; j < attrs.length; ++j) {
                if (!a2.getName().equalsIgnoreCase(attrs[j].getName())) continue;
                found = true;
                break;
            }
            if (found) continue;
            if (tag instanceof XmlUnAttrHandler) {
                String val = filter.filterAttrValue(tag, a2.getName(), a2.getValue());
                XmlUnAttrHandler handler = (XmlUnAttrHandler)((Object)tag);
                handler.handleUnknownAttribute(a2.getName(), val);
                continue;
            }
            throw new XmlUnknownAttrException(elem, a2.getName());
        }
        if (tag instanceof XmlEndAttrHandler) {
            ((XmlEndAttrHandler)((Object)tag)).endAttributes();
        }
    }

    private static void checkSubNodes(Element elem, XmlTagHandler tag, XmlFilterHandler filter) throws XmlAttrException, XmlTagException {
        XmlTagInfo[] subTags = tag.getSubTags();
        HashMap<String, Integer> hash = new HashMap<String, Integer>();
        for (Element e : elem.getChildren()) {
            String name = e.getName().toLowerCase();
            Integer val = (Integer)hash.get(name);
            if (val == null) {
                val = new Integer(0);
            }
            val = new Integer(val + 1);
            hash.put(name, val);
        }
        for (int i = 0; i < subTags.length; ++i) {
            String name = subTags[i].getTag().getName().toLowerCase();
            Integer iVal = (Integer)hash.get(name);
            int threshold = 0;
            int val = iVal == null ? 0 : iVal;
            switch (subTags[i].getType()) {
                case 0: {
                    if (val == 0) {
                        throw new XmlMissingTagException(elem, name);
                    }
                    if (val == 1) break;
                    throw new XmlTooManyTagException(elem, name);
                }
                case 1: {
                    if (val <= 1) break;
                    throw new XmlTooManyTagException(elem, name);
                }
                case 2: {
                    ++threshold;
                }
                case 3: {
                    if (val >= threshold) break;
                    throw new XmlMissingTagException(elem, name);
                }
            }
            hash.remove(name);
        }
        if (hash.size() != 0) {
            Set keys = hash.keySet();
            throw new XmlTooManyTagException(elem, (String)keys.iterator().next());
        }
        block8: for (Element child : elem.getChildren()) {
            for (int j = 0; j < subTags.length; ++j) {
                XmlTagHandler subTag = subTags[j].getTag();
                String subName = subTag.getName();
                if (!child.getName().equalsIgnoreCase(subName)) continue;
                XmlParser.processNode(child, subTag, filter);
                continue block8;
            }
        }
    }

    private static void processNode(Element elem, XmlTagHandler tag, XmlFilterHandler filter) throws XmlAttrException, XmlTagException {
        if (tag instanceof XmlTagEntryHandler) {
            ((XmlTagEntryHandler)((Object)tag)).enter();
        }
        if (tag instanceof XmlFilterHandler) {
            filter = (XmlFilterHandler)((Object)tag);
        }
        XmlParser.checkAttributes(elem, tag, filter);
        if (tag instanceof XmlTextHandler) {
            ((XmlTextHandler)((Object)tag)).handleText(elem.getText());
        }
        XmlParser.checkSubNodes(elem, tag, filter);
        if (tag instanceof XmlTagExitHandler) {
            ((XmlTagExitHandler)((Object)tag)).exit();
        }
    }

    public static void parse(InputStream is, XmlTagHandler tag) throws XmlParseException {
        XmlParser.parse(is, tag, null);
    }

    public static void parse(InputStream is, XmlTagHandler tag, EntityResolver resolver) throws XmlParseException {
        Document doc;
        SAXBuilder builder = new SAXBuilder();
        if (resolver != null) {
            builder.setEntityResolver(resolver);
        }
        try {
            doc = resolver != null ? builder.build(is, "") : builder.build(is);
        }
        catch (JDOMException exc) {
            XmlParseException toThrow = new XmlParseException(exc.getMessage());
            toThrow.initCause(exc);
            throw toThrow;
        }
        catch (IOException exc) {
            XmlParseException toThrow = new XmlParseException(exc.getMessage());
            toThrow.initCause(exc);
            throw toThrow;
        }
        XmlParser.generalParse(tag, doc);
    }

    public static void parse(File in, XmlTagHandler tag) throws XmlParseException {
        Document doc;
        SAXBuilder builder = new SAXBuilder();
        FileInputStream is = null;
        try {
            is = new FileInputStream(in);
            doc = builder.build((InputStream)is);
        }
        catch (IOException exc) {
            throw new XmlParseException(exc.getMessage());
        }
        catch (JDOMException exc) {
            throw new XmlParseException(exc.getMessage());
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException e) {}
            }
        }
        XmlParser.generalParse(tag, doc);
    }

    private static void generalParse(XmlTagHandler tag, Document doc) throws XmlParseException {
        Element root = doc.getRootElement();
        if (!root.getName().equalsIgnoreCase(tag.getName())) {
            throw new XmlParseException("Incorrect root tag.  Expected <" + tag.getName() + "> but got <" + root.getName() + ">");
        }
        XmlParser.processNode(root, tag, new DummyFilter());
    }

    private static void dumpAttrs(XmlAttr[] attrs, String typeName, int type, PrintStream out, int indent) {
        boolean printed = false;
        if (attrs.length == 0) {
            return;
        }
        int lineLen = 0;
        String printMsg = "- Has " + typeName + " attributes: ";
        int lineBase = indent + printMsg.length();
        for (int i = 0; i < attrs.length; ++i) {
            String toPrint;
            if (attrs[i].getType() != type) continue;
            if (!printed) {
                toPrint = StringUtil.repeatChars(' ', indent) + "- Has " + typeName + " attributes: ";
                out.print(toPrint);
                lineLen = toPrint.length();
                printed = true;
            }
            toPrint = attrs[i].getName() + ", ";
            out.print(toPrint);
            if ((lineLen += toPrint.length()) <= 70) continue;
            out.println();
            out.print(StringUtil.repeatChars(' ', lineBase));
            lineLen = lineBase;
        }
        if (printed) {
            out.println();
        }
    }

    private static void dumpNode(XmlTagHandler tag, PrintStream out, int indent) throws XmlTagException {
        XmlTagInfo[] subTags = tag.getSubTags();
        out.println(StringUtil.repeatChars(' ', indent) + "Tag <" + tag.getName() + ">:");
        if (tag instanceof XmlAttrHandler) {
            XmlAttr[] attrs = ((XmlAttrHandler)((Object)tag)).getAttributes();
            if (attrs.length == 0) {
                out.println(StringUtil.repeatChars(' ', indent) + "- has no required or optional attributes");
            }
            XmlParser.dumpAttrs(attrs, "REQUIRED", 0, out, indent);
            XmlParser.dumpAttrs(attrs, "OPTIONAL", 1, out, indent);
        } else {
            out.println(StringUtil.repeatChars(' ', indent) + "- has no required or optional attributes");
        }
        if (tag instanceof XmlUnAttrHandler) {
            out.println(StringUtil.repeatChars(' ', indent) + "- handles arbitrary attributes");
        }
        if ((subTags = tag.getSubTags()).length == 0) {
            out.println(StringUtil.repeatChars(' ', indent) + "- has no subtags");
        } else {
            for (int i = 0; i < subTags.length; ++i) {
                String name = subTags[i].getTag().getName();
                int type = subTags[i].getType();
                out.print(StringUtil.repeatChars(' ', indent) + "- has subtag <" + name + ">, which ");
                switch (type) {
                    case 0: {
                        out.println("is REQUIRED");
                        break;
                    }
                    case 1: {
                        out.println("is OPTIONAL");
                        break;
                    }
                    case 2: {
                        out.println("is REQUIRED at least ONCE");
                        break;
                    }
                    case 3: {
                        out.println("can be specified any # of times");
                    }
                }
                XmlParser.dumpNode(subTags[i].getTag(), out, indent + 4);
            }
        }
    }

    public static void dump(XmlTagHandler root, PrintStream out) {
        try {
            XmlParser.dumpNode(root, out, 0);
        }
        catch (XmlTagException exc) {
            out.println("Error traversing tags: " + exc.getMessage());
        }
    }

    private static String bold(String text) {
        return "<emphasis role=\"bold\">" + text + "</emphasis>";
    }

    private static String tag(String name) {
        return XmlParser.bold("&lt;" + name + "&gt;");
    }

    private static String listitem(String name, String desc) {
        String item = "<listitem><para>" + name + "</para>";
        if (desc != null) {
            item = item + "<para>" + desc + "</para>";
        }
        return item;
    }

    private static void dumpAttrsWiki(XmlAttr[] attrs, String typeName, int type, PrintStream out, int indent) {
        boolean printed = false;
        if (attrs.length == 0) {
            return;
        }
        for (int i = 0; i < attrs.length; ++i) {
            if (attrs[i].getType() != type) continue;
            if (!printed) {
                out.println(StringUtil.repeatChars('*', indent) + " " + typeName + " attributes: ");
                printed = true;
            }
            out.println(StringUtil.repeatChars('*', indent) + " " + attrs[i].getName());
        }
    }

    private static void dumpNodeWiki(XmlTagHandler tag, PrintStream out, int indent) throws XmlTagException {
        XmlTagInfo[] subTags = tag.getSubTags();
        if (indent == 1) {
            out.println(StringUtil.repeatChars('*', indent) + " Tag *<" + tag.getName() + ">*: ");
        }
        if (tag instanceof XmlAttrHandler) {
            XmlAttr[] attrs = ((XmlAttrHandler)((Object)tag)).getAttributes();
            XmlParser.dumpAttrsWiki(attrs, "*REQUIRED*", 0, out, indent + 1);
            XmlParser.dumpAttrsWiki(attrs, "*OPTIONAL*", 1, out, indent + 1);
        }
        if ((subTags = tag.getSubTags()).length != 0) {
            for (int i = 0; i < subTags.length; ++i) {
                String name = subTags[i].getTag().getName();
                int type = subTags[i].getType();
                String desc = "";
                switch (type) {
                    case 0: {
                        desc = "REQUIRED";
                        break;
                    }
                    case 1: {
                        desc = "OPTIONAL";
                        break;
                    }
                    case 2: {
                        desc = "REQUIRED at least ONCE";
                        break;
                    }
                    case 3: {
                        desc = "can be specified any # of times";
                    }
                }
                out.println(StringUtil.repeatChars('*', indent + 1) + " Sub Tag *<" + name + ">* " + desc);
                XmlParser.dumpNodeWiki(subTags[i].getTag(), out, indent + 1);
            }
        }
    }

    public static void dumpWiki(XmlTagHandler root, PrintStream out) {
        try {
            XmlParser.dumpNodeWiki(root, out, 1);
        }
        catch (XmlTagException exc) {
            out.println("Error traversing tags: " + exc.getMessage());
        }
    }

    private static class DummyFilter
    implements XmlFilterHandler {
        private DummyFilter() {
        }

        public String filterAttrValue(XmlTagHandler tag, String attrName, String attrValue) {
            return attrValue;
        }
    }
}

