/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.hyperic.hq.product.ExecutableMeasurementPlugin;
import org.hyperic.hq.product.GenericPlugin;
import org.hyperic.hq.product.LogTrackPlugin;
import org.hyperic.hq.product.LogTrackPluginManager;
import org.hyperic.hq.product.MeasurementInfo;
import org.hyperic.hq.product.MeasurementPlugin;
import org.hyperic.hq.product.MeasurementValueGetter;
import org.hyperic.hq.product.Metric;
import org.hyperic.hq.product.MetricNotFoundException;
import org.hyperic.hq.product.MetricUnreachableException;
import org.hyperic.hq.product.MetricValue;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.PluginInfo;
import org.hyperic.hq.product.PluginManager;
import org.hyperic.hq.product.PluginNotFoundException;
import org.hyperic.hq.product.ProductPluginManager;
import org.hyperic.hq.product.SNMPMeasurementPlugin;
import org.hyperic.hq.product.SigarMeasurementPlugin;
import org.hyperic.hq.product.TrackEventPluginManager;
import org.hyperic.hq.product.TypeInfo;
import org.hyperic.hq.product.Win32MeasurementPlugin;
import org.hyperic.util.PluginLoader;
import org.hyperic.util.config.ConfigResponse;
import org.hyperic.util.config.ConfigSchema;

public class MeasurementPluginManager
extends PluginManager
implements MeasurementValueGetter {
    private Map metricCache = Collections.synchronizedMap(new HashMap());
    private boolean debugRateMetrics;
    private LogTrackPluginManager ltpm;

    public MeasurementPluginManager() {
    }

    public MeasurementPluginManager(Properties props) {
        super(props);
        this.debugRateMetrics = "true".equals("debugRateMetrics");
    }

    private void registerProxy(String name, GenericPlugin plugin) throws PluginException {
        this.registerPlugin(name, plugin);
        this.setPluginInfo(name, new PluginInfo(name, plugin.getPluginVersion()));
    }

    public void init(PluginManager parent) throws PluginException {
        super.init(parent);
        this.ltpm = ((ProductPluginManager)parent).getLogTrackPluginManager();
        this.registerProxy("exec", new ExecutableMeasurementPlugin());
        this.registerProxy("snmp", new SNMPMeasurementPlugin());
        this.registerProxy("sigar", new SigarMeasurementPlugin());
        this.registerProxy("sigar.ptql", new SigarMeasurementPlugin());
        this.registerProxy("win32", new Win32MeasurementPlugin());
    }

    public String getName() {
        return "measurement";
    }

    private boolean isPluginTypeSupported(String type) {
        return "true".equals(this.getProperty("plugin." + type + ".supported"));
    }

    public ConfigSchema getConfigSchema(String plugin, TypeInfo info, ConfigResponse config) throws PluginNotFoundException {
        ConfigSchema schema = super.getConfigSchema(plugin, info, config);
        ProductPluginManager ppm = (ProductPluginManager)this.getParent();
        if (this.isPluginTypeSupported("log_track")) {
            this.mergeConfigSchema(ppm.getLogTrackPluginManager(), schema, info, config);
        }
        if (this.isPluginTypeSupported("config_track")) {
            this.mergeConfigSchema(ppm.getConfigTrackPluginManager(), schema, info, config);
        }
        return schema;
    }

    public MetricValue getValue(String template) throws PluginException, PluginNotFoundException, MetricNotFoundException, MetricUnreachableException {
        int ix = template.indexOf(":");
        String plugin = template.substring(0, ix);
        String metric = template.substring(ix + 1, template.length());
        return this.getValue(plugin, metric);
    }

    public MetricValue getValue(String name, String metric) throws PluginException, PluginNotFoundException, MetricNotFoundException, MetricUnreachableException {
        try {
            return this.getValue(name, Metric.parse(metric));
        }
        catch (PluginNotFoundException e) {
            if (e.getMessage() == null) {
                String msg = this.getName() + " plugin name=" + name + " not found";
                throw new PluginNotFoundException(msg);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MetricValue getPluginValue(String name, Metric metric) throws PluginException, MetricNotFoundException, MetricUnreachableException {
        MeasurementPlugin plugin = (MeasurementPlugin)this.plugins.get(name);
        String domain = metric.getDomainName();
        MeasurementPlugin invoker = (MeasurementPlugin)this.plugins.get(domain);
        if (invoker == null) {
            if (plugin == null) {
                plugin = (MeasurementPlugin)this.getPlugin(name);
            }
            invoker = plugin;
        }
        PluginLoader.setClassLoader((Object)invoker);
        try {
            MetricValue metricValue = invoker.getValue(metric);
            return metricValue;
        }
        finally {
            PluginLoader.resetClassLoader((Object)invoker);
        }
    }

    public MetricValue getValue(String name, Metric metric) throws PluginException, PluginNotFoundException, MetricNotFoundException, MetricUnreachableException {
        String metricString = metric.toString();
        try {
            int idx = metricString.indexOf("__RATE__");
            if (idx != -1) {
                double interval;
                String newDsn = metricString.substring(0, idx);
                String rate = metricString.substring(idx + "__RATE__".length() + 1);
                if ((idx = rate.indexOf(58)) != -1) {
                    newDsn = newDsn + rate.substring(idx);
                    rate = rate.substring(0, idx);
                }
                if (rate.equals("none")) {
                    throw new MetricNotFoundException("Rate calculation disabled for this metric");
                }
                if (rate.equals("1s")) {
                    interval = 1000.0;
                } else if (rate.equals("1m")) {
                    interval = 60000.0;
                } else if (rate.equals("1h")) {
                    interval = 3600000.0;
                } else {
                    throw new MetricNotFoundException("Invalid rate of " + rate + " for Metric=" + newDsn);
                }
                MetricValue newVal = this.getPluginValue(name, Metric.parse(newDsn));
                MetricValue oldVal = (MetricValue)this.metricCache.get(metricString);
                if (oldVal == null) {
                    this.metricCache.put(metricString, newVal);
                    if (this.debugRateMetrics) {
                        String msg = "First time collecting rate based metric '" + newDsn + "'";
                        this.log.trace((Object)msg);
                    }
                    return new MetricValue(Double.NaN);
                }
                this.metricCache.put(metricString, newVal);
                double oldValue = oldVal.getValue();
                double newValue = newVal.getValue();
                if (newValue < oldValue) {
                    if (this.debugRateMetrics) {
                        String msg = "Rate based metric '" + newDsn + "'counter rolled over";
                        this.log.trace((Object)msg);
                    }
                    return new MetricValue(Double.NaN);
                }
                double oldTime = oldVal.getTimestamp();
                double newTime = newVal.getTimestamp();
                MetricValue rateVal = new MetricValue((newValue - oldValue) / ((newTime - oldTime) / interval), System.currentTimeMillis());
                return rateVal;
            }
            return this.getPluginValue(name, metric);
        }
        catch (NoClassDefFoundError e) {
            throw new PluginException(this.classNotFoundMessage(e), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String translate(MeasurementPlugin plugin, String template, ConfigResponse config) {
        PluginLoader.setClassLoader((Object)plugin);
        try {
            String string = plugin.translate(template, config);
            return string;
        }
        finally {
            PluginLoader.resetClassLoader((Object)plugin);
        }
    }

    public String translate(String template, ConfigResponse config) throws PluginNotFoundException {
        MeasurementPlugin plugin;
        int ix = template.indexOf(":");
        String type = template.substring(0, ix);
        String name = template.substring(type.length() + 1);
        if ((ix = name.indexOf(":")) != -1 && (plugin = (MeasurementPlugin)this.plugins.get(name = name.substring(0, ix))) != null) {
            template = this.translate(plugin, template, config);
        }
        plugin = (MeasurementPlugin)this.getPlugin(type);
        template = this.translate(plugin, template, config);
        return template;
    }

    public MeasurementInfo[] getMeasurements(TypeInfo info) throws PluginNotFoundException {
        String name = info.getName();
        MeasurementPlugin plugin = (MeasurementPlugin)this.getPlugin(name);
        return plugin.getMeasurements(info);
    }

    public String getHelp(TypeInfo info, Map props) throws PluginNotFoundException {
        String name = info.getName();
        MeasurementPlugin plugin = (MeasurementPlugin)this.getPlugin(name);
        ConfigSchema schema = this.getConfigSchema(plugin.getName(), info, new ConfigResponse());
        String help = plugin.getHelp(info, props);
        String trackHelp = TrackEventPluginManager.getGenericHelp(this.ltpm, schema, info);
        if (trackHelp != null) {
            trackHelp = plugin.replaceHelpProperties(trackHelp, info, props);
        }
        if (help == null) {
            return trackHelp;
        }
        if (trackHelp != null) {
            return help + "<hr>" + trackHelp;
        }
        return help;
    }

    public void reportEvent(Metric metric, long time, int level, String source, String message) {
        LogTrackPlugin plugin = null;
        if (metric.getId() != null) {
            plugin = this.ltpm.getLogTrackPlugin(metric.getId());
        }
        if (plugin != null) {
            if (message == null) {
                message = "No Message";
            }
            plugin.reportEvent(time, level, source, message);
        }
    }
}

