/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.GenericPlugin;
import org.hyperic.hq.product.HypericOperatingSystem;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.PluginExistsException;
import org.hyperic.hq.product.PluginInfo;
import org.hyperic.hq.product.PluginNotFoundException;
import org.hyperic.hq.product.ProductPlugin;
import org.hyperic.hq.product.ProductPluginManager;
import org.hyperic.hq.product.ServiceTypeInfo;
import org.hyperic.hq.product.TypeInfo;
import org.hyperic.hq.product.pluginxml.PluginData;
import org.hyperic.util.PluginLoader;
import org.hyperic.util.config.ConfigResponse;
import org.hyperic.util.config.ConfigSchema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PluginManager {
    private final String OS;
    private final String OS_SUFFIX;
    protected Map<String, GenericPlugin> plugins = Collections.synchronizedMap(new HashMap());
    private Map pluginInfo = Collections.synchronizedMap(new HashMap());
    private Properties props = null;
    protected Log log = LogFactory.getLog((String)this.getClass().getName());
    private PluginManager parent = null;

    public PluginManager() {
        this(new Properties());
    }

    public PluginManager(Properties props) {
        this.props = props;
        this.OS = HypericOperatingSystem.getInstance().getName();
        this.OS_SUFFIX = " " + this.OS;
    }

    public abstract String getName();

    public void init(PluginManager parent) throws PluginException {
        this.parent = parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws PluginException {
        Map<String, GenericPlugin> map = this.plugins;
        synchronized (map) {
            for (Map.Entry<String, GenericPlugin> entry : this.plugins.entrySet()) {
                GenericPlugin plugin = entry.getValue();
                try {
                    plugin.shutdown();
                }
                catch (PluginException e) {
                    this.log.error((Object)(plugin.getName() + ".shutdown() failed"), (Throwable)((Object)e));
                }
            }
            this.plugins.clear();
        }
    }

    public Properties getProperties() {
        return this.props;
    }

    public String getProperty(String key, String defVal) {
        return this.getProperties().getProperty(key, defVal);
    }

    public String getProperty(String key) {
        return this.getProperty(key, System.getProperty(key));
    }

    public boolean isPropertyEnabled(String key, boolean defVal) {
        String val = this.getProperty(key);
        if (val == null) {
            return defVal;
        }
        return "true".equals(val);
    }

    public boolean isPropertyEnabled(String key) {
        return this.isPropertyEnabled(key, false);
    }

    public PluginManager getParent() {
        return this.parent;
    }

    protected void mergeConfigSchema(PluginManager pm, ConfigSchema schema, TypeInfo info, ConfigResponse config) {
        try {
            GenericPlugin plugin = pm.getPlugin(info.getName());
            List options = plugin.getConfigSchema(info, config).getOptions();
            schema.addOptions(options);
        }
        catch (PluginNotFoundException e) {
            // empty catch block
        }
    }

    public ConfigSchema getConfigSchema(String plugin, TypeInfo info, ConfigResponse config) throws PluginNotFoundException {
        return this.getPlugin(plugin).getConfigSchema(info, config);
    }

    public ConfigSchema getConfigSchema(String pluginName, String platformName, String typeName, TypeInfo info, ConfigResponse config) throws PluginNotFoundException {
        String fullTypeName = typeName.equals(platformName) ? platformName : typeName + " " + platformName;
        return this.getConfigSchema(fullTypeName, info, config);
    }

    private String getServicePluginImpl(GenericPlugin plugin) {
        return plugin.getTypeProperty("SERVICE_" + this.getName().toUpperCase() + "_PLUGIN");
    }

    private GenericPlugin getPluginExtension(String name) {
        GenericPlugin serverPlugin;
        PluginData.ServiceExtension ext;
        String platformName = name;
        boolean isPlatformPlugin = false;
        if (name.endsWith(this.OS_SUFFIX)) {
            isPlatformPlugin = true;
            name = name.substring(0, name.length() - this.OS_SUFFIX.length());
        }
        if ((ext = PluginData.getServiceExtension(name)) == null) {
            return null;
        }
        ServiceTypeInfo service = ext.service;
        String serverName = service.getServerName();
        String msg = " plugin for service '" + name + "' from server '" + serverName + "'";
        try {
            serverPlugin = this.getPlugin(serverName);
            this.log.debug((Object)("Created" + msg));
        }
        catch (PluginNotFoundException e) {
            this.log.debug((Object)("PluginNotFound creating" + msg));
            return null;
        }
        String implClass = ext.data.getPlugin(this.getName(), service.getName());
        if (implClass == null) {
            String defaultImpl = this.getServicePluginImpl(serverPlugin);
            if (this.getName().equals("measurement")) {
                implClass = defaultImpl == null ? serverPlugin.getClass().getName() : defaultImpl;
            } else if (this.getName().equals("control")) {
                if (ext.data.getControlActions(service.getName()) != null) {
                    implClass = defaultImpl;
                }
            } else {
                return null;
            }
        }
        if (implClass == null) {
            return null;
        }
        this.log.debug((Object)("Using " + implClass + " " + this.getName() + " plugin from " + serverPlugin.getName() + " for " + service.getName()));
        String[] mergeProps = new String[]{"template-config"};
        for (int i = 0; i < mergeProps.length; ++i) {
            String key = mergeProps[i];
            String value = ext.data.getProperty(key);
            if (value != null || (value = serverPlugin.data.getProperty(key)) == null) continue;
            ext.data.setProperty(key, value);
        }
        GenericPlugin plugin = ProductPlugin.getPlugin(serverPlugin, implClass, this.getName(), service);
        if (plugin == null) {
            this.log.error((Object)("Failed to create " + msg));
            return null;
        }
        ProductPluginManager ppm = (ProductPluginManager)this.getParent();
        plugin.data = ext.data;
        plugin.setName(service.getName());
        plugin.setTypeInfo(service);
        String productName = plugin.data.getName();
        PluginInfo info = ppm.getPluginInfo(productName);
        this.setPluginInfo(plugin.getName(), info);
        try {
            ppm.registerTypePlugin(this, info, plugin, service);
        }
        catch (PluginExistsException e) {
            this.log.debug((Object)("PluginExists creating" + msg));
            return null;
        }
        if (isPlatformPlugin) {
            return this.plugins.get(platformName);
        }
        return plugin;
    }

    public GenericPlugin getPlugin(String name) throws PluginNotFoundException {
        GenericPlugin plugin = this.plugins.get(name);
        if (plugin == null) {
            if (name != null && (plugin = this.getPluginExtension(name)) != null) {
                return plugin;
            }
            String msg = this.getName() + " plugin name=" + name + " not found";
            throw new PluginNotFoundException(msg);
        }
        return plugin;
    }

    public GenericPlugin getPlatformPlugin(String name) throws PluginNotFoundException {
        return this.getPlugin(name + this.OS_SUFFIX);
    }

    public GenericPlugin getPlatformPlugin(String os, String name) throws PluginNotFoundException {
        return this.getPlugin(name + " " + os);
    }

    public void removePlugin(String name) throws PluginException, PluginNotFoundException {
        GenericPlugin plugin = this.getPlugin(name);
        this.plugins.remove(name);
        try {
            plugin.shutdown();
        }
        catch (PluginException e) {
            throw new PluginException(e.getMessage(), (Throwable)((Object)e));
        }
    }

    public boolean isRegistered(String name) {
        return this.plugins.get(name) != null;
    }

    public void registerPlugin(GenericPlugin plugin) throws PluginException, PluginExistsException {
        this.registerPlugin(plugin, null);
    }

    public void registerPlugin(String name, GenericPlugin plugin) throws PluginException, PluginExistsException {
        plugin.setName(name);
        this.registerPlugin(plugin);
    }

    public void registerPlugin(GenericPlugin plugin, ConfigResponse response) throws PluginException, PluginExistsException {
        String pluginName = plugin.getName();
        if (pluginName == null || pluginName.length() < 1) {
            String msg = "malformed name '" + pluginName + "' for plugin instance: " + plugin.getClass().getName();
            throw new PluginException(msg);
        }
        if (this.plugins.get(pluginName) != null) {
            throw new PluginExistsException("Plugin name=" + pluginName + " already exists");
        }
        this.plugins.put(pluginName, plugin);
        boolean setClassLoader = PluginLoader.setClassLoader((Object)plugin);
        try {
            plugin.init(this);
            if (response != null) {
                plugin.configure(response);
            }
        }
        catch (PluginException e) {
            this.plugins.remove(pluginName);
            throw e;
        }
        finally {
            if (setClassLoader) {
                PluginLoader.resetClassLoader((Object)plugin);
            }
        }
    }

    public void updatePlugin(GenericPlugin plugin, ConfigResponse response) throws PluginException, PluginNotFoundException {
        this.removePlugin(plugin.getName());
        try {
            this.registerPlugin(plugin, response);
        }
        catch (PluginExistsException e) {
            throw new PluginException("plugin was not removed?");
        }
    }

    public GenericPlugin createPlugin(String name, String type, ConfigResponse config) throws PluginException, PluginExistsException, PluginNotFoundException {
        return this.createPlugin(name, this.getPlugin(type), config);
    }

    public GenericPlugin createPlugin(String name, GenericPlugin pluginType) throws PluginException, PluginExistsException {
        return this.createPlugin(name, pluginType, null);
    }

    public GenericPlugin createPlugin(String name, GenericPlugin pluginType, ConfigResponse config) throws PluginException, PluginExistsException {
        GenericPlugin plugin;
        try {
            plugin = (GenericPlugin)pluginType.getClass().newInstance();
        }
        catch (Exception e) {
            throw new PluginException(e.getMessage(), e);
        }
        plugin.data = pluginType.data;
        plugin.setName(name);
        plugin.setPluginVersion(pluginType.getPluginVersion());
        plugin.setTypeInfo(pluginType.getTypeInfo());
        this.registerPlugin(plugin, config);
        PluginInfo info = this.getPluginInfo(pluginType.getName());
        if (info != null) {
            this.setPluginInfo(name, new PluginInfo(name, info));
        }
        return plugin;
    }

    public Map<String, GenericPlugin> getPlugins() {
        return this.plugins;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getPlatformPlugins(String os) {
        Map<String, GenericPlugin> plugins;
        os = " " + os;
        HashMap<String, GenericPlugin> found = new HashMap<String, GenericPlugin>();
        Map<String, GenericPlugin> map = plugins = this.getPlugins();
        synchronized (map) {
            for (Map.Entry<String, GenericPlugin> entry : plugins.entrySet()) {
                String name = entry.getKey();
                if (!name.endsWith(os)) continue;
                found.put(name, entry.getValue());
            }
        }
        return found;
    }

    public Map getPlatformPlugins() {
        return this.getPlatformPlugins(this.OS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getPlugins(PluginInfo info) {
        ArrayList<String> found = new ArrayList<String>();
        Map map = this.pluginInfo;
        synchronized (map) {
            for (Map.Entry entry : this.pluginInfo.entrySet()) {
                PluginInfo pi = (PluginInfo)entry.getValue();
                if (!pi.matches(info)) continue;
                found.add(pi.name);
            }
        }
        return found;
    }

    public void setPluginInfo(String name, PluginInfo info) {
        this.pluginInfo.put(name, info);
    }

    public PluginInfo getPluginInfo(String name) {
        return (PluginInfo)this.pluginInfo.get(name);
    }

    protected String classNotFoundMessage(NoClassDefFoundError e) {
        return "Plugin class not found: " + e.getMessage() + " (invalid classpath or corrupt plugin jar)";
    }
}

