/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product.logparse;

import org.hyperic.hq.product.RtPlugin;
import org.hyperic.hq.product.TypeInfo;
import org.hyperic.hq.product.logparse.BaseLogParser;
import org.hyperic.hq.product.logparse.SimpleLogParser;
import org.hyperic.util.config.ConfigResponse;
import org.hyperic.util.config.ConfigSchema;
import org.hyperic.util.config.SchemaBuilder;

public abstract class SimpleRtPlugin
extends RtPlugin {
    double tm;

    public String convertFormat(String fmt) {
        return fmt;
    }

    public double getTimeMultiplier() {
        return 1.0;
    }

    public BaseLogParser getParser() {
        return SimpleLogParser.getInstance();
    }

    public ConfigSchema getConfigSchema(TypeInfo info, ConfigResponse config) {
        int type = info.getType();
        if (type != 3) {
            return new ConfigSchema();
        }
        SchemaBuilder schema = new SchemaBuilder(config);
        String serverRoot = config.getValue("installpath");
        schema.add(CONFIG_LOGDIR, "full path to log directory", serverRoot + "/logs");
        schema.add(CONFIG_LOGMASK, "the filenames of your log files with wildcards", "rt_log");
        schema.add(CONFIG_INTERVAL, "Interval between parsing log files (seconds)", 60);
        if (this.supportsEndUser()) {
            schema.add(CONFIG_EULOGDIR, "full path to end user log directory", serverRoot + "/logs");
            schema.add(CONFIG_EULOGMASK, "the filenames of your end user log files with wildcards", "enduser_log");
            schema.add(CONFIG_EUINTERVAL, "Interval between parsing end user log files (seconds)", 60);
        }
        schema.addRegex(CONFIG_TRANSFORM, "Regular expressions to apply to all URLS, space separated", null).setOptional(true);
        schema.addStringArray(CONFIG_DONTLOG, "Regular expressions specifying which URLs not to log, space separated", null).setOptional(true);
        return schema.getSchema();
    }
}

