/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.hqapi1;

import java.io.IOException;
import java.util.HashMap;
import org.hyperic.hq.hqapi1.BaseApi;
import org.hyperic.hq.hqapi1.HQConnection;
import org.hyperic.hq.hqapi1.XmlResponseHandler;
import org.hyperic.hq.hqapi1.types.AlertResponse;
import org.hyperic.hq.hqapi1.types.AlertsResponse;
import org.hyperic.hq.hqapi1.types.Resource;
import org.hyperic.hq.hqapi1.types.StatusResponse;

public class AlertApi
extends BaseApi {
    AlertApi(HQConnection conn) {
        super(conn);
    }

    public AlertResponse getAlert(Integer alertId) throws IOException {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("id", new String[]{alertId.toString()});
        return this.doGet("alert/get.hqu", params, new XmlResponseHandler<AlertResponse>(AlertResponse.class));
    }

    public AlertsResponse findAlerts(long begin, long end, int count, int severity, Boolean inEscalation, Boolean notFixed) throws IOException {
        return this.findAlerts(begin, end, count, severity, inEscalation, notFixed, null);
    }

    public AlertsResponse findAlerts(long begin, long end, int count, int severity, Boolean inEscalation, Boolean notFixed, Integer groupId) throws IOException {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("begin", new String[]{Long.toString(begin)});
        params.put("end", new String[]{Long.toString(end)});
        params.put("count", new String[]{Integer.toString(count)});
        params.put("severity", new String[]{Integer.toString(severity)});
        if (inEscalation != null) {
            params.put("inEscalation", new String[]{Boolean.toString(inEscalation)});
        }
        if (notFixed != null) {
            params.put("notFixed", new String[]{Boolean.toString(notFixed)});
        }
        if (groupId != null) {
            params.put("groupId", new String[]{Integer.toString(groupId)});
        }
        return this.doGet("alert/find.hqu", params, new XmlResponseHandler<AlertsResponse>(AlertsResponse.class));
    }

    public AlertsResponse findAlerts(Resource r, long begin, long end, int count, int severity, Boolean inEscalation, Boolean notFixed) throws IOException {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("resourceId", new String[]{Integer.toString(r.getId())});
        params.put("begin", new String[]{Long.toString(begin)});
        params.put("end", new String[]{Long.toString(end)});
        params.put("count", new String[]{Integer.toString(count)});
        params.put("severity", new String[]{Integer.toString(severity)});
        if (inEscalation != null) {
            params.put("inEscalation", new String[]{Boolean.toString(inEscalation)});
        }
        if (notFixed != null) {
            params.put("notFixed", new String[]{Boolean.toString(notFixed)});
        }
        return this.doGet("alert/findByResource.hqu", params, new XmlResponseHandler<AlertsResponse>(AlertsResponse.class));
    }

    public AlertResponse fixAlert(Integer alertId) throws IOException {
        return this.fixAlert(alertId, "");
    }

    public AlertResponse fixAlert(Integer alertId, String reason) throws IOException {
        AlertsResponse response = this.fixAlerts(new Integer[]{alertId}, reason);
        AlertResponse res = new AlertResponse();
        res.setStatus(response.getStatus());
        res.setError(response.getError());
        if (response.getAlert().size() == 1) {
            res.setAlert(response.getAlert().get(0));
        }
        return res;
    }

    public AlertsResponse fixAlerts(Integer[] alertIds) throws IOException {
        return this.fixAlerts(alertIds, "");
    }

    public AlertsResponse fixAlerts(Integer[] alertIds, String reason) throws IOException {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        String[] ids = new String[alertIds.length];
        for (int i = 0; i < alertIds.length; ++i) {
            ids[i] = Integer.toString(alertIds[i]);
        }
        params.put("id", ids);
        params.put("reason", new String[]{reason});
        return this.doGet("alert/fix.hqu", params, new XmlResponseHandler<AlertsResponse>(AlertsResponse.class));
    }

    public AlertResponse ackAlert(Integer alertId, String reason, Long pause) throws IOException {
        AlertsResponse response = this.ackAlerts(new Integer[]{alertId}, reason, pause);
        AlertResponse res = new AlertResponse();
        res.setStatus(response.getStatus());
        res.setError(response.getError());
        if (response.getAlert().size() == 1) {
            res.setAlert(response.getAlert().get(0));
        }
        return res;
    }

    public AlertsResponse ackAlerts(Integer[] alertIds, String reason, Long pause) throws IOException {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        String[] ids = new String[alertIds.length];
        for (int i = 0; i < alertIds.length; ++i) {
            ids[i] = Integer.toString(alertIds[i]);
        }
        params.put("id", ids);
        params.put("reason", new String[]{reason});
        params.put("pause", new String[]{Long.toString(pause)});
        return this.doGet("alert/ack.hqu", params, new XmlResponseHandler<AlertsResponse>(AlertsResponse.class));
    }

    public StatusResponse delete(Integer alertId) throws IOException {
        return this.delete(new Integer[]{alertId});
    }

    public StatusResponse delete(Integer[] alertIds) throws IOException {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        String[] ids = new String[alertIds.length];
        for (int i = 0; i < alertIds.length; ++i) {
            ids[i] = Integer.toString(alertIds[i]);
        }
        params.put("id", ids);
        return this.doGet("alert/delete.hqu", params, new XmlResponseHandler<StatusResponse>(StatusResponse.class));
    }
}

