/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.cm.filemonitor.utils;

import java.io.File;
import java.util.HashMap;
import org.hyperic.cm.filemonitor.utils.DirectoryRecursiveInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreatedDirsList
extends HashMap<String, DirectoryRecursiveInfo> {
    static Logger log = LoggerFactory.getLogger(CreatedDirsList.class);
    private int shortestLen = 0;

    public int getShortestLen() {
        return this.shortestLen;
    }

    public void setShortestLen(int shortestLen) {
        this.shortestLen = shortestLen;
    }

    public DirectoryRecursiveInfo getContainingDir(String path) {
        String testPath = path;
        while (testPath != null && testPath.length() >= this.shortestLen) {
            File f = new File(testPath);
            if (this.containsKey(testPath)) {
                DirectoryRecursiveInfo info = (DirectoryRecursiveInfo)((Object)this.get(testPath));
                if (log.isDebugEnabled()) {
                    log.debug("Contained: " + testPath + " in " + info.getDirPath());
                }
                return info;
            }
            testPath = f.getParent();
        }
        if (log.isDebugEnabled()) {
            log.debug("Not contained: " + path);
        }
        return null;
    }

    @Override
    public DirectoryRecursiveInfo put(String key, DirectoryRecursiveInfo value) {
        this.shortestLen = Math.max(this.shortestLen, key.length());
        return super.put(key, value);
    }

    @Override
    public void clear() {
        this.shortestLen = 0;
        super.clear();
    }
}

