/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.cm.versioncontrol.jgit;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.diff.EditList;
import org.eclipse.jgit.diff.MyersDiff;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.diff.RawTextComparator;
import org.eclipse.jgit.diff.Sequence;
import org.eclipse.jgit.diff.SequenceComparator;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.EmptyTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileDiff {
    static Logger logger = LoggerFactory.getLogger(FileDiff.class);
    private final RevCommit commit;
    private final DiffEntry diffEntry;

    private static ObjectId[] trees(RevCommit commit) {
        ObjectId[] r = new ObjectId[commit.getParentCount() + 1];
        for (int i = 0; i < r.length - 1; ++i) {
            RevTree tree = commit.getParent(i).getTree();
            if (tree == null) {
                return null;
            }
            r[i] = tree.getId();
        }
        r[r.length - 1] = commit.getTree().getId();
        return r;
    }

    public static FileDiff[] compute(TreeWalk walk, RevCommit commit) throws MissingObjectException, IncorrectObjectTypeException, CorruptObjectException, IOException {
        ArrayList<FileDiff> r = new ArrayList<FileDiff>();
        ObjectId[] ids = null;
        if (commit.getParentCount() > 0) {
            ids = FileDiff.trees(commit);
        }
        if (ids != null) {
            walk.reset((AnyObjectId[])ids);
        } else {
            walk.reset();
            walk.addTree((AbstractTreeIterator)new EmptyTreeIterator());
            walk.addTree((AnyObjectId)commit.getTree());
        }
        List entries = DiffEntry.scan((TreeWalk)walk);
        for (DiffEntry entry : entries) {
            FileDiff d = new FileDiff(commit, entry);
            r.add(d);
        }
        FileDiff[] tmp = new FileDiff[r.size()];
        r.toArray(tmp);
        return tmp;
    }

    public static FileDiff[] compute(TreeWalk walk, RevCommit commit, RevCommit commitComp, boolean recursive) throws MissingObjectException, IncorrectObjectTypeException, CorruptObjectException, IOException {
        ArrayList<FileDiff> r = new ArrayList<FileDiff>();
        RevCommit commit1 = commit;
        RevCommit commit2 = commitComp;
        if (commit1 != null && commit2 != null) {
            walk.reset();
            walk.addTree((AnyObjectId)commit1.getTree());
            walk.addTree((AnyObjectId)commit2.getTree());
        } else if (commit1.getParentCount() > 0) {
            walk.reset((AnyObjectId[])FileDiff.trees(commit1));
            if (commit2 != null) {
                walk.addTree((AnyObjectId)commit2.getTree());
            }
        } else {
            walk.reset();
            walk.addTree((AbstractTreeIterator)new EmptyTreeIterator());
            walk.addTree((AnyObjectId)commit.getTree());
            if (commit2 != null) {
                walk.addTree((AnyObjectId)commit2.getTree());
            }
        }
        walk.setRecursive(recursive);
        if (walk.getTreeCount() <= 2) {
            List entries = DiffEntry.scan((TreeWalk)walk);
            for (DiffEntry entry : entries) {
                FileDiff d = new FileDiff(commit1, entry);
                r.add(d);
            }
        } else {
            int nTree = walk.getTreeCount();
            int myTree = nTree - 1;
            while (walk.next()) {
                FileDiffForMerges d = new FileDiffForMerges(commit1);
                d.path = walk.getPathString();
                int m0 = 0;
                for (int i = 0; i < myTree; ++i) {
                    m0 |= walk.getRawMode(i);
                }
                int m1 = walk.getRawMode(myTree);
                d.change = DiffEntry.ChangeType.MODIFY;
                if (m0 == 0 && m1 != 0) {
                    d.change = DiffEntry.ChangeType.ADD;
                } else if (m0 != 0 && m1 == 0) {
                    d.change = DiffEntry.ChangeType.DELETE;
                } else if (m0 != m1 && walk.idEqual(0, myTree)) {
                    d.change = DiffEntry.ChangeType.MODIFY;
                }
                FileDiffForMerges.access$302(d, new ObjectId[nTree]);
                FileDiffForMerges.access$402(d, new FileMode[nTree]);
                for (int i = 0; i < nTree; ++i) {
                    ((FileDiffForMerges)d).blobs[i] = walk.getObjectId(i);
                    ((FileDiffForMerges)d).modes[i] = walk.getFileMode(i);
                }
                r.add(d);
            }
        }
        FileDiff[] tmp = new FileDiff[r.size()];
        r.toArray(tmp);
        return tmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void outputDiff(StringBuilder d, Repository db, DiffFormatter diffFmt, boolean gitFormat) throws IOException {
        if (gitFormat) {
            diffFmt.setRepository(db);
            diffFmt.format(this.diffEntry);
            return;
        }
        ObjectReader reader = db.newObjectReader();
        try {
            this.outputEclipseDiff(d, db, reader, diffFmt);
        }
        finally {
            reader.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void outputDiff(StringBuilder d, Repository db, DiffFormatter diffFmt, ObjectId[] blobs, FileMode[] modes, String filePath) throws IOException {
        ObjectReader reader = db.newObjectReader();
        try {
            FileDiff.outputEclipseDiff(d, db, reader, diffFmt, blobs, modes, filePath);
        }
        finally {
            reader.release();
        }
    }

    private void outputEclipseDiff(StringBuilder d, Repository db, ObjectReader reader, DiffFormatter diffFmt) throws IOException {
        FileDiff.outputEclipseDiff(d, db, reader, diffFmt, this.getBlobs(), this.getModes(), this.getProjectRelativePath(db, this.getPath()));
    }

    private static void outputEclipseDiff(StringBuilder d, Repository db, ObjectReader reader, DiffFormatter diffFmt, ObjectId[] blobs, FileMode[] modes, String path) throws IOException {
        if (blobs.length != 2) {
            throw new UnsupportedOperationException("Not supported yet if the number of parents is different from one");
        }
        String projectRelativePath = path;
        d.append("diff --git ").append(projectRelativePath).append(" ").append(projectRelativePath).append("\n");
        ObjectId id1 = blobs[0];
        ObjectId id2 = blobs[1];
        FileMode mode1 = modes[0];
        FileMode mode2 = modes[1];
        if (id1.equals((AnyObjectId)ObjectId.zeroId())) {
            d.append("new file mode " + mode2).append("\n");
        } else if (id2.equals((AnyObjectId)ObjectId.zeroId())) {
            d.append("deleted file mode " + mode1).append("\n");
        } else if (!mode1.equals(mode2)) {
            d.append("old mode " + mode1);
            d.append("new mode " + mode2).append("\n");
        }
        d.append("index ").append(reader.abbreviate((AnyObjectId)id1).name()).append("..").append(reader.abbreviate((AnyObjectId)id2).name()).append(mode1.equals(mode2) ? " " + mode1 : "").append("\n");
        if (id1.equals((AnyObjectId)ObjectId.zeroId())) {
            d.append("--- /dev/null\n");
        } else {
            d.append("--- ");
            d.append(path);
            d.append("\n");
        }
        if (id2.equals((AnyObjectId)ObjectId.zeroId())) {
            d.append("+++ /dev/null\n");
        } else {
            d.append("+++ ");
            d.append(path);
            d.append("\n");
        }
        RawText a = FileDiff.getRawText(id1, reader);
        RawText b = FileDiff.getRawText(id2, reader);
        EditList editList = MyersDiff.INSTANCE.diff((SequenceComparator)RawTextComparator.DEFAULT, (Sequence)a, (Sequence)b);
        diffFmt.format(editList, a, b);
    }

    private String getProjectRelativePath(Repository db, String repoPath) {
        return repoPath;
    }

    private static RawText getRawText(ObjectId id, ObjectReader reader) throws IOException {
        if (id.equals((AnyObjectId)ObjectId.zeroId())) {
            return new RawText(new byte[0]);
        }
        try {
            ObjectLoader ldr = reader.open((AnyObjectId)id, 3);
            return new RawText(ldr.getCachedBytes(Integer.MAX_VALUE));
        }
        catch (MissingObjectException e) {
            logger.warn(e.getMessage());
            return new RawText(new byte[0]);
        }
    }

    public RevCommit getCommit() {
        return this.commit;
    }

    public String getPath() {
        if (DiffEntry.ChangeType.DELETE.equals((Object)this.diffEntry.getChangeType())) {
            return this.diffEntry.getOldPath();
        }
        return this.diffEntry.getNewPath();
    }

    public DiffEntry.ChangeType getChange() {
        return this.diffEntry.getChangeType();
    }

    public ObjectId[] getBlobs() {
        ArrayList<ObjectId> objectIds = new ArrayList<ObjectId>();
        if (this.diffEntry.getOldId() != null) {
            objectIds.add(this.diffEntry.getOldId().toObjectId());
        }
        if (this.diffEntry.getNewId() != null) {
            objectIds.add(this.diffEntry.getNewId().toObjectId());
        }
        return objectIds.toArray(new ObjectId[0]);
    }

    public FileMode[] getModes() {
        ArrayList<FileMode> modes = new ArrayList<FileMode>();
        if (this.diffEntry.getOldMode() != null) {
            modes.add(this.diffEntry.getOldMode());
        }
        if (this.diffEntry.getOldMode() != null) {
            modes.add(this.diffEntry.getOldMode());
        }
        return modes.toArray(new FileMode[0]);
    }

    FileDiff(RevCommit c, DiffEntry entry) {
        this.diffEntry = entry;
        this.commit = c;
    }

    private static class FileDiffForMerges
    extends FileDiff {
        private String path;
        private DiffEntry.ChangeType change;
        private ObjectId[] blobs;
        private FileMode[] modes;

        private FileDiffForMerges(RevCommit c) {
            super(c, null);
        }

        public String getPath() {
            return this.path;
        }

        public DiffEntry.ChangeType getChange() {
            return this.change;
        }

        public ObjectId[] getBlobs() {
            return this.blobs;
        }

        public FileMode[] getModes() {
            return this.modes;
        }

        static /* synthetic */ ObjectId[] access$302(FileDiffForMerges x0, ObjectId[] x1) {
            x0.blobs = x1;
            return x1;
        }

        static /* synthetic */ FileMode[] access$402(FileDiffForMerges x0, FileMode[] x1) {
            x0.modes = x1;
            return x1;
        }
    }
}

