/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.cm.versioncontrol.jgit;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.tools.ant.filters.StringInputStream;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.eclipse.jgit.treewalk.WorkingTreeOptions;
import org.hyperic.cm.versioncontrol.jgit.ExtendedFileTreeIterator;
import org.hyperic.cm.versioncontrol.jgit.InputStreamWrapper;
import org.hyperic.cm.versioncontrol.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipfileTreeIterator
extends ExtendedFileTreeIterator {
    static Logger log = LoggerFactory.getLogger(ZipfileTreeIterator.class);
    protected ZipFile zipFile = null;
    protected ZipFileEntry currentEntry;
    private Enumeration<? extends ZipEntry> zipEntries;
    protected ZipFileEntry[] entries;
    protected static Set<String> extensionsForMd5 = null;
    private Set<String> includedExtensions = null;
    public Long zipFileCount = 0L;

    public ZipFile getZipFile() {
        return this.zipFile;
    }

    public ZipfileTreeIterator(ZipfileTreeIterator p, ZipFileEntry[] entries, ZipFile zf, Set<String> filterExt) {
        super(p);
        this.zipFile = zf;
        this.entries = entries;
        this.includedExtensions = filterExt;
        this.init(entries);
    }

    public void closeStream() throws IOException {
        if (this.zipFile != null) {
            this.zipFile.close();
        }
    }

    public ZipfileTreeIterator(Repository repo, String path) {
        super("", (WorkingTreeOptions)repo.getConfig().get(WorkingTreeOptions.KEY));
        this.initBase(path);
        this.initRootIterator(repo);
    }

    private void initBase(String path) {
        File file = new File(path);
        if (!file.exists()) {
            return;
        }
        HashMap<String, ZipFileEntry> dirsMap = new HashMap<String, ZipFileEntry>();
        try {
            this.zipFile = new ZipFile(file);
            this.zipEntries = this.zipFile.entries();
            ArrayList<ZipFileEntry> entCol = new ArrayList<ZipFileEntry>();
            block3: while (this.zipEntries.hasMoreElements()) {
                ZipEntry zEntry = this.zipEntries.nextElement();
                String zipName = zEntry.getName();
                if (!this.passedFilter(zipName)) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Entry filtered out: " + zipName);
                    continue;
                }
                ZipFileEntry entry = new ZipFileEntry(zEntry, this.zipFile, this.isBinary(zipName));
                this.addFileCount();
                File f = new File(zipName);
                String parent = f.getParent();
                if (zEntry.isDirectory()) {
                    if (dirsMap.get(zEntry.getName()) != null) continue;
                    dirsMap.put(zEntry.getName(), entry);
                }
                if (parent == null || parent.length() <= 0) {
                    entCol.add(entry);
                    continue;
                }
                ZipFileEntry containingDir = (ZipFileEntry)((Object)dirsMap.get(parent));
                if (containingDir != null) {
                    containingDir.addSubentry(entry);
                    continue;
                }
                String[] pathParts = zEntry.getName().split("/");
                Collection<ZipFileEntry> currLevelCol = entCol;
                ZipFileEntry lastLevel = null;
                String currPath = null;
                for (String s : pathParts) {
                    String string = currPath = currPath == null ? s : currPath + s;
                    if (currPath.equals(zEntry.getName())) {
                        lastLevel.addSubentry(entry);
                        continue block3;
                    }
                    currPath = currPath + "/";
                    ZipFileEntry found = null;
                    if (currLevelCol != null) {
                        for (ZipFileEntry ent : currLevelCol) {
                            if (!ent.getName().equals(s)) continue;
                            found = ent;
                            break;
                        }
                    }
                    if (found != null) {
                        currLevelCol = found.getEntryCol();
                        lastLevel = found;
                        found = null;
                        continue;
                    }
                    ZipFileEntry newDir = new ZipFileEntry(currPath);
                    if (lastLevel == null) {
                        entCol.add(newDir);
                    } else {
                        lastLevel.addSubentry(newDir);
                    }
                    dirsMap.put(currPath, newDir);
                    lastLevel = newDir;
                }
            }
            ZipFileEntry curr = null;
            for (File currFile = file; currFile != null && !currFile.getPath().equals(File.separator); currFile = currFile.getParentFile()) {
                ZipFileEntry parent = new ZipFileEntry(currFile.getPath());
                if (curr == null) {
                    parent.subtreeEntries = entCol;
                } else {
                    parent.addSubentry(curr);
                }
                curr = parent;
            }
            this.init(new WorkingTreeIterator.Entry[]{curr});
        }
        catch (ZipException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public AbstractTreeIterator createSubtreeIterator(ObjectReader reader) throws IncorrectObjectTypeException, IOException {
        ZipFileEntry[] subtreeEntries = ((ZipFileEntry)this.current()).getEntries();
        ((ZipFileEntry)this.current()).clearSubEntries();
        return new ZipfileTreeIterator(this, subtreeEntries, this.zipFile, this.includedExtensions);
    }

    public Long getFileCount() {
        return this.zipFileCount;
    }

    public void addFileCount() {
        Long l = this.zipFileCount;
        Long l2 = this.zipFileCount = Long.valueOf(this.zipFileCount + 1L);
    }

    public Set<String> getFilteredExtensions() {
        return this.includedExtensions;
    }

    public void setFilteredExtensions(Set<String> ext) {
        this.includedExtensions = ext;
    }

    public void setIncludedExtensions(String extString) {
        if (extString == null || extString.length() <= 0) {
            return;
        }
        String[] ext = extString.split(";");
        if (ext == null || ext.length <= 0) {
            return;
        }
        this.includedExtensions = new HashSet<String>();
        for (String s : ext) {
            this.includedExtensions.add(s);
        }
    }

    protected boolean passedFilter(String ext) {
        return this.includedExtensions == null || this.includedExtensions.size() <= 0 || this.includedExtensions.contains(ext);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ZipFileEntry
    extends ExtendedFileTreeIterator.ExtendedFileEntry {
        private ZipEntry zipEntry;
        private ZipFile zipFile;
        private Collection<ZipFileEntry> subtreeEntries = new ArrayList<ZipFileEntry>();
        protected boolean closeStream = false;

        public ZipFileEntry(ZipEntry zipEntry, ZipFile zipFile, boolean isBinary) {
            this.zipEntry = zipEntry;
            this.zipFile = zipFile;
            this.mode = zipEntry.isDirectory() ? FileMode.TREE : FileMode.REGULAR_FILE;
            this.length = zipEntry.getSize();
            this.lastModified = zipEntry.getTime();
            String relPath = zipEntry.getName();
            File f = new File(relPath);
            this.name = f.getName();
            this.isBinary = isBinary;
            if (isBinary) {
                this.getMd5();
                if (this.md5String != null && this.md5String.length() > 0) {
                    this.length = this.md5String.length();
                }
            }
        }

        public ZipFileEntry(String relPath) {
            this.mode = FileMode.TREE;
            this.lastModified = -1L;
            File f = new File(relPath);
            this.name = f.getName().length() == 0 ? Utils.getRoot(f.getPath()) : f.getName();
            this.length = f.length();
            this.isBinary = false;
        }

        public void addSubentry(ZipFileEntry zipFileEntry) {
            this.subtreeEntries.add(zipFileEntry);
        }

        public ZipFileEntry[] getEntries() {
            return this.subtreeEntries.toArray(new ZipFileEntry[this.subtreeEntries.size()]);
        }

        public void clearSubEntries() {
            this.subtreeEntries.clear();
        }

        public Collection<ZipFileEntry> getEntryCol() {
            return this.subtreeEntries;
        }

        @Override
        public InputStream openInputStream() throws IOException {
            if (this.zipEntry == null) {
                return null;
            }
            if (this.md5String != null && this.md5String.length() > 0) {
                this.closeStream = true;
                StringInputStream in = new StringInputStream(this.md5String);
                return new InputStreamWrapper((InputStream)in, false);
            }
            InputStream in = this.zipFile.getInputStream(this.zipEntry);
            return new InputStreamWrapper(in, true);
        }
    }
}

