/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.cm.versioncontrol.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    private static Logger logger = LoggerFactory.getLogger(Utils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getPropertiesFromClasspath(Class<?> clazz, String propFileName) throws IOException {
        Properties props = new Properties();
        InputStream inputStream = null;
        try {
            inputStream = clazz.getClassLoader().getResourceAsStream(propFileName);
            if (inputStream == null) {
                throw new FileNotFoundException("property file '" + propFileName + "' not found in the classpath");
            }
            props.load(inputStream);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        return props;
    }

    public static boolean recursiveCreateDir(String path) {
        if (path == null || path.length() == 0) {
            return false;
        }
        boolean success = true;
        StringBuffer sb = new StringBuffer(path.length());
        for (int i = 0; i < path.length(); ++i) {
            Character c = Character.valueOf(path.charAt(i));
            if (c.charValue() == File.separatorChar) {
                File f = new File(sb.toString());
                if (!f.exists() || f.exists() && f.isFile()) {
                    success = f.mkdir();
                }
                if (!success) {
                    logger.error("Failed to create directory: " + sb.toString() + " for file: " + path);
                    break;
                }
            }
            sb.append(c);
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean writeToFile(File f, byte[] content, boolean create) {
        boolean success = true;
        FileOutputStream fop = null;
        try {
            if (!f.exists() && create) {
                success = Utils.recursiveCreateDir(f.getCanonicalPath());
                if (!success) {
                    logger.error("Error creating file: " + f.getPath());
                    boolean bl = false;
                    return bl;
                }
                success = f.createNewFile();
            }
            if (!success) {
                boolean bl = success;
                return bl;
            }
            fop = new FileOutputStream(f, false);
            fop.write(content);
            fop.flush();
            return true;
        }
        catch (IOException e) {
            logger.error("Error writing to file: " + f.getPath() + " " + e.getMessage(), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (fop != null) {
                    fop.close();
                }
            }
            catch (IOException e) {}
        }
    }

    public static String getParentPath(String path) {
        if (path == null) {
            return null;
        }
        int index = path.lastIndexOf(47);
        if (index == -1) {
            index = path.lastIndexOf(92);
        }
        if (index == -1) {
            return null;
        }
        String parent = path.substring(0, index);
        if (parent.length() == 0) {
            return null;
        }
        return parent;
    }

    public static String fileName(String path) {
        if (path == null) {
            return null;
        }
        int index = path.lastIndexOf(47);
        if (index == -1) {
            index = path.lastIndexOf(92);
        }
        if (index == -1) {
            return null;
        }
        String name = path.substring(index + 1);
        if (name.length() == 0) {
            return null;
        }
        return name;
    }

    public static String getFileExtension(String name) {
        if (name == null) {
            return null;
        }
        int k = name.lastIndexOf(".");
        String ext = null;
        if (k != -1) {
            ext = name.substring(k + 1, name.length());
        }
        return ext;
    }

    public static String getHashHexDigest(InputStream fis) throws IOException {
        int n;
        byte[] buf = new byte[1024];
        MessageDigest md5digest = null;
        try {
            md5digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            System.out.println("MD5 Algorithm seems to be missing!?!?");
        }
        do {
            if ((n = fis.read(buf)) <= 0) continue;
            md5digest.update(buf, 0, n);
        } while (n != -1);
        byte[] md5bytes = md5digest.digest();
        String md5hex = "";
        for (int i = 0; i < md5bytes.length; ++i) {
            md5hex = md5hex + Integer.toString((md5bytes[i] & 0xFF) + 256, 16).substring(1);
        }
        return md5hex;
    }

    public static String formatPath(String path) {
        String replaceSlash = path.replace("\\", "/");
        String formattedPath = replaceSlash.replace("//", "/");
        if (formattedPath.startsWith("/")) {
            formattedPath = formattedPath.substring(1, formattedPath.length());
        }
        formattedPath = Utils.formatWinDrive(formattedPath);
        return formattedPath;
    }

    public static String formatWinDrive(String path) {
        String s = path;
        if (path.charAt(1) == ':') {
            s = path.substring(0, 1).toLowerCase() + path.substring(1);
        }
        return s;
    }

    public static String getMd5Stream(InputStream is) {
        String md5String = null;
        try {
            md5String = Utils.getHashHexDigest(is);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        if (md5String == null || md5String.length() <= 0) {
            logger.error("MD5 String null or empty.");
        }
        return md5String;
    }

    public static String getRoot(String path) {
        File f = new File(path);
        while (f.getParentFile() != null) {
            f = f.getParentFile();
        }
        String s = f.getName();
        String t = f.getPath();
        if (s.length() == 0 && t.length() > 0) {
            int i = t.indexOf(File.separator, 1);
            s = i > 0 ? t.substring(0, i) : t;
        }
        return s;
    }
}

