/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.hyper_v;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.AutoServerDetector;
import org.hyperic.hq.product.DetectionUtil;
import org.hyperic.hq.product.GenericPlugin;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.ServerDetector;
import org.hyperic.hq.product.ServerResource;
import org.hyperic.hq.product.ServiceResource;
import org.hyperic.sigar.win32.Pdh;
import org.hyperic.sigar.win32.Win32Exception;
import org.hyperic.util.config.ConfigResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HyperVDetector
extends ServerDetector
implements AutoServerDetector {
    private static Log log = LogFactory.getLog(HyperVDetector.class);

    public List getServerResources(ConfigResponse platformConfig) throws PluginException {
        Set wmiObjs = DetectionUtil.getWMIObj((String)"root\\virtualization", (String)"Msvm_ComputerSystem", Collections.singletonMap("Caption-Virtual Machine", "="), (String)"Name", (String)"");
        ArrayList<ServerResource> servers = new ArrayList<ServerResource>();
        if (wmiObjs == null || wmiObjs.isEmpty()) {
            return null;
        }
        for (String guid : wmiObjs) {
            Set vmNames = DetectionUtil.getWMIObj((String)"root\\virtualization", (String)"Msvm_ComputerSystem", Collections.singletonMap("Name-" + guid, "="), (String)"ElementName", (String)"");
            if (vmNames == null || vmNames.isEmpty()) continue;
            ServerResource server = new ServerResource();
            ConfigResponse conf = new ConfigResponse();
            String name = (String)vmNames.iterator().next();
            conf.setValue("instance.name", name);
            conf.setValue("GUID", guid);
            Set macs = DetectionUtil.getWMIObj((String)"root\\virtualization", (String)"CIM_EthernetPort", Collections.singletonMap("SystemName-" + guid, "="), (String)"PermanentAddress", (String)"");
            StringBuilder sb = new StringBuilder();
            if (macs != null && !macs.isEmpty()) {
                for (String mac : macs) {
                    if (mac == null || mac.length() <= 0) continue;
                    StringBuilder macSB = new StringBuilder(mac);
                    for (int i = 2; i < macSB.length(); i += 3) {
                        macSB.insert(i, ':');
                    }
                    sb.append((CharSequence)macSB).append(',');
                }
                String macsStr = sb.delete(sb.length() - 1, sb.length()).toString();
                conf.setValue("Mac", macsStr);
            }
            conf.setValue("removable", true);
            server.setMeasurementConfig();
            server.setName(HyperVDetector.getPlatformName() + "  Hyper-V VM - " + name);
            server.setDescription("");
            server.setIdentifier(name);
            server.setType("Hyper-V VM");
            this.setProductConfig(server, conf);
            servers.add(server);
            servers.add(server);
        }
        return servers;
    }

    private ServiceResource createService(String type, String name, String serviceInstanceName, String instanceName, String propertySuffix, String properySuffixName) {
        ConfigResponse conf = new ConfigResponse();
        conf.setValue("service.instance.name", serviceInstanceName);
        conf.setValue("instance.name", instanceName);
        if (properySuffixName != null) {
            conf.setValue(properySuffixName, propertySuffix);
        }
        ServiceResource service = new ServiceResource();
        service.setType((GenericPlugin)this, type);
        service.setServiceName(name);
        ConfigResponse cprops = new ConfigResponse();
        service.setProductConfig(conf);
        service.setMeasurementConfig();
        service.setCustomProperties(cprops);
        return service;
    }

    protected List<ServiceResource> discoverServices(String propertySet, String type, String namePrefix, String token, String instanceName, String propertySuffix, String properySuffixName) {
        ArrayList<ServiceResource> services = new ArrayList<ServiceResource>();
        String[] instances = null;
        try {
            if (properySuffixName != null) {
                instances = Pdh.getInstances((String)(propertySet + propertySuffix));
            }
        }
        catch (Win32Exception e) {
            propertySuffix = "";
            instances = null;
        }
        try {
            if (instances == null || instances.length == 0) {
                propertySuffix = "";
                instances = Pdh.getInstances((String)propertySet);
            }
            HashSet<String> names = new HashSet<String>();
            for (int i = 0; i < instances.length; ++i) {
                String instancePrefix;
                String instance = instances[i];
                if ("_Total".equals(instance) || "<All instances>".equals(instance) || !instance.startsWith(instancePrefix = instanceName + token)) continue;
                log.debug((Object)("find instance=" + instance + " of:" + instanceName));
                names.add(instance);
            }
            for (String name : names) {
                services.add(this.createService(type, namePrefix + name, name, instanceName, propertySuffix, properySuffixName));
            }
            if (services.isEmpty()) {
                return null;
            }
            return services;
        }
        catch (Win32Exception e) {
            log.debug((Object)("Error getting pdh data for " + type + ": " + (Object)((Object)e)), (Throwable)e);
            return null;
        }
    }

    protected List discoverServices(ConfigResponse config) throws PluginException {
        String vmGuid;
        List<ServiceResource> virtualIdeControllers;
        List<ServiceResource> legacyNetworkServices;
        List<ServiceResource> virtualNetworkServices;
        String instanceName = config.getValue("instance.name");
        log.debug((Object)("instance.name=" + instanceName));
        if (instanceName == null || instanceName.length() == 0) {
            log.error((Object)"discover services: - instance.name not found!");
        }
        LinkedList<ServiceResource> services = new LinkedList<ServiceResource>();
        List<ServiceResource> virtualProcessorServices = this.discoverServices("Hyper-V Hypervisor Virtual Processor", "Hyper-V Hypervisor Virtual Processor", "Hyper-V Hypervisor Virtual Processor - ", ":", instanceName, null, null);
        if (virtualProcessorServices != null) {
            services.addAll(virtualProcessorServices);
        }
        if ((virtualNetworkServices = this.discoverServices("Hyper-V Virtual Network Adapter", "Hyper-V Virtual Network Adapter", "Hyper-V Virtual Network Adapter - ", "_", instanceName, null, null)) != null) {
            services.addAll(virtualNetworkServices);
        }
        if ((legacyNetworkServices = this.discoverServices("Hyper-V Legacy Network Adapter", "Hyper-V Legacy Network Adapter", "Hyper-V Legacy Network Adapter - ", ":", instanceName, null, null)) != null) {
            services.addAll(legacyNetworkServices);
        }
        if ((virtualIdeControllers = this.discoverServices("Hyper-V Virtual IDE Controller", "Hyper-V Virtual IDE Controller", "Hyper-V Virtual IDE Controller - ", ":", instanceName, " (Emulated)", "emulated")) != null) {
            services.addAll(virtualIdeControllers);
        }
        if ((vmGuid = config.getValue("GUID")) != null) {
            log.debug((Object)("instanceNAME=" + instanceName + " guid=" + vmGuid));
            List<ServiceResource> storageServices = this.discoverStorageServices(vmGuid, instanceName);
            if (storageServices != null) {
                services.addAll(storageServices);
            }
        } else {
            log.error((Object)("null guid for:" + instanceName));
        }
        if (services.isEmpty()) {
            return null;
        }
        return services;
    }

    private List<ServiceResource> discoverStorageServices(String vmGuid, String instanceName) {
        ArrayList<ServiceResource> services = new ArrayList<ServiceResource>();
        HashMap<String, String> filters = new HashMap<String, String>(2);
        filters.put("ElementName-Hard Disk Image", "=");
        filters.put("InstanceID-%" + vmGuid + "%", "like");
        try {
            Set wmiObjs = DetectionUtil.getWMIObj((String)"root\\virtualization", (String)"Msvm_ResourceAllocationSettingData", filters, (String)"Connection", (String)"");
            log.debug((Object)("storage for instance=" + instanceName + " guid=" + vmGuid + " is:" + wmiObjs));
            if (wmiObjs == null) {
                log.debug((Object)("no storage were found for instance=" + instanceName + " guid=" + vmGuid));
                return null;
            }
            for (String obj : wmiObjs) {
                String serviceInstanceName;
                log.debug((Object)("storage obj=<" + obj + ">"));
                String serviceStr = serviceInstanceName = obj.substring(2, obj.length() - 2);
                serviceInstanceName = serviceInstanceName.replace("\\", "-");
                log.debug((Object)("service instance name=<" + serviceInstanceName + ">"));
                ServiceResource service = this.createService("Hyper-V Virtual Storage Device", "Hyper-V Virtual Storage Device - " + serviceStr, serviceInstanceName, instanceName, null, null);
                services.add(service);
            }
            if (services.isEmpty()) {
                return null;
            }
            return services;
        }
        catch (PluginException e) {
            log.info((Object)("faled to get Msvm_ResourceAllocationSettingData: for:" + vmGuid + " " + e.getMessage()));
            return null;
        }
    }
}

