/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.hyper_v;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.plugin.hyper_v.HyperVMeasurementPlugin;
import org.hyperic.hq.product.Collector;
import org.hyperic.hq.product.CollectorResult;
import org.hyperic.hq.product.Metric;
import org.hyperic.hq.product.MetricValue;
import org.hyperic.sigar.win32.Pdh;

public class HypervCollector
extends Collector {
    private static Log log = LogFactory.getLog(HypervCollector.class);
    private Map<String, Long> counters = new HashMap<String, Long>();
    private static long MAX_TIME_WITHOUT_QUERY = 3600000L;

    public void collect() {
        log.debug((Object)("[collect] [" + this.getProperties() + "] counters.size() = " + this.counters.size()));
        if (this.counters.size() > 0) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("before getFormattedValues: counetrs=" + this.counters));
                }
                Map res = new Pdh().getFormattedValues(this.counters.keySet());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("after getFormattedValues res=" + res));
                }
                for (Map.Entry entry : res.entrySet()) {
                    String obj = (String)entry.getKey();
                    Double val = (Double)entry.getValue();
                    log.debug((Object)("[collect] " + obj + " = " + val));
                    this.setValue(obj, val);
                }
            }
            catch (Exception ex) {
                log.debug((Object)("[collect] " + ex), (Throwable)ex);
            }
            this.cleanExpiredEntries();
        }
    }

    private void cleanExpiredEntries() {
        Set<Map.Entry<String, Long>> entries = this.counters.entrySet();
        Iterator<Map.Entry<String, Long>> it = entries.iterator();
        long currentTime = System.currentTimeMillis();
        while (it.hasNext()) {
            Map.Entry<String, Long> entry = it.next();
            if (currentTime - entry.getValue() <= MAX_TIME_WITHOUT_QUERY) continue;
            log.debug((Object)("removing counter=" + entry.getKey() + " was not queryied for more than:" + MAX_TIME_WITHOUT_QUERY / 60000L + " minutes"));
            it.remove();
        }
    }

    public MetricValue getValue(Metric metric, CollectorResult result) {
        String obj = HyperVMeasurementPlugin.getPath(metric);
        MetricValue res = MetricValue.NONE;
        if (obj != null) {
            if (this.counters.containsKey(obj)) {
                res = result.getMetricValue(obj);
            }
            this.counters.put(obj, System.currentTimeMillis());
        }
        log.debug((Object)("[getValue] obj:'" + obj + "' res:'" + res.getValue() + "'"));
        return res;
    }
}

