/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.junit;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheBuilder;
import org.eclipse.jgit.dircache.DirCacheEditor;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.ObjectWritingException;
import org.eclipse.jgit.junit.MockSystemReader;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectChecker;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.RefWriter;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.TagBuilder;
import org.eclipse.jgit.revwalk.ObjectWalk;
import org.eclipse.jgit.revwalk.RevBlob;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileRepository;
import org.eclipse.jgit.storage.file.LockFile;
import org.eclipse.jgit.storage.file.ObjectDirectory;
import org.eclipse.jgit.storage.file.PackFile;
import org.eclipse.jgit.storage.file.PackIndex;
import org.eclipse.jgit.storage.pack.PackWriter;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.eclipse.jgit.util.FileUtils;
import org.junit.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestRepository<R extends Repository> {
    private static final PersonIdent author;
    private static final PersonIdent committer;
    private final R db;
    private final RevWalk pool;
    private final ObjectInserter inserter;
    private long now;

    public TestRepository(R db) throws IOException {
        this(db, new RevWalk(db));
    }

    public TestRepository(R db, RevWalk rw) throws IOException {
        this.db = db;
        this.pool = rw;
        this.inserter = db.newObjectInserter();
        this.now = 1236977987000L;
    }

    public R getRepository() {
        return this.db;
    }

    public RevWalk getRevWalk() {
        return this.pool;
    }

    public Date getClock() {
        return new Date(this.now);
    }

    public void tick(int secDelta) {
        this.now += (long)secDelta * 1000L;
    }

    public void setAuthorAndCommitter(org.eclipse.jgit.lib.CommitBuilder c) {
        c.setAuthor(new PersonIdent(author, new Date(this.now)));
        c.setCommitter(new PersonIdent(committer, new Date(this.now)));
    }

    public RevBlob blob(String content) throws Exception {
        return this.blob(content.getBytes("UTF-8"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RevBlob blob(byte[] content) throws Exception {
        ObjectId id;
        try {
            id = this.inserter.insert(3, content);
            this.inserter.flush();
        }
        finally {
            this.inserter.release();
        }
        return this.pool.lookupBlob((AnyObjectId)id);
    }

    public DirCacheEntry file(String path, RevBlob blob) throws Exception {
        DirCacheEntry e = new DirCacheEntry(path);
        e.setFileMode(FileMode.REGULAR_FILE);
        e.setObjectId((AnyObjectId)blob);
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RevTree tree(DirCacheEntry ... entries) throws Exception {
        ObjectId root;
        DirCache dc = DirCache.newInCore();
        DirCacheBuilder b = dc.builder();
        for (DirCacheEntry e : entries) {
            b.add(e);
        }
        b.finish();
        try {
            root = dc.writeTree(this.inserter);
            this.inserter.flush();
        }
        finally {
            this.inserter.release();
        }
        return this.pool.lookupTree((AnyObjectId)root);
    }

    public RevObject get(RevTree tree, String path) throws Exception {
        TreeWalk tw = new TreeWalk(this.pool.getObjectReader());
        tw.setFilter(PathFilterGroup.createFromStrings(Collections.singleton(path)));
        tw.reset((AnyObjectId)tree);
        while (tw.next()) {
            if (tw.isSubtree() && !path.equals(tw.getPathString())) {
                tw.enterSubtree();
                continue;
            }
            ObjectId entid = tw.getObjectId(0);
            FileMode entmode = tw.getFileMode(0);
            return this.pool.lookupAny((AnyObjectId)entid, entmode.getObjectType());
        }
        Assert.fail((String)("Can't find " + path + " in tree " + tree.name()));
        return null;
    }

    public RevCommit commit(RevCommit ... parents) throws Exception {
        return this.commit(1, this.tree(new DirCacheEntry[0]), parents);
    }

    public RevCommit commit(RevTree tree, RevCommit ... parents) throws Exception {
        return this.commit(1, tree, parents);
    }

    public RevCommit commit(int secDelta, RevCommit ... parents) throws Exception {
        return this.commit(secDelta, this.tree(new DirCacheEntry[0]), parents);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RevCommit commit(int secDelta, RevTree tree, RevCommit ... parents) throws Exception {
        ObjectId id;
        this.tick(secDelta);
        org.eclipse.jgit.lib.CommitBuilder c = new org.eclipse.jgit.lib.CommitBuilder();
        c.setTreeId((AnyObjectId)tree);
        c.setParentIds((ObjectId[])parents);
        c.setAuthor(new PersonIdent(author, new Date(this.now)));
        c.setCommitter(new PersonIdent(committer, new Date(this.now)));
        c.setMessage("");
        try {
            id = this.inserter.insert(c);
            this.inserter.flush();
        }
        finally {
            this.inserter.release();
        }
        return this.pool.lookupCommit((AnyObjectId)id);
    }

    public CommitBuilder commit() {
        return new CommitBuilder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RevTag tag(String name, RevObject dst) throws Exception {
        ObjectId id;
        TagBuilder t = new TagBuilder();
        t.setObjectId(dst);
        t.setTag(name);
        t.setTagger(new PersonIdent(committer, new Date(this.now)));
        t.setMessage("");
        try {
            id = this.inserter.insert(t);
            this.inserter.flush();
        }
        finally {
            this.inserter.release();
        }
        return (RevTag)this.pool.lookupAny((AnyObjectId)id, 4);
    }

    public RevCommit update(String ref, CommitBuilder to) throws Exception {
        return this.update(ref, to.create());
    }

    public <T extends AnyObjectId> T update(String ref, T obj) throws Exception {
        if (!("HEAD".equals(ref) || "FETCH_HEAD".equals(ref) || "MERGE_HEAD".equals(ref) || ref.startsWith("refs/"))) {
            ref = "refs/heads/" + ref;
        }
        RefUpdate u = this.db.updateRef(ref);
        u.setNewObjectId(obj);
        switch (u.forceUpdate()) {
            case FAST_FORWARD: 
            case FORCED: 
            case NEW: 
            case NO_CHANGE: {
                this.updateServerInfo();
                return obj;
            }
        }
        throw new IOException("Cannot write " + ref + " " + u.getResult());
    }

    public void updateServerInfo() throws Exception {
        if (this.db instanceof FileRepository) {
            final FileRepository fr = (FileRepository)this.db;
            RefWriter rw = new RefWriter(fr.getAllRefs().values()){

                protected void writeFile(String name, byte[] bin) throws IOException {
                    File path = new File(fr.getDirectory(), name);
                    TestRepository.this.writeFile(path, bin);
                }
            };
            rw.writePackedRefs();
            rw.writeInfoRefs();
            StringBuilder w = new StringBuilder();
            for (PackFile p : fr.getObjectDatabase().getPacks()) {
                w.append("P ");
                w.append(p.getPackFile().getName());
                w.append('\n');
            }
            this.writeFile(new File(new File(fr.getObjectDatabase().getDirectory(), "info"), "packs"), Constants.encodeASCII((String)w.toString()));
        }
    }

    public <T extends RevObject> T parseBody(T object) throws Exception {
        this.pool.parseBody(object);
        return object;
    }

    public BranchBuilder branch(String ref) {
        if (!"HEAD".equals(ref) && !ref.startsWith("refs/")) {
            ref = "refs/heads/" + ref;
        }
        return new BranchBuilder(ref);
    }

    public void fsck(RevObject ... tips) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        RevCommit o;
        ObjectWalk ow = new ObjectWalk(this.db);
        if (tips.length != 0) {
            for (RevObject o2 : tips) {
                ow.markStart(ow.parseAny((AnyObjectId)o2));
            }
        } else {
            for (Ref r : this.db.getAllRefs().values()) {
                ow.markStart(ow.parseAny((AnyObjectId)r.getObjectId()));
            }
        }
        ObjectChecker oc = new ObjectChecker();
        while ((o = ow.next()) != null) {
            byte[] bin = this.db.open((AnyObjectId)o, o.getType()).getCachedBytes();
            oc.checkCommit(bin);
            TestRepository.assertHash((RevObject)o, bin);
        }
        while ((o = ow.nextObject()) != null) {
            byte[] bin = this.db.open((AnyObjectId)o, o.getType()).getCachedBytes();
            oc.check(o.getType(), bin);
            TestRepository.assertHash((RevObject)o, bin);
        }
    }

    private static void assertHash(RevObject id, byte[] bin) {
        MessageDigest md = Constants.newMessageDigest();
        md.update(Constants.encodedTypeString((int)id.getType()));
        md.update((byte)32);
        md.update(Constants.encodeASCII((long)bin.length));
        md.update((byte)0);
        md.update(bin);
        Assert.assertEquals((Object)id, (Object)ObjectId.fromRaw((byte[])md.digest()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void packAndPrune() throws Exception {
        if (this.db.getObjectDatabase() instanceof ObjectDirectory) {
            File idx;
            File pack;
            ObjectDirectory odb = (ObjectDirectory)this.db.getObjectDatabase();
            NullProgressMonitor m = NullProgressMonitor.INSTANCE;
            PackWriter pw = new PackWriter(this.db);
            try {
                HashSet<ObjectId> all = new HashSet<ObjectId>();
                for (Ref r : this.db.getAllRefs().values()) {
                    all.add(r.getObjectId());
                }
                pw.preparePack((ProgressMonitor)m, all, Collections.emptySet());
                ObjectId name = pw.computeName();
                pack = TestRepository.nameFor(odb, name, ".pack");
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(pack));
                try {
                    pw.writePack((ProgressMonitor)m, (ProgressMonitor)m, (OutputStream)out);
                }
                finally {
                    ((OutputStream)out).close();
                }
                pack.setReadOnly();
                idx = TestRepository.nameFor(odb, name, ".idx");
                out = new BufferedOutputStream(new FileOutputStream(idx));
                try {
                    pw.writeIndex((OutputStream)out);
                }
                finally {
                    ((OutputStream)out).close();
                }
                idx.setReadOnly();
            }
            finally {
                pw.release();
            }
            odb.openPack(pack, idx);
            this.updateServerInfo();
            this.prunePacked(odb);
        }
    }

    private void prunePacked(ObjectDirectory odb) throws IOException {
        for (PackFile p : odb.getPacks()) {
            for (PackIndex.MutableEntry e : p) {
                FileUtils.delete((File)odb.fileFor((AnyObjectId)e.toObjectId()));
            }
        }
    }

    private static File nameFor(ObjectDirectory odb, ObjectId name, String t) {
        File packdir = new File(odb.getDirectory(), "pack");
        return new File(packdir, "pack-" + name.name() + t);
    }

    private void writeFile(File p, byte[] bin) throws IOException, ObjectWritingException {
        LockFile lck = new LockFile(p, this.db.getFS());
        if (!lck.lock()) {
            throw new ObjectWritingException("Can't write " + p);
        }
        try {
            lck.write(bin);
        }
        catch (IOException ioe) {
            throw new ObjectWritingException("Can't write " + p);
        }
        if (!lck.commit()) {
            throw new ObjectWritingException("Can't write " + p);
        }
    }

    static {
        MockSystemReader m = new MockSystemReader();
        long now = m.getCurrentTime();
        int tz = m.getTimezone(now);
        String an = "J. Author";
        String ae = "jauthor@example.com";
        author = new PersonIdent("J. Author", "jauthor@example.com", now, tz);
        String cn = "J. Committer";
        String ce = "jcommitter@example.com";
        committer = new PersonIdent("J. Committer", "jcommitter@example.com", now, tz);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CommitBuilder {
        private final BranchBuilder branch;
        private final DirCache tree = DirCache.newInCore();
        private final List<RevCommit> parents = new ArrayList<RevCommit>(2);
        private int tick = 1;
        private String message = "";
        private RevCommit self;

        CommitBuilder() {
            this.branch = null;
        }

        CommitBuilder(BranchBuilder b) throws Exception {
            this.branch = b;
            Ref ref = TestRepository.this.db.getRef(this.branch.ref);
            if (ref != null) {
                this.parent(TestRepository.this.pool.parseCommit((AnyObjectId)ref.getObjectId()));
            }
        }

        CommitBuilder(CommitBuilder prior) throws Exception {
            this.branch = prior.branch;
            DirCacheBuilder b = this.tree.builder();
            for (int i = 0; i < prior.tree.getEntryCount(); ++i) {
                b.add(prior.tree.getEntry(i));
            }
            b.finish();
            this.parents.add(prior.create());
        }

        public CommitBuilder parent(RevCommit p) throws Exception {
            if (this.parents.isEmpty()) {
                DirCacheBuilder b = this.tree.builder();
                TestRepository.this.parseBody(p);
                b.addTree(new byte[0], 0, TestRepository.this.pool.getObjectReader(), (AnyObjectId)p.getTree());
                b.finish();
            }
            this.parents.add(p);
            return this;
        }

        public CommitBuilder noParents() {
            this.parents.clear();
            return this;
        }

        public CommitBuilder noFiles() {
            this.tree.clear();
            return this;
        }

        public CommitBuilder add(String path, String content) throws Exception {
            return this.add(path, TestRepository.this.blob(content));
        }

        public CommitBuilder add(String path, final RevBlob id) throws Exception {
            DirCacheEditor e = this.tree.editor();
            e.add(new DirCacheEditor.PathEdit(path){

                public void apply(DirCacheEntry ent) {
                    ent.setFileMode(FileMode.REGULAR_FILE);
                    ent.setObjectId((AnyObjectId)id);
                }
            });
            e.finish();
            return this;
        }

        public CommitBuilder rm(String path) {
            DirCacheEditor e = this.tree.editor();
            e.add((DirCacheEditor.PathEdit)new DirCacheEditor.DeletePath(path));
            e.add((DirCacheEditor.PathEdit)new DirCacheEditor.DeleteTree(path));
            e.finish();
            return this;
        }

        public CommitBuilder message(String m) {
            this.message = m;
            return this;
        }

        public CommitBuilder tick(int secs) {
            this.tick = secs;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public RevCommit create() throws Exception {
            if (this.self == null) {
                ObjectId commitId;
                TestRepository.this.tick(this.tick);
                org.eclipse.jgit.lib.CommitBuilder c = new org.eclipse.jgit.lib.CommitBuilder();
                c.setParentIds(this.parents);
                TestRepository.this.setAuthorAndCommitter(c);
                c.setMessage(this.message);
                try {
                    c.setTreeId((AnyObjectId)this.tree.writeTree(TestRepository.this.inserter));
                    commitId = TestRepository.this.inserter.insert(c);
                    TestRepository.this.inserter.flush();
                }
                finally {
                    TestRepository.this.inserter.release();
                }
                this.self = TestRepository.this.pool.lookupCommit((AnyObjectId)commitId);
                if (this.branch != null) {
                    this.branch.update(this.self);
                }
            }
            return this.self;
        }

        public CommitBuilder child() throws Exception {
            return new CommitBuilder(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class BranchBuilder {
        private final String ref;

        BranchBuilder(String ref) {
            this.ref = ref;
        }

        public CommitBuilder commit() throws Exception {
            return new CommitBuilder(this);
        }

        public RevCommit update(CommitBuilder to) throws Exception {
            return this.update(to.create());
        }

        public RevCommit update(RevCommit to) throws Exception {
            return TestRepository.this.update(this.ref, to);
        }
    }
}

