/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.db2jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.hyperic.hq.product.JDBCMeasurementPlugin;
import org.hyperic.hq.product.Metric;
import org.hyperic.hq.product.MetricNotFoundException;
import org.hyperic.hq.product.MetricUnreachableException;
import org.hyperic.hq.product.MetricValue;
import org.hyperic.util.jdbc.DBUtil;

public abstract class CachedJDBCMeasurement
extends JDBCMeasurementPlugin {
    private static final String EXEC_TIME_ATTR = "QueryExecTime";
    private static final Hashtable cache = new Hashtable();

    protected void initQueries() {
    }

    protected String getDefaultURL() {
        return "";
    }

    public MetricValue getValue(Metric metric) throws MetricUnreachableException, MetricNotFoundException {
        Map values;
        String key = this.getCacheKey(metric);
        CacheEntry ce = (CacheEntry)cache.get(key);
        if (!this.isCacheEntryValid(ce, metric)) {
            try {
                values = this.executeQuery(metric);
                cache.put(key, new CacheEntry(values));
            }
            catch (MetricNotFoundException ex) {
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().error((Object)("Metric: '" + metric + "' Error='" + ex.getMessage() + "'"), (Throwable)ex);
                }
                throw ex;
            }
        } else {
            values = (Map)ce.getEntry();
        }
        MetricValue res = (MetricValue)values.get(metric.getAttributeName());
        if (res == null) {
            throw new MetricNotFoundException(metric.getAttributeName() + " => NULL");
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Map executeQuery(Metric metric) throws MetricNotFoundException {
        HashMap<String, MetricValue> res = new HashMap<String, MetricValue>();
        res.put("availability", new MetricValue(0.0));
        String query = this.getQuery(metric);
        if (query == null) {
            throw new IllegalArgumentException("No SQL query");
        }
        this.getLog().debug((Object)("[executeQuery] query='" + query + "'"));
        String url = metric.getProperties().getProperty("jdbcUrl");
        String user = metric.getProperties().getProperty("jdbcUser");
        String pass = metric.getProperties().getProperty("jdbcPassword");
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        Statement tps = null;
        try {
            conn = this.getCachedConnection(url, user, pass);
            tps = conn.prepareStatement("select 1 from sysibm.sysdummy1");
            tps.execute();
            this.getLog().debug((Object)("** cn - " + url + user + pass + " - " + conn));
        }
        catch (SQLException e) {
            Statement tps2 = null;
            try {
                this.getLog().debug((Object)("conection closed '" + e.getMessage() + "'... reconectinig (" + url + ")"));
                this.removeCachedConnection(url, user, pass);
                conn = this.getCachedConnection(url, user, pass);
                tps2 = conn.prepareStatement("select 1 from sysibm.sysdummy1");
                tps2.execute();
            }
            catch (SQLException ex) {
                this.removeCachedConnection(url, user, pass);
                throw new MetricNotFoundException(ex.getMessage());
            }
            finally {
                if (tps2 != null) {
                    try {
                        tps2.close();
                    }
                    catch (SQLException ex) {
                        this.removeCachedConnection(url, user, pass);
                        throw new MetricNotFoundException(ex.getMessage());
                    }
                }
            }
        }
        finally {
            if (tps != null) {
                try {
                    tps.close();
                }
                catch (SQLException ex) {
                    this.removeCachedConnection(url, user, pass);
                    throw new MetricNotFoundException(ex.getMessage());
                }
            }
        }
        try {
            ps = conn.prepareStatement(query);
            long startTime = System.currentTimeMillis();
            rs = ps.executeQuery();
            long totalTime = System.currentTimeMillis() - startTime;
            res.put(EXEC_TIME_ATTR, new MetricValue(totalTime));
            res.put("availability", new MetricValue(1.0));
            if (this.getLog().isTraceEnabled()) {
                this.getLog().trace((Object)("key='availability'\tvalue='" + res.get("availability") + "'(" + res.get("availability").getClass() + ")"));
            }
            res.putAll(this.processResulSet(rs, metric));
        }
        catch (SQLException ex) {
            try {
                this.getLog().error((Object)"Error fetching metrics", (Throwable)ex);
                this.removeCachedConnection(url, user, pass);
                throw new MetricNotFoundException(ex.getMessage());
            }
            catch (Throwable throwable) {
                DBUtil.closeJDBCObjects((Object)this.getLog(), null, (Statement)ps, rs);
                throw throwable;
            }
        }
        DBUtil.closeJDBCObjects((Object)this.getLog(), null, (Statement)ps, (ResultSet)rs);
        return res;
    }

    abstract Map processResulSet(ResultSet var1, Metric var2) throws MetricNotFoundException;

    private String getCacheKey(Metric metric) {
        return this.getQuery(metric) + metric.getProperties().toString();
    }

    private boolean isCacheEntryValid(CacheEntry ce, Metric metric) {
        boolean invalid;
        long now = System.currentTimeMillis() / 1000L;
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((Object)("-->getValue(" + metric + ")"));
            if (ce == null) {
                this.getLog().debug((Object)"== ce==null");
            } else if (metric.getAttributeName().equals("availability")) {
                this.getLog().debug((Object)"== AVAIL_ATTR");
            } else if (metric.getAttributeName().equals(EXEC_TIME_ATTR)) {
                this.getLog().debug((Object)"== EXEC_TIME_ATTR");
            } else if (now - ce.getTime() > 60L) {
                this.getLog().debug((Object)("== time='" + (now - ce.getTime()) + "'"));
            }
        }
        boolean bl = invalid = ce == null || now - ce.getTime() > 60L || metric.getAttributeName().endsWith("availability") || metric.getAttributeName().equals(EXEC_TIME_ATTR);
        if (this.getLog().isDebugEnabled()) {
            if (invalid) {
                this.getLog().debug((Object)"*** NO CACHE ***");
            } else {
                this.getLog().debug((Object)"*** CACHE HIT ***");
            }
        }
        return !invalid;
    }

    private final class CacheEntry {
        private long time;
        private Object entry;

        public CacheEntry(Object entry) {
            this.entry = entry;
            this.time = System.currentTimeMillis() / 1000L;
        }

        public Object getEntry() {
            return this.entry;
        }

        public long getTime() {
            return this.time;
        }
    }
}

