/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product.jmx;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.ControlPlugin;
import org.hyperic.hq.product.GenericPlugin;
import org.hyperic.hq.product.Metric;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.jmx.MBeanUtil;
import org.hyperic.hq.product.jmx.MxUtil;
import org.hyperic.util.config.ConfigResponse;

public class MxControlPlugin
extends ControlPlugin {
    private static final Log log = LogFactory.getLog(MxControlPlugin.class);
    private String _objectName;

    public String getObjectName() {
        return this._objectName;
    }

    public void setObjectName(String objectName) {
        this._objectName = objectName;
    }

    public void configure(ConfigResponse config) throws PluginException {
        super.configure(config);
        this.setObjectName(MxControlPlugin.configureObjectName(this));
    }

    static String configureObjectName(GenericPlugin plugin) throws PluginException {
        String objectName = plugin.getTypeProperty("OBJECT_NAME");
        if (objectName == null) {
            throw new PluginException("OBJECT_NAME not defined for " + plugin.getTypeInfo().getName());
        }
        objectName = MxUtil.expandObjectName(objectName, plugin.getConfig());
        return objectName;
    }

    protected boolean isRunning() {
        Integer avail;
        try {
            avail = (Integer)MxUtil.getValue(this.getConfig().toProperties(), this.getObjectName(), "Availability");
        }
        catch (Exception e) {
            return false;
        }
        return (double)avail.intValue() == 1.0;
    }

    public void doAction(String action, String[] args) throws PluginException {
        this.invokeMethod(action, args);
    }

    protected void invokeMethod(String action, String[] args) {
        String objectName = this.getTypeProperty("OBJECT_NAME." + action);
        if (objectName == null) {
            int ix = action.indexOf("::");
            if (ix != -1) {
                objectName = action.substring(0, ix);
                action = action.substring(ix + 2);
            } else {
                objectName = this.getObjectName();
            }
        } else {
            objectName = Metric.translate(objectName, this.getConfig());
        }
        MxControlPlugin.invokeMethod(this, objectName, action, args);
    }

    static void invokeMethod(ControlPlugin plugin, String objectName, String action, String[] args) {
        log.debug((Object)("invoking " + action + " " + MBeanUtil.anyToString(args)));
        try {
            String result = null;
            Object obj = MxUtil.invoke(plugin.getConfig().toProperties(), objectName, action, args, new String[0]);
            if (obj != null) {
                result = MBeanUtil.anyToString(obj);
            }
            log.debug((Object)(objectName + "." + action + "() returned: " + obj));
            plugin.setResult(0);
            if (result != null) {
                plugin.setMessage(result);
            }
        }
        catch (PluginException e) {
            log.error((Object)e.getMessage(), (Throwable)((Object)e));
            plugin.setMessage(e.getMessage());
            plugin.setResult(-1);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            plugin.setMessage(e.getMessage());
            plugin.setResult(-1);
        }
    }
}

