/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product.jmx;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.AutoServerDetector;
import org.hyperic.hq.product.DaemonDetector;
import org.hyperic.hq.product.Metric;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.ServerResource;
import org.hyperic.hq.product.ServerTypeInfo;
import org.hyperic.hq.product.ServiceResource;
import org.hyperic.hq.product.jmx.MxRuntimeException;
import org.hyperic.hq.product.jmx.MxServerQuery;
import org.hyperic.hq.product.jmx.MxServiceQuery;
import org.hyperic.hq.product.jmx.MxUtil;
import org.hyperic.hq.product.jmx.ServiceTypeFactory;
import org.hyperic.sigar.SigarException;
import org.hyperic.util.config.ConfigOption;
import org.hyperic.util.config.ConfigResponse;
import org.hyperic.util.config.ConfigSchema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MxServerDetector
extends DaemonDetector
implements AutoServerDetector {
    private static final String SUN_REMOTE_AUTHENTICATION_FALSE = "com.sun.management.jmxremote.authenticate=false";
    private static final String TEMPLATE_PROPERTY = "template";
    private static final String CONTROL_CLASS_PROPERTY = "control-class";
    private static final String MEASUREMENT_CLASS_PROPERTY = "measurement-class";
    private static final Log log = LogFactory.getLog(MxServerDetector.class);
    static final String PROP_SERVICE_NAME = "name";
    public static final String PROC_MAIN_CLASS = "PROC_MAIN_CLASS";
    public static final String PROC_HOME_PROPERTY = "PROC_HOME_PROPERTY";
    public static final String PROC_HOME_ENV = "PROC_HOME_ENV";
    public static final String PROP_PROCESS_QUERY = "process.query";
    protected static final String PROC_JAVA = "State.Name.sw=java";
    protected static final String SUN_JMX_REMOTE = "-Dcom.sun.management.jmxremote";
    protected static final String SUN_JMX_PORT = "-Dcom.sun.management.jmxremote.port=";
    private ServiceTypeFactory serviceTypeFactory = new ServiceTypeFactory();

    protected static String getMxURL(String port) {
        return "service:jmx:rmi:///jndi/rmi://localhost:" + port + "/jmxrmi";
    }

    protected String parseMxPort(String arg) {
        if (!arg.startsWith(SUN_JMX_PORT)) {
            return null;
        }
        return arg.substring(SUN_JMX_PORT.length());
    }

    protected boolean configureMxURL(ConfigResponse config, String arg) {
        String subString;
        String prop = "-Dcom.sun.management.jmxremote=";
        if (arg.startsWith("-Dcom.sun.management.jmxremote=") && (subString = arg.substring("-Dcom.sun.management.jmxremote=".length())).startsWith("ptql:")) {
            log.debug((Object)("Found jmx ptql query for local pid connection: " + subString));
            config.setValue("jmx.url", subString);
            return true;
        }
        String port = this.parseMxPort(arg);
        if (port != null) {
            String serviceUrl = MxServerDetector.getMxURL(port);
            log.debug((Object)("Found jmx port, creating service url:" + serviceUrl));
            config.setValue("jmx.url", serviceUrl);
            config.setValue("jmx.port", port);
            return true;
        }
        return false;
    }

    protected boolean findAndSetURL(ConfigResponse config, List<String> args, String processQuery) {
        boolean authenticationNotRequired = args.contains(SUN_REMOTE_AUTHENTICATION_FALSE);
        Iterator<String> i$ = args.iterator();
        if (i$.hasNext()) {
            String arg = i$.next();
            return this.configureMxURL(config, arg) || this.configureUserSpecifiedMxUrl(config, arg, authenticationNotRequired) || this.configureLocalMxURL(config, arg, processQuery);
        }
        return false;
    }

    private boolean configureUserSpecifiedMxUrl(ConfigResponse config, String arg, boolean authenticationNotRequired) {
        String mxUrl = config.getValue("jmx.url");
        boolean urlSet = false;
        if (mxUrl != null) {
            log.debug((Object)("Using jmx.url specified in the configuration: " + mxUrl));
            urlSet = true;
            config.setValue("jmx.url", mxUrl);
            if (!authenticationNotRequired) {
                String username = config.getValue("jmx.username");
                String password = config.getValue("jmx.password");
                if (username != null && password != null) {
                    log.debug((Object)"Found username and password for JMX auth.");
                    config.setValue("jmx.username", username);
                    config.setValue("jmx.password", password);
                } else {
                    log.debug((Object)"No username and/or password was specified for JMX connection.");
                }
            }
        }
        return urlSet;
    }

    protected boolean configureLocalMxURL(ConfigResponse config, String arg, String query) {
        String mxUrl = null;
        boolean urlSet = false;
        try {
            MxUtil.getUrlFromPid(query);
            mxUrl = "ptql:" + query;
            config.setValue("jmx.url", mxUrl);
            urlSet = true;
            log.debug((Object)("Using the local pid to create jmx url: " + mxUrl));
        }
        catch (Exception e) {
            log.debug((Object)("Cannot configure jmx.url using local pid: " + e.getMessage()), (Throwable)e);
        }
        return urlSet;
    }

    protected String getProcMainClass() {
        return this.getTypeProperty(PROC_MAIN_CLASS);
    }

    protected String getProcHomeProperty() {
        return this.getTypeProperty(PROC_HOME_PROPERTY);
    }

    protected String getProcHomeEnv() {
        return this.getTypeProperty(PROC_HOME_ENV);
    }

    private String getProcHomeEnv(long pid) {
        String key = this.getProcHomeEnv();
        if (key == null) {
            return null;
        }
        try {
            String val = MxServerDetector.getSigar().getProcEnv(pid, key);
            return val;
        }
        catch (SigarException e) {
            return null;
        }
    }

    protected String getProcQuery() {
        return this.getProcQuery(null);
    }

    private boolean isMatch(String val) {
        return val.indexOf(61) != -1;
    }

    protected String getProcQuery(String path) {
        String homeProp;
        StringBuffer query = new StringBuffer();
        String mainClass = this.getProcMainClass();
        query.append(PROC_JAVA);
        if (mainClass != null) {
            query.append(",Args.*.eq=" + mainClass);
        }
        if ((homeProp = this.getProcHomeProperty()) != null) {
            boolean isMatch = this.isMatch(homeProp);
            if (path == null) {
                query.append(",Args.*.");
                if (isMatch) {
                    query.append("re=-D" + homeProp);
                } else {
                    query.append("sw=-D" + homeProp + "=");
                }
            } else {
                int ix;
                if (isMatch && (ix = homeProp.indexOf(61)) != -1) {
                    homeProp = homeProp.substring(0, ix);
                }
                query.append(",Args.*.eq=-D" + homeProp + "=" + path);
            }
        }
        if (homeProp == null && mainClass == null) {
            String msg = "No PROC_MAIN_CLASS or PROC_HOME_PROPERTY defined";
            throw new IllegalStateException(msg);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("using ptql query=" + query));
        }
        return query.toString();
    }

    private boolean matches(String source, String regex) {
        return Pattern.compile(regex).matcher(source).find();
    }

    protected List getServerProcessList() {
        String homeProp;
        boolean isMatch;
        ArrayList<MxProcess> procs = new ArrayList<MxProcess>();
        String query = this.getProcQuery();
        long[] pids = MxServerDetector.getPids(query);
        if (log.isDebugEnabled()) {
            log.debug((Object)("ptql=" + query + " matched pids=" + Arrays.asList(new long[][]{pids})));
        }
        homeProp = (isMatch = this.isMatch(homeProp = this.getProcHomeProperty())) ? "-D" + homeProp : "-D" + homeProp + "=";
        for (int i = 0; i < pids.length; ++i) {
            long pid = pids[i];
            String[] args = MxServerDetector.getProcArgs(pid);
            String path = null;
            for (int j = 0; j < args.length; ++j) {
                String arg = args[j];
                if (isMatch) {
                    int ix;
                    if (!this.matches(arg, homeProp) || (ix = arg.indexOf(61)) == -1) continue;
                    path = arg.substring(ix + 1);
                    break;
                }
                if (!arg.startsWith(homeProp)) continue;
                path = arg.substring(homeProp.length());
                break;
            }
            if (path == null) {
                path = this.getProcHomeEnv(pid);
            }
            if (path == null) {
                path = MxServerDetector.getProcCwd(pid);
            }
            if (path == null) continue;
            MxProcess process = new MxProcess(pid, args, path);
            procs.add(process);
        }
        return procs;
    }

    protected boolean isInstallTypeVersion(MxProcess process) {
        String dir = process.getInstallPath();
        return this.isInstallTypeVersion(dir);
    }

    protected void setProductConfig(ServerResource server, ConfigResponse config, long pid) {
        super.setProductConfig(server, config);
    }

    protected ServerResource getServerResource(MxProcess process) {
        ConfigOption option;
        String dir = process.getInstallPath();
        String query = this.getProcQuery(dir);
        ServerResource server = this.newServerResource(dir);
        this.adjustClassPath(dir);
        ConfigResponse config = new ConfigResponse();
        ConfigSchema schema = this.getConfigSchema(this.getTypeInfo().getName(), 0);
        if (schema != null && (option = schema.getOption(PROP_PROCESS_QUERY)) != null) {
            config.setValue(option.getName(), query);
        }
        try {
            this.setJmxUrl(process, config);
        }
        catch (MxRuntimeException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)e.getMessage(), (Throwable)((Object)e));
            }
            log.info((Object)e.getMessage());
        }
        this.setProductConfig(server, config, process.getPid());
        this.discoverServerConfig(server, process.getPid());
        server.setMeasurementConfig();
        return server;
    }

    protected void setJmxUrl(MxProcess process, ConfigResponse config) {
        boolean urlSet = false;
        String processQuery = this.getProcQuery(process.getInstallPath());
        if (process.getURL() != null) {
            log.debug((Object)("Found jmx.url in the process args: " + process.getURL()));
            config.setValue("jmx.url", process.getURL());
            urlSet = true;
        } else {
            List<String> args = Arrays.asList(process.getArgs());
            urlSet = this.findAndSetURL(config, args, processQuery);
        }
        if (!urlSet) {
            throw new MxRuntimeException("Unable to find the jmx.url in configuration properties: " + config);
        }
    }

    @Override
    public List getServerResources(ConfigResponse platformConfig) throws PluginException {
        this.setPlatformConfig(platformConfig);
        ArrayList<ServerResource> servers = new ArrayList<ServerResource>();
        List procs = this.getServerProcessList();
        for (int i = 0; i < procs.size(); ++i) {
            MxProcess process = (MxProcess)procs.get(i);
            if (!this.isInstallTypeVersion(process)) continue;
            servers.add(this.getServerResource(process));
        }
        return servers;
    }

    protected List discoverMxServices(MBeanServerConnection mServer, ConfigResponse serverConfig) throws PluginException {
        String url = serverConfig.getValue("jmx.url");
        log.debug((Object)("[discoverMxServices] url=" + url));
        this.configure(serverConfig);
        MxServerQuery serverQuery = new MxServerQuery(this);
        String objName = this.getTypeProperty("OBJECT_NAME");
        log.debug((Object)("[discoverMxServices] objName=" + objName));
        if (objName != null) {
            try {
                objName = Metric.translate(objName, serverConfig);
                log.debug((Object)("[discoverMxServices] objName=" + objName));
                serverQuery.setObjectName(new ObjectName(objName));
            }
            catch (MalformedObjectNameException e) {
                throw new PluginException(objName, e);
            }
        }
        serverQuery.setURL(url);
        serverQuery.getAttributes(mServer);
        serverQuery.findServices(mServer);
        List queries = serverQuery.getServiceQueries();
        this.getLog().debug((Object)("discovered " + queries.size() + " services"));
        ArrayList<ServiceResource> services = new ArrayList<ServiceResource>();
        for (int i = 0; i < queries.size(); ++i) {
            MxServiceQuery query = (MxServiceQuery)queries.get(i);
            ServiceResource service = new ServiceResource();
            ConfigResponse config = new ConfigResponse((Map)query.getResourceConfig());
            ConfigResponse cprops = new ConfigResponse((Map)query.getCustomProperties());
            service.setType(query.getResourceType());
            String name = this.formatAutoInventoryName(service.getType(), serverConfig, config, cprops);
            if (name == null) {
                name = "%serverName% ";
                String queryName = query.getName();
                if (queryName != null && queryName.length() != 0) {
                    name = name + query.getName() + " ";
                }
                name = name + query.getServiceResourceType();
            }
            service.setName(name);
            if (query.hasControl()) {
                ConfigResponse controlConfig = new ConfigResponse((Map)query.getControlConfig());
                service.setControlConfig(controlConfig);
            }
            service.setProductConfig(config);
            service.setMeasurementConfig();
            service.setCustomProperties(cprops);
            services.add(service);
        }
        this.setCustomProperties(new ConfigResponse((Map)serverQuery.getCustomProperties()));
        return services;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List discoverServices(ConfigResponse serverConfig) throws PluginException {
        MBeanServerConnection mServer;
        log.debug((Object)("[discoverServices] serverConfig=" + serverConfig));
        JMXConnector connector = null;
        try {
            connector = MxUtil.getCachedMBeanConnector(serverConfig.toProperties());
            mServer = connector.getMBeanServerConnection();
        }
        catch (Exception e) {
            MxUtil.close(connector);
            throw new PluginException(e.getMessage(), e);
        }
        try {
            List list = this.discoverMxServices(mServer, serverConfig);
            return list;
        }
        finally {
            MxUtil.close(connector);
        }
    }

    @Override
    public Set discoverServiceTypes(ConfigResponse serverConfig) throws PluginException {
        MBeanServerConnection mServer;
        JMXConnector connector = null;
        Set serviceTypes = new HashSet();
        if (this.getProductPlugin().getPluginData().getProperty(MEASUREMENT_CLASS_PROPERTY) == null || this.getProductPlugin().getPluginData().getProperty(CONTROL_CLASS_PROPERTY) == null || this.getProductPlugin().getPluginData().getProperty(TEMPLATE_PROPERTY) == null) {
            return serviceTypes;
        }
        try {
            connector = MxUtil.getCachedMBeanConnector(serverConfig.toProperties());
            mServer = connector.getMBeanServerConnection();
        }
        catch (Exception e) {
            MxUtil.close(connector);
            throw new PluginException(e.getMessage(), e);
        }
        try {
            Set<ObjectName> objectNames = mServer.queryNames(new ObjectName("spring.application:*"), null);
            serviceTypes = this.serviceTypeFactory.create(this.getProductPlugin(), (ServerTypeInfo)this.getTypeInfo(), mServer, objectNames);
        }
        catch (Exception e) {
            throw new PluginException(e.getMessage(), e);
        }
        finally {
            MxUtil.close(connector);
        }
        return serviceTypes;
    }

    public static class MxProcess {
        long _pid;
        String _installpath;
        String[] _args;
        String _url;

        public MxProcess(long pid, String[] args, String installpath) {
            this._pid = pid;
            this._args = args;
            this._installpath = installpath;
        }

        public long getPid() {
            return this._pid;
        }

        public String getInstallPath() {
            return this._installpath;
        }

        public String[] getArgs() {
            return this._args;
        }

        public String getURL() {
            return this._url;
        }

        public void setURL(String url) {
            this._url = url;
        }
    }
}

