/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.springsource.hyperic.plugin.gemfire;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.PluginException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GemFireUtils {
    static Log log = LogFactory.getLog(GemFireUtils.class);
    private static final Map<String, String> membersIDCache = new HashMap<String, String>();

    public static List<String> getMembers(MBeanServerConnection mServer) throws PluginException {
        String[] members;
        Object[] args = new Object[]{};
        String[] def = new String[]{};
        try {
            members = (String[])mServer.invoke(new ObjectName("GemFire:type=MemberInfoWithStatsMBean"), "getMembers", args, def);
        }
        catch (Exception ex) {
            throw new PluginException(ex.getMessage(), (Throwable)ex);
        }
        return Arrays.asList(members);
    }

    public static Map<String, Object> getMemberDetails(String memberID, MBeanServerConnection mServer) throws PluginException {
        Map memberDetails = null;
        try {
            Object[] args2 = new Object[]{memberID};
            String[] def2 = new String[]{String.class.getName()};
            memberDetails = (Map)mServer.invoke(new ObjectName("GemFire:type=MemberInfoWithStatsMBean"), "getMemberDetails", args2, def2);
        }
        catch (Exception ex) {
            throw new PluginException(ex.getMessage(), (Throwable)ex);
        }
        if (memberDetails == null || memberDetails.isEmpty()) {
            String msg = "Member '" + memberID + "' not found!!!";
            if (log.isDebugEnabled()) {
                log.debug((Object)("[getMemberDetails] " + msg));
            }
            throw new PluginException(msg);
        }
        return memberDetails;
    }

    public static void clearNameCache() {
        membersIDCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String memberNameToMemberID(String memberName, MBeanServerConnection mServer) throws PluginException {
        String memberID;
        if (membersIDCache.isEmpty()) {
            Map<String, String> map = membersIDCache;
            synchronized (map) {
                membersIDCache.clear();
                List<String> members = GemFireUtils.getMembers(mServer);
                for (String member : members) {
                    Map<String, Object> memberDetails = GemFireUtils.getMemberDetails(member, mServer);
                    membersIDCache.put((String)memberDetails.get("gemfire.member.name.string"), member);
                }
            }
            log.debug((Object)("[memberNameToMemberID] membersIDCache.size() => " + membersIDCache.size()));
        }
        if ((memberID = membersIDCache.get(memberName)) == null) {
            String msg = "Member named '" + memberName + "' not found!!!";
            if (log.isDebugEnabled()) {
                log.debug((Object)("[memberNameToMemberID] " + msg));
            }
            throw new PluginException(msg);
        }
        log.debug((Object)("[memberNameToMemberID] " + memberName + "=" + memberID));
        return memberID;
    }
}

