/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.mssql;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.plugin.mssql.ClusterDetect;
import org.hyperic.hq.product.AutoServerDetector;
import org.hyperic.hq.product.GenericPlugin;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.ServerDetector;
import org.hyperic.hq.product.ServerResource;
import org.hyperic.hq.product.ServiceResource;
import org.hyperic.sigar.win32.Pdh;
import org.hyperic.sigar.win32.RegistryKey;
import org.hyperic.sigar.win32.Service;
import org.hyperic.sigar.win32.ServiceConfig;
import org.hyperic.sigar.win32.Win32Exception;
import org.hyperic.util.config.ConfigResponse;

public class MsSQLDetector
extends ServerDetector
implements AutoServerDetector {
    static final String PROP_DB = "db.name";
    private static final String DB_NAME = "Database";
    static final String DEFAULT_SQLSERVER_SERVICE_NAME = "MSSQLSERVER";
    static final String DEFAULT_SQLAGENT_SERVICE_NAME = "SQLSERVERAGENT";
    static final String MS_CLUSTER_DISCOVERY = "MS_CLUSTER_DISCOVERY";
    private static final Log log = LogFactory.getLog(MsSQLDetector.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getServerResources(ConfigResponse platformConfig) throws PluginException {
        List cfgs;
        try {
            cfgs = Service.getServiceConfigs((String)"sqlservr.exe");
        }
        catch (Win32Exception e) {
            log.debug((Object)("[getServerResources] Error: " + e.getMessage()), (Throwable)e);
            return null;
        }
        log.debug((Object)("[getServerResources] MSSQL Server found:'" + cfgs.size() + "'"));
        if (cfgs.size() == 0) {
            return null;
        }
        ArrayList<ServerResource> servers = new ArrayList<ServerResource>();
        for (int i = 0; i < cfgs.size(); ++i) {
            ServiceConfig serviceConfig = (ServiceConfig)cfgs.get(i);
            String name = serviceConfig.getName();
            Service mssqlService = null;
            boolean serverIsRunning = false;
            try {
                mssqlService = new Service(name);
                if (mssqlService.getStatus() != 4) {
                    log.debug((Object)("[getServerResources] service '" + name + "' is not RUNNING (status='" + mssqlService.getStatusString() + "')"));
                } else {
                    serverIsRunning = true;
                }
            }
            catch (Win32Exception e) {
                log.debug((Object)("[getServerResources] Error getting '" + name + "' service information " + (Object)((Object)e)), (Throwable)e);
            }
            finally {
                if (mssqlService != null) {
                    mssqlService.close();
                }
            }
            if (!serverIsRunning) continue;
            String instance = MsSQLDetector.instaceName(name);
            File dir = new File(serviceConfig.getExe()).getParentFile();
            boolean correctVersion = false;
            String regKey = this.getTypeProperty("regKey");
            if (regKey != null) {
                try {
                    regKey = regKey.replace("%NAME%", instance);
                    log.debug((Object)("[getServerResources] regKey:'" + regKey + "'"));
                    RegistryKey key = RegistryKey.LocalMachine.openSubKey(regKey);
                    String version = key.getStringValue("CurrentVersion");
                    String expectedVersion = this.getTypeProperty("version");
                    correctVersion = Pattern.compile(expectedVersion).matcher(version).find();
                    log.debug((Object)("[getServerResources] server:'" + instance + "' version:'" + version + "' expectedVersion:'" + expectedVersion + "' correctVersion:'" + correctVersion + "'"));
                }
                catch (Win32Exception ex) {
                    log.debug((Object)("[getServerResources] Error accesing to windows registry to get '" + instance + "' version. " + ex.getMessage()));
                }
            } else {
                correctVersion = this.checkVersionOldStyle(dir);
            }
            if (!correctVersion) continue;
            dir = dir.getParentFile();
            ServerResource server = this.createServerResource(dir.getAbsolutePath(), name);
            servers.add(server);
        }
        return servers;
    }

    private boolean checkVersionOldStyle(File dir) {
        String versionFile = this.getTypeProperty("mssql.version.file");
        File dll = new File(dir, versionFile);
        boolean correctVersion = dll.exists();
        this.getLog().debug((Object)("[checkVersionOldStyle] dll:'" + dll + "' correctVersion='" + correctVersion + "'"));
        return correctVersion;
    }

    private ServerResource createServerResource(String installpath, String name) {
        Properties mssqlClusterPropes;
        ServerResource server = this.createServerResource(installpath);
        String instance = MsSQLDetector.instaceName(name);
        server.setName(server.getName() + " " + instance);
        ConfigResponse cfg = new ConfigResponse();
        cfg.setValue("service_name", name);
        String discoverMsCluster = this.getTypeProperty(MS_CLUSTER_DISCOVERY);
        if (discoverMsCluster != null && (mssqlClusterPropes = ClusterDetect.getMssqlClusterProps(instance)) != null) {
            cfg.setValue("mssql-cluster-name", mssqlClusterPropes.getProperty("cluster name"));
            cfg.setValue("virtual-platform-name", mssqlClusterPropes.getProperty("network name"));
            cfg.setValue("cluster-nodes", mssqlClusterPropes.getProperty("nodes"));
            cfg.setValue("instance-name", instance);
            cfg.setValue("original-platform-name", MsSQLDetector.getPlatformName());
        }
        server.setProductConfig(cfg);
        server.setMeasurementConfig();
        server.setControlConfig();
        return server;
    }

    private static String instaceName(String name) {
        String instance = name;
        if (name.startsWith("MSSQL$")) {
            instance = name.substring(6);
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getServiceStatus(String name) {
        Service svc = null;
        try {
            svc = new Service(name);
            log.debug((Object)("[getServiceStatus] name='" + name + "' status='" + svc.getStatusString() + "'"));
            int n = svc.getStatus();
            return n;
        }
        catch (Win32Exception e) {
            log.debug((Object)("[getServiceStatus] name='" + name + "' " + (Object)((Object)e)));
            int n = 1;
            return n;
        }
        finally {
            if (svc != null) {
                svc.close();
            }
        }
    }

    protected List discoverServices(ConfigResponse serverConfig) throws PluginException {
        ArrayList<ServiceResource> services = new ArrayList<ServiceResource>();
        String sqlServerServiceName = serverConfig.getValue("service_name", DEFAULT_SQLSERVER_SERVICE_NAME);
        ArrayList<ServiceInfo> servicesNames = new ArrayList<ServiceInfo>();
        String sqlServerMetricPrefix = "SQLServer";
        String msrsPrefix = "MSRS 2011 Windows Service";
        String instaceName = DEFAULT_SQLSERVER_SERVICE_NAME;
        if (this.getTypeInfo().getVersion().equals("2008")) {
            msrsPrefix = "MSRS 2008 Windows Service";
        } else if (this.getTypeInfo().getVersion().equals("2008 R2")) {
            msrsPrefix = "MSRS 2008 R2 Windows Service";
        } else if (this.getTypeInfo().getVersion().equals("2005")) {
            msrsPrefix = "MSRS 2005 Windows Service";
        }
        if (sqlServerServiceName.equals(DEFAULT_SQLSERVER_SERVICE_NAME)) {
            String rpPrefix = "ReportServer";
            String olapPrefix = "MSAS11";
            if (this.getTypeInfo().getVersion().startsWith("2008")) {
                olapPrefix = "MSAS 2008";
            } else if (this.getTypeInfo().getVersion().equals("2005")) {
                olapPrefix = "MSAS 2005";
            }
            servicesNames.add(new ServiceInfo(DEFAULT_SQLAGENT_SERVICE_NAME, "SQLAgent", "SQLAgent", "SQLAgent"));
            servicesNames.add(new ServiceInfo("ReportServer", "Report Server", rpPrefix, "Report Server"));
            servicesNames.add(new ServiceInfo("MSSQLServerOLAPService", "Analysis Services", olapPrefix, "Analysis Services"));
        } else {
            instaceName = sqlServerServiceName.substring(sqlServerServiceName.indexOf("$") + 1);
            sqlServerMetricPrefix = sqlServerServiceName;
            servicesNames.add(new ServiceInfo("SQLAgent$" + instaceName, "SQLAgent", "SQLAgent$" + instaceName, "SQLAgent"));
            servicesNames.add(new ServiceInfo("ReportServer$" + instaceName, "Report Server", "ReportServer$" + instaceName, "Report Server"));
            servicesNames.add(new ServiceInfo("MSOLAP$" + instaceName, "Analysis Services", "MSOLAP$" + instaceName, "Analysis Services"));
        }
        for (int i = 0; i < servicesNames.size(); ++i) {
            ServiceInfo s = (ServiceInfo)servicesNames.get(i);
            if (MsSQLDetector.getServiceStatus(s.winServiceName) == 4) {
                log.debug((Object)("[discoverServices] service='" + s.winServiceName + "' runnig"));
                ServiceResource agentService = new ServiceResource();
                agentService.setType((GenericPlugin)this, s.type);
                agentService.setServiceName(s.serviceName);
                ConfigResponse cfg = new ConfigResponse();
                cfg.setValue("service_name", s.winServiceName);
                cfg.setValue("pref_prefix", s.metricsPrefix);
                if (s.type.equals("Report Server")) {
                    cfg.setValue("MSRS", msrsPrefix);
                    cfg.setValue("instance", instaceName);
                }
                agentService.setProductConfig(cfg);
                agentService.setMeasurementConfig();
                agentService.setControlConfig();
                services.add(agentService);
                continue;
            }
            log.debug((Object)("[discoverServices] service='" + s.winServiceName + "' NOT runnig"));
        }
        try {
            String obj = sqlServerMetricPrefix + ":Databases";
            log.debug((Object)("[discoverServices] obj='" + obj + "'"));
            String[] instances = Pdh.getInstances((String)obj);
            log.debug((Object)("[discoverServices] instances=" + Arrays.asList(instances)));
            for (int i = 0; i < instances.length; ++i) {
                String dbName = instances[i];
                if (dbName.equals("_Total")) continue;
                ServiceResource service = new ServiceResource();
                service.setType((GenericPlugin)this, DB_NAME);
                service.setServiceName(dbName);
                ConfigResponse cfg = new ConfigResponse();
                cfg.setValue(PROP_DB, dbName);
                cfg.setValue("instance", instaceName);
                service.setProductConfig(cfg);
                service.setMeasurementConfig();
                services.add(service);
            }
        }
        catch (Win32Exception e) {
            log.debug((Object)("[discoverServices] Error getting Databases pdh data for '" + sqlServerServiceName + "': " + e.getMessage()), (Throwable)e);
        }
        return services;
    }

    private class ServiceInfo {
        String winServiceName;
        String type;
        String metricsPrefix;
        String serviceName;

        public ServiceInfo(String winServiceName, String type, String metricsPrefix, String serviceName) {
            this.winServiceName = winServiceName;
            this.type = type;
            this.metricsPrefix = metricsPrefix;
            this.serviceName = serviceName;
        }
    }
}

