/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.netdevice;

import java.util.List;
import org.hyperic.hq.plugin.netdevice.NetworkDeviceDetector;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.ServiceResource;
import org.hyperic.util.config.ConfigResponse;

public class NetworkHostDetector
extends NetworkDeviceDetector {
    private static final String STORAGE_NAME = "Storage";
    private static final String PROP_STORAGE = "Storage".toLowerCase();
    private static final String STORAGE_COLUMN = "hrStorageDescr";

    public List discoverServices(ConfigResponse serverConfig) throws PluginException {
        List services = super.discoverServices(serverConfig);
        this.openSession(serverConfig);
        List storageDesc = this.getColumn(STORAGE_COLUMN);
        for (int i = 0; i < storageDesc.size(); ++i) {
            ConfigResponse config = new ConfigResponse();
            String name = storageDesc.get(i).toString().trim();
            ServiceResource service = this.createServiceResource(STORAGE_NAME);
            config.setValue(PROP_STORAGE, name);
            service.setProductConfig(config);
            service.setMeasurementConfig();
            service.setServiceName(name + " " + STORAGE_NAME);
            services.add(service);
        }
        this.closeSession();
        return services;
    }
}

