/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.netdevice;

import java.io.IOException;
import org.hyperic.hq.plugin.netdevice.SNMPTrapReceiver;
import org.hyperic.hq.product.LogTrackPlugin;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.PluginManager;
import org.hyperic.util.config.ConfigResponse;

public class SNMPTrapReceiverPlugin
extends LogTrackPlugin {
    private SNMPTrapReceiver getReceiver() throws IOException {
        SNMPTrapReceiver receiver = SNMPTrapReceiver.getInstance(this.getManager().getProperties());
        receiver.setPluginManager(this.getManager());
        return receiver;
    }

    public void init(PluginManager manager) throws PluginException {
        super.init(manager);
        if (SNMPTrapReceiver.hasInstance()) {
            return;
        }
        String listen = manager.getProperty("snmpTrapReceiver.listenAddress");
        if (listen == null) {
            return;
        }
        this.getLog().debug((Object)("Configuring default listener: " + listen));
        try {
            this.getReceiver();
        }
        catch (Exception e) {
            throw new PluginException(e.getMessage(), (Throwable)e);
        }
    }

    public void configure(ConfigResponse config) throws PluginException {
        super.configure(config);
        try {
            this.getReceiver().add(this);
        }
        catch (IOException e) {
            throw new PluginException(e.getMessage(), (Throwable)e);
        }
    }

    public void shutdown() throws PluginException {
        super.shutdown();
        SNMPTrapReceiver.remove(this);
    }
}

