/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.livedata.agent.server;

import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.agent.AgentAPIInfo;
import org.hyperic.hq.agent.AgentRemoteException;
import org.hyperic.hq.agent.AgentRemoteValue;
import org.hyperic.hq.agent.server.AgentDaemon;
import org.hyperic.hq.agent.server.AgentServerHandler;
import org.hyperic.hq.agent.server.AgentStartException;
import org.hyperic.hq.agent.server.AgentTransportLifecycle;
import org.hyperic.hq.livedata.agent.LiveDataCommandsAPI;
import org.hyperic.hq.livedata.agent.client.LiveDataCommandsClient;
import org.hyperic.hq.livedata.agent.commands.LiveData_args;
import org.hyperic.hq.livedata.agent.server.LiveDataCommandsService;
import org.hyperic.hq.product.LiveDataPluginManager;

public class LiveDataCommandsServer
implements AgentServerHandler {
    private Log _log = LogFactory.getLog(LiveDataCommandsServer.class);
    private LiveDataPluginManager _manager;
    private LiveDataCommandsAPI _commands = new LiveDataCommandsAPI();
    private LiveDataCommandsService _liveDataCommandsService;

    public String[] getCommandSet() {
        return LiveDataCommandsAPI.commandSet;
    }

    public AgentAPIInfo getAPIInfo() {
        return this._commands;
    }

    public AgentRemoteValue dispatchCommand(String cmd, AgentRemoteValue args, InputStream inStream, OutputStream outStream) throws AgentRemoteException {
        if (cmd.equals("hyperic.livedata.getData")) {
            LiveData_args res = new LiveData_args(args);
            return this._liveDataCommandsService.getData(res);
        }
        throw new AgentRemoteException("Unexpected command: " + cmd);
    }

    public void startup(AgentDaemon agent) throws AgentStartException {
        AgentTransportLifecycle agentTransportLifecycle;
        try {
            this._manager = (LiveDataPluginManager)agent.getPluginManager("livedata");
        }
        catch (Exception e) {
            throw new AgentStartException("Unable to load live data manager", e);
        }
        this._liveDataCommandsService = new LiveDataCommandsService(this._manager);
        try {
            agentTransportLifecycle = agent.getAgentTransportLifecycle();
        }
        catch (Exception e) {
            throw new AgentStartException("Unable to get agent transport lifecycle: " + e.getMessage());
        }
        this._log.info((Object)"Registering Live Data Commands Service with Agent Transport");
        try {
            agentTransportLifecycle.registerService(LiveDataCommandsClient.class, (Object)this._liveDataCommandsService);
        }
        catch (Exception e) {
            throw new AgentStartException("Failed to register Live Data Commands Service.", e);
        }
        this._log.info((Object)"Live Data Commands Server started up");
    }

    public final void postInitActions() throws AgentStartException {
    }

    public void shutdown() {
    }
}

