/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.api.message;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.ws.addressing.WsaTubeHelper;
import com.sun.xml.internal.ws.api.SOAPVersion;
import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.addressing.AddressingVersion;
import com.sun.xml.internal.ws.api.addressing.OneWayFeature;
import com.sun.xml.internal.ws.api.addressing.WSEndpointReference;
import com.sun.xml.internal.ws.api.message.Header;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLBoundOperation;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.internal.ws.message.RelatesToHeader;
import com.sun.xml.internal.ws.message.StringHeader;
import com.sun.xml.internal.ws.resources.AddressingMessages;
import com.sun.xml.internal.ws.resources.ClientMessages;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.ws.WebServiceException;

public final class HeaderList
extends ArrayList<Header> {
    private static final long serialVersionUID = -6358045781349627237L;
    private int understoodBits;
    private BitSet moreUnderstoodBits = null;
    private String to = null;
    private String action = null;
    private WSEndpointReference replyTo = null;
    private WSEndpointReference faultTo = null;
    private String messageId;
    private String relatesTo;

    public HeaderList() {
    }

    public HeaderList(HeaderList headerList) {
        super(headerList);
        this.understoodBits = headerList.understoodBits;
        if (headerList.moreUnderstoodBits != null) {
            this.moreUnderstoodBits = (BitSet)headerList.moreUnderstoodBits.clone();
        }
        this.to = headerList.to;
        this.action = headerList.action;
        this.replyTo = headerList.replyTo;
        this.faultTo = headerList.faultTo;
        this.messageId = headerList.messageId;
    }

    @Override
    public int size() {
        return super.size();
    }

    public void addAll(Header ... headerArray) {
        for (Header header : headerArray) {
            this.add(header);
        }
    }

    @Override
    public Header get(int n) {
        return (Header)super.get(n);
    }

    public void understood(int n) {
        if (n >= this.size()) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        if (n < 32) {
            this.understoodBits |= 1 << n;
        } else {
            if (this.moreUnderstoodBits == null) {
                this.moreUnderstoodBits = new BitSet();
            }
            this.moreUnderstoodBits.set(n - 32);
        }
    }

    public boolean isUnderstood(int n) {
        if (n >= this.size()) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        if (n < 32) {
            return this.understoodBits == (this.understoodBits | 1 << n);
        }
        if (this.moreUnderstoodBits == null) {
            return false;
        }
        return this.moreUnderstoodBits.get(n - 32);
    }

    public void understood(@NotNull Header header) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (this.get(i) != header) continue;
            this.understood(i);
            return;
        }
        throw new IllegalArgumentException();
    }

    @Nullable
    public Header get(@NotNull String string, @NotNull String string2, boolean bl) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            Header header = this.get(i);
            if (!header.getLocalPart().equals(string2) || !header.getNamespaceURI().equals(string)) continue;
            if (bl) {
                this.understood(i);
            }
            return header;
        }
        return null;
    }

    public Header get(String string, String string2) {
        return this.get(string, string2, true);
    }

    @Nullable
    public Header get(@NotNull QName qName, boolean bl) {
        return this.get(qName.getNamespaceURI(), qName.getLocalPart(), bl);
    }

    @Nullable
    public Header get(@NotNull QName qName) {
        return this.get(qName, true);
    }

    public Iterator<Header> getHeaders(String string, String string2) {
        return this.getHeaders(string, string2, true);
    }

    @NotNull
    public Iterator<Header> getHeaders(final @NotNull String string, final @NotNull String string2, final boolean bl) {
        return new Iterator<Header>(){
            int idx = 0;
            Header next;

            @Override
            public boolean hasNext() {
                if (this.next == null) {
                    this.fetch();
                }
                return this.next != null;
            }

            @Override
            public Header next() {
                if (this.next == null) {
                    this.fetch();
                    if (this.next == null) {
                        throw new NoSuchElementException();
                    }
                }
                if (bl) {
                    assert (HeaderList.this.get(this.idx - 1) == this.next);
                    HeaderList.this.understood(this.idx - 1);
                }
                Header header = this.next;
                this.next = null;
                return header;
            }

            private void fetch() {
                while (this.idx < HeaderList.this.size()) {
                    Header header;
                    if (!(header = HeaderList.this.get(this.idx++)).getLocalPart().equals(string2) || !header.getNamespaceURI().equals(string)) continue;
                    this.next = header;
                    break;
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @NotNull
    public Iterator<Header> getHeaders(@NotNull QName qName, boolean bl) {
        return this.getHeaders(qName.getNamespaceURI(), qName.getLocalPart(), bl);
    }

    @NotNull
    public Iterator<Header> getHeaders(@NotNull String string) {
        return this.getHeaders(string, true);
    }

    @NotNull
    public Iterator<Header> getHeaders(final @NotNull String string, final boolean bl) {
        return new Iterator<Header>(){
            int idx = 0;
            Header next;

            @Override
            public boolean hasNext() {
                if (this.next == null) {
                    this.fetch();
                }
                return this.next != null;
            }

            @Override
            public Header next() {
                if (this.next == null) {
                    this.fetch();
                    if (this.next == null) {
                        throw new NoSuchElementException();
                    }
                }
                if (bl) {
                    assert (HeaderList.this.get(this.idx - 1) == this.next);
                    HeaderList.this.understood(this.idx - 1);
                }
                Header header = this.next;
                this.next = null;
                return header;
            }

            private void fetch() {
                while (this.idx < HeaderList.this.size()) {
                    Header header;
                    if (!(header = HeaderList.this.get(this.idx++)).getNamespaceURI().equals(string)) continue;
                    this.next = header;
                    break;
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private Header getFirstHeader(QName qName, boolean bl, SOAPVersion sOAPVersion) {
        if (sOAPVersion == null) {
            throw new IllegalArgumentException(AddressingMessages.NULL_SOAP_VERSION());
        }
        Iterator<Header> iterator = this.getHeaders(qName.getNamespaceURI(), qName.getLocalPart(), bl);
        while (iterator.hasNext()) {
            Header header = iterator.next();
            if (!header.getRole(sOAPVersion).equals(sOAPVersion.implicitRole)) continue;
            return header;
        }
        return null;
    }

    public String getTo(AddressingVersion addressingVersion, SOAPVersion sOAPVersion) {
        if (this.to != null) {
            return this.to;
        }
        if (addressingVersion == null) {
            throw new IllegalArgumentException(AddressingMessages.NULL_ADDRESSING_VERSION());
        }
        Header header = this.getFirstHeader(addressingVersion.toTag, true, sOAPVersion);
        this.to = header != null ? header.getStringContent() : addressingVersion.anonymousUri;
        return this.to;
    }

    public String getAction(@NotNull AddressingVersion addressingVersion, @NotNull SOAPVersion sOAPVersion) {
        if (this.action != null) {
            return this.action;
        }
        if (addressingVersion == null) {
            throw new IllegalArgumentException(AddressingMessages.NULL_ADDRESSING_VERSION());
        }
        Header header = this.getFirstHeader(addressingVersion.actionTag, true, sOAPVersion);
        if (header != null) {
            this.action = header.getStringContent();
        }
        return this.action;
    }

    public WSEndpointReference getReplyTo(@NotNull AddressingVersion addressingVersion, @NotNull SOAPVersion sOAPVersion) {
        if (this.replyTo != null) {
            return this.replyTo;
        }
        if (addressingVersion == null) {
            throw new IllegalArgumentException(AddressingMessages.NULL_ADDRESSING_VERSION());
        }
        Header header = this.getFirstHeader(addressingVersion.replyToTag, true, sOAPVersion);
        if (header != null) {
            try {
                this.replyTo = header.readAsEPR(addressingVersion);
            }
            catch (XMLStreamException xMLStreamException) {
                throw new WebServiceException(AddressingMessages.REPLY_TO_CANNOT_PARSE(), xMLStreamException);
            }
        } else {
            this.replyTo = addressingVersion.anonymousEpr;
        }
        return this.replyTo;
    }

    public WSEndpointReference getFaultTo(@NotNull AddressingVersion addressingVersion, @NotNull SOAPVersion sOAPVersion) {
        if (this.faultTo != null) {
            return this.faultTo;
        }
        if (addressingVersion == null) {
            throw new IllegalArgumentException(AddressingMessages.NULL_ADDRESSING_VERSION());
        }
        Header header = this.getFirstHeader(addressingVersion.faultToTag, true, sOAPVersion);
        if (header != null) {
            try {
                this.faultTo = header.readAsEPR(addressingVersion);
            }
            catch (XMLStreamException xMLStreamException) {
                throw new WebServiceException(AddressingMessages.FAULT_TO_CANNOT_PARSE(), xMLStreamException);
            }
        }
        return this.faultTo;
    }

    public String getMessageID(@NotNull AddressingVersion addressingVersion, @NotNull SOAPVersion sOAPVersion) {
        if (this.messageId != null) {
            return this.messageId;
        }
        if (addressingVersion == null) {
            throw new IllegalArgumentException(AddressingMessages.NULL_ADDRESSING_VERSION());
        }
        Header header = this.getFirstHeader(addressingVersion.messageIDTag, true, sOAPVersion);
        if (header != null) {
            this.messageId = header.getStringContent();
        }
        return this.messageId;
    }

    public String getRelatesTo(@NotNull AddressingVersion addressingVersion, @NotNull SOAPVersion sOAPVersion) {
        if (this.relatesTo != null) {
            return this.relatesTo;
        }
        if (addressingVersion == null) {
            throw new IllegalArgumentException(AddressingMessages.NULL_ADDRESSING_VERSION());
        }
        Header header = this.getFirstHeader(addressingVersion.relatesToTag, true, sOAPVersion);
        if (header != null) {
            this.relatesTo = header.getStringContent();
        }
        return this.relatesTo;
    }

    public void fillRequestAddressingHeaders(Packet packet, AddressingVersion addressingVersion, SOAPVersion sOAPVersion, boolean bl, String string, boolean bl2) {
        this.fillCommonAddressingHeaders(packet, addressingVersion, sOAPVersion, string, bl2);
        if (!bl) {
            WSEndpointReference wSEndpointReference = addressingVersion.anonymousEpr;
            this.add(wSEndpointReference.createHeader(addressingVersion.replyToTag));
            StringHeader stringHeader = new StringHeader(addressingVersion.messageIDTag, packet.getMessage().getID(addressingVersion, sOAPVersion));
            this.add(stringHeader);
        }
    }

    public void fillRequestAddressingHeaders(Packet packet, AddressingVersion addressingVersion, SOAPVersion sOAPVersion, boolean bl, String string) {
        this.fillRequestAddressingHeaders(packet, addressingVersion, sOAPVersion, bl, string, false);
    }

    public void fillRequestAddressingHeaders(WSDLPort wSDLPort, @NotNull WSBinding wSBinding, Packet packet) {
        WSDLBoundOperation wSDLBoundOperation;
        boolean bl;
        if (wSBinding == null) {
            throw new IllegalArgumentException(AddressingMessages.NULL_BINDING());
        }
        HeaderList headerList = packet.getMessage().getHeaders();
        String string = headerList.getAction(wSBinding.getAddressingVersion(), wSBinding.getSOAPVersion());
        if (string != null) {
            return;
        }
        AddressingVersion addressingVersion = wSBinding.getAddressingVersion();
        WsaTubeHelper wsaTubeHelper = addressingVersion.getWsaHelper(wSDLPort, null, wSBinding);
        String string2 = wsaTubeHelper.getEffectiveInputAction(packet);
        if (string2 == null || string2.equals("")) {
            throw new WebServiceException(ClientMessages.INVALID_SOAP_ACTION());
        }
        boolean bl2 = bl = packet.expectReply == false;
        if (wSDLPort != null && !bl && packet.getMessage() != null && (wSDLBoundOperation = wSDLPort.getBinding().get(packet.getWSDLOperation())) != null && wSDLBoundOperation.getAnonymous() == WSDLBoundOperation.ANONYMOUS.prohibited) {
            throw new WebServiceException(AddressingMessages.WSAW_ANONYMOUS_PROHIBITED());
        }
        if (!wSBinding.isFeatureEnabled(OneWayFeature.class)) {
            this.fillRequestAddressingHeaders(packet, addressingVersion, wSBinding.getSOAPVersion(), bl, string2, AddressingVersion.isRequired(wSBinding));
        } else {
            this.fillRequestAddressingHeaders(packet, addressingVersion, wSBinding.getSOAPVersion(), wSBinding.getFeature(OneWayFeature.class), string2);
        }
    }

    private void fillRequestAddressingHeaders(@NotNull Packet packet, @NotNull AddressingVersion addressingVersion, @NotNull SOAPVersion sOAPVersion, @NotNull OneWayFeature oneWayFeature, @NotNull String string) {
        this.fillCommonAddressingHeaders(packet, addressingVersion, sOAPVersion, string, false);
        if (oneWayFeature.getReplyTo() != null) {
            this.add(oneWayFeature.getReplyTo().createHeader(addressingVersion.replyToTag));
            StringHeader stringHeader = new StringHeader(addressingVersion.messageIDTag, packet.getMessage().getID(addressingVersion, sOAPVersion));
            this.add(stringHeader);
        }
        if (oneWayFeature.getFrom() != null) {
            this.add(oneWayFeature.getFrom().createHeader(addressingVersion.fromTag));
        }
        if (oneWayFeature.getRelatesToID() != null) {
            this.add(new RelatesToHeader(addressingVersion.relatesToTag, oneWayFeature.getRelatesToID()));
        }
    }

    private void fillCommonAddressingHeaders(Packet packet, @NotNull AddressingVersion addressingVersion, @NotNull SOAPVersion sOAPVersion, @NotNull String string, boolean bl) {
        if (packet == null) {
            throw new IllegalArgumentException(AddressingMessages.NULL_PACKET());
        }
        if (addressingVersion == null) {
            throw new IllegalArgumentException(AddressingMessages.NULL_ADDRESSING_VERSION());
        }
        if (sOAPVersion == null) {
            throw new IllegalArgumentException(AddressingMessages.NULL_SOAP_VERSION());
        }
        if (string == null) {
            throw new IllegalArgumentException(AddressingMessages.NULL_ACTION());
        }
        StringHeader stringHeader = new StringHeader(addressingVersion.toTag, packet.endpointAddress.toString());
        this.add(stringHeader);
        packet.soapAction = string;
        stringHeader = new StringHeader(addressingVersion.actionTag, string, sOAPVersion, bl);
        this.add(stringHeader);
    }

    @Override
    public boolean add(Header header) {
        return super.add(header);
    }

    @Nullable
    public Header remove(@NotNull String string, @NotNull String string2) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            Header header = this.get(i);
            if (!header.getLocalPart().equals(string2) || !header.getNamespaceURI().equals(string)) continue;
            return this.remove(i);
        }
        return null;
    }

    @Nullable
    public Header remove(@NotNull QName qName) {
        return this.remove(qName.getNamespaceURI(), qName.getLocalPart());
    }

    @Override
    public Header remove(int n) {
        this.removeUnderstoodBit(n);
        return (Header)super.remove(n);
    }

    private void removeUnderstoodBit(int n) {
        assert (n < this.size());
        if (n < 32) {
            int n2 = this.understoodBits >>> -31 + n << n;
            int n3 = this.understoodBits << -n >>> 31 - n >>> 1;
            this.understoodBits = n2 | n3;
            if (this.moreUnderstoodBits != null && this.moreUnderstoodBits.cardinality() > 0) {
                if (this.moreUnderstoodBits.get(0)) {
                    this.understoodBits |= Integer.MIN_VALUE;
                }
                this.moreUnderstoodBits.clear(0);
                int n4 = this.moreUnderstoodBits.nextSetBit(1);
                while (n4 > 0) {
                    this.moreUnderstoodBits.set(n4 - 1);
                    this.moreUnderstoodBits.clear(n4);
                    n4 = this.moreUnderstoodBits.nextSetBit(n4 + 1);
                }
            }
        } else if (this.moreUnderstoodBits != null && this.moreUnderstoodBits.cardinality() > 0) {
            this.moreUnderstoodBits.clear(n -= 32);
            int n5 = this.moreUnderstoodBits.nextSetBit(n);
            while (n5 >= 1) {
                this.moreUnderstoodBits.set(n5 - 1);
                this.moreUnderstoodBits.clear(n5);
                n5 = this.moreUnderstoodBits.nextSetBit(n5 + 1);
            }
        }
        if (this.size() - 1 <= 33 && this.moreUnderstoodBits != null) {
            this.moreUnderstoodBits = null;
        }
    }

    @Override
    public boolean remove(Object object) {
        if (object != null) {
            for (int i = 0; i < this.size(); ++i) {
                if (!object.equals(this.get(i))) continue;
                this.remove(i);
                return true;
            }
        }
        return false;
    }

    public static HeaderList copy(HeaderList headerList) {
        if (headerList == null) {
            return null;
        }
        return new HeaderList(headerList);
    }

    public void readResponseAddressingHeaders(WSDLPort wSDLPort, WSBinding wSBinding) {
        String string = this.getAction(wSBinding.getAddressingVersion(), wSBinding.getSOAPVersion());
    }
}

