/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.security.AccessController;
import java.util.Arrays;
import sun.awt.image.ByteComponentRaster;
import sun.awt.image.BytePackedRaster;
import sun.awt.windows.WPrinterJob;
import sun.font.CompositeFont;
import sun.font.Font2D;
import sun.font.FontUtilities;
import sun.font.PhysicalFont;
import sun.font.TrueTypeFont;
import sun.print.PathGraphics;
import sun.print.ProxyGraphics2D;
import sun.security.action.GetPropertyAction;

class WPathGraphics
extends PathGraphics {
    private static final int DEFAULT_USER_RES = 72;
    private static final float MIN_DEVICE_LINEWIDTH = 1.2f;
    private static final float MAX_THINLINE_INCHES = 0.014f;
    private static boolean useGDITextLayout = true;
    private static boolean preferGDITextLayout = false;

    WPathGraphics(Graphics2D graphics2D, PrinterJob printerJob, Printable printable, PageFormat pageFormat, int n, boolean bl) {
        super(graphics2D, printerJob, printable, pageFormat, n, bl);
    }

    @Override
    public Graphics create() {
        return new WPathGraphics((Graphics2D)this.getDelegate().create(), this.getPrinterJob(), this.getPrintable(), this.getPageFormat(), this.getPageIndex(), this.canDoRedraws());
    }

    @Override
    public void draw(Shape shape) {
        Stroke stroke = this.getStroke();
        if (stroke instanceof BasicStroke) {
            BasicStroke basicStroke = null;
            BasicStroke basicStroke2 = (BasicStroke)stroke;
            float f = basicStroke2.getLineWidth();
            Point2D.Float float_ = new Point2D.Float(f, f);
            AffineTransform affineTransform = this.getTransform();
            affineTransform.deltaTransform(float_, float_);
            float f2 = Math.min(Math.abs(float_.x), Math.abs(float_.y));
            if (f2 < 1.2f) {
                Point2D.Float float_2 = new Point2D.Float(1.2f, 1.2f);
                try {
                    AffineTransform affineTransform2 = affineTransform.createInverse();
                    affineTransform2.deltaTransform(float_2, float_2);
                    float f3 = Math.max(Math.abs(float_2.x), Math.abs(float_2.y));
                    basicStroke = new BasicStroke(f3, basicStroke2.getEndCap(), basicStroke2.getLineJoin(), basicStroke2.getMiterLimit(), basicStroke2.getDashArray(), basicStroke2.getDashPhase());
                    this.setStroke(basicStroke);
                }
                catch (NoninvertibleTransformException noninvertibleTransformException) {
                    // empty catch block
                }
            }
            super.draw(shape);
            if (basicStroke != null) {
                this.setStroke(basicStroke2);
            }
        } else {
            super.draw(shape);
        }
    }

    @Override
    public void drawString(String string, int n, int n2) {
        this.drawString(string, (float)n, (float)n2);
    }

    @Override
    public void drawString(String string, float f, float f2) {
        this.drawString(string, f, f2, this.getFont(), this.getFontRenderContext(), 0.0f);
    }

    @Override
    protected int platformFontCount(Font font, String string) {
        boolean bl;
        AffineTransform affineTransform = this.getTransform();
        AffineTransform affineTransform2 = new AffineTransform(affineTransform);
        affineTransform2.concatenate(this.getFont().getTransform());
        int n = affineTransform2.getType();
        boolean bl2 = bl = n != 32 && (n & 0x40) == 0;
        if (!bl) {
            return 0;
        }
        Font2D font2D = FontUtilities.getFont2D(font);
        if (font2D instanceof CompositeFont || font2D instanceof TrueTypeFont) {
            return 1;
        }
        return 0;
    }

    private static boolean isXP() {
        String string = System.getProperty("os.version");
        if (string != null) {
            Float f = Float.valueOf(string);
            return f.floatValue() >= 5.1f;
        }
        return false;
    }

    private boolean strNeedsTextLayout(String string, Font font) {
        char[] cArray = string.toCharArray();
        boolean bl = FontUtilities.isComplexText(cArray, 0, cArray.length);
        if (!bl) {
            return false;
        }
        if (!useGDITextLayout) {
            return true;
        }
        return !preferGDITextLayout && (!WPathGraphics.isXP() || !FontUtilities.textLayoutIsCompatible(font));
    }

    private int getAngle(Point2D.Double double_) {
        double d = Math.toDegrees(Math.atan2(double_.y, double_.x));
        if (d < 0.0) {
            d += 360.0;
        }
        if (d != 0.0) {
            d = 360.0 - d;
        }
        return (int)Math.round(d * 10.0);
    }

    private float getAwScale(double d, double d2) {
        float f = (float)(d / d2);
        if (f > 0.999f && f < 1.001f) {
            f = 1.0f;
        }
        return f;
    }

    @Override
    public void drawString(String string, float f, float f2, Font font, FontRenderContext fontRenderContext, float f3) {
        if (string.length() == 0) {
            return;
        }
        if (WPrinterJob.shapeTextProp) {
            super.drawString(string, f, f2, font, fontRenderContext, f3);
            return;
        }
        boolean bl = this.strNeedsTextLayout(string, font);
        if ((font.hasLayoutAttributes() || bl) && !this.printingGlyphVector) {
            TextLayout textLayout = new TextLayout(string, font, fontRenderContext);
            textLayout.draw(this, f, f2);
            return;
        }
        if (bl) {
            super.drawString(string, f, f2, font, fontRenderContext, f3);
            return;
        }
        AffineTransform affineTransform = this.getTransform();
        AffineTransform affineTransform2 = new AffineTransform(affineTransform);
        affineTransform2.concatenate(font.getTransform());
        int n = affineTransform2.getType();
        boolean bl2 = n != 32 && (n & 0x40) == 0;
        WPrinterJob wPrinterJob = (WPrinterJob)this.getPrinterJob();
        try {
            wPrinterJob.setTextColor((Color)this.getPaint());
        }
        catch (ClassCastException classCastException) {
            bl2 = false;
        }
        if (!bl2) {
            super.drawString(string, f, f2, font, fontRenderContext, f3);
            return;
        }
        Point2D.Float float_ = new Point2D.Float(f, f2);
        Point2D.Float float_2 = new Point2D.Float();
        if (font.isTransformed()) {
            AffineTransform affineTransform3 = font.getTransform();
            float f4 = (float)affineTransform3.getTranslateX();
            float f5 = (float)affineTransform3.getTranslateY();
            if ((double)Math.abs(f4) < 1.0E-5) {
                f4 = 0.0f;
            }
            if ((double)Math.abs(f5) < 1.0E-5) {
                f5 = 0.0f;
            }
            float_.x += f4;
            float_.y += f5;
        }
        affineTransform.transform(float_, float_2);
        if (this.getClip() != null) {
            this.deviceClip(this.getClip().getPathIterator(affineTransform));
        }
        float f6 = font.getSize2D();
        Point2D.Double double_ = new Point2D.Double(0.0, 1.0);
        affineTransform2.deltaTransform(double_, double_);
        double d = Math.sqrt(double_.x * double_.x + double_.y * double_.y);
        float f7 = (float)((double)f6 * d);
        Point2D.Double double_2 = new Point2D.Double(1.0, 0.0);
        affineTransform2.deltaTransform(double_2, double_2);
        double d2 = Math.sqrt(double_2.x * double_2.x + double_2.y * double_2.y);
        float f8 = (float)((double)f6 * d2);
        float f9 = this.getAwScale(d2, d);
        int n2 = this.getAngle(double_2);
        Font2D font2D = FontUtilities.getFont2D(font);
        if (font2D instanceof TrueTypeFont) {
            this.textOut(string, font, (TrueTypeFont)font2D, fontRenderContext, f7, n2, f9, affineTransform, d2, f, f2, float_2.x, float_2.y, f3);
        } else if (font2D instanceof CompositeFont) {
            CompositeFont compositeFont = (CompositeFont)font2D;
            float f10 = f;
            float f11 = f2;
            float f12 = float_2.x;
            float f13 = float_2.y;
            char[] cArray = string.toCharArray();
            int n3 = cArray.length;
            int[] nArray = new int[n3];
            compositeFont.getMapper().charsToGlyphs(n3, cArray, nArray);
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            while (n5 < n3) {
                n4 = n5;
                n6 = nArray[n4] >>> 24;
                while (n5 < n3 && nArray[n5] >>> 24 == n6) {
                    ++n5;
                }
                String string2 = new String(cArray, n4, n5 - n4);
                PhysicalFont physicalFont = compositeFont.getSlotFont(n6);
                this.textOut(string2, font, physicalFont, fontRenderContext, f7, n2, f9, affineTransform, d2, f10, f11, f12, f13, 0.0f);
                Rectangle2D rectangle2D = font.getStringBounds(string2, fontRenderContext);
                float f14 = (float)rectangle2D.getWidth();
                f10 += f14;
                float_.x += f14;
                affineTransform.transform(float_, float_2);
                f12 = float_2.x;
                f13 = float_2.y;
            }
        } else {
            super.drawString(string, f, f2, font, fontRenderContext, f3);
        }
    }

    @Override
    protected boolean printGlyphVector(GlyphVector glyphVector, float f, float f2) {
        int n;
        Object object;
        Object[] objectArray;
        int n2;
        if ((glyphVector.getLayoutFlags() & 1) != 0) {
            return false;
        }
        AffineTransform affineTransform = this.getTransform();
        AffineTransform affineTransform2 = new AffineTransform(affineTransform);
        Font font = glyphVector.getFont();
        affineTransform2.concatenate(font.getTransform());
        int n3 = affineTransform2.getType();
        boolean bl = n3 != 32 && (n3 & 0x40) == 0;
        WPrinterJob wPrinterJob = (WPrinterJob)this.getPrinterJob();
        try {
            wPrinterJob.setTextColor((Color)this.getPaint());
        }
        catch (ClassCastException classCastException) {
            bl = false;
        }
        if (WPrinterJob.shapeTextProp || !bl) {
            return false;
        }
        Point2D.Float float_ = new Point2D.Float(f, f2);
        Point2D.Float float_2 = new Point2D.Float();
        if (font.isTransformed()) {
            AffineTransform affineTransform3 = font.getTransform();
            float f3 = (float)affineTransform3.getTranslateX();
            float f4 = (float)affineTransform3.getTranslateY();
            if ((double)Math.abs(f3) < 1.0E-5) {
                f3 = 0.0f;
            }
            if ((double)Math.abs(f4) < 1.0E-5) {
                f4 = 0.0f;
            }
            float_.x += f3;
            float_.y += f4;
        }
        affineTransform.transform(float_, float_2);
        if (this.getClip() != null) {
            this.deviceClip(this.getClip().getPathIterator(affineTransform));
        }
        float f5 = font.getSize2D();
        Point2D.Double double_ = new Point2D.Double(0.0, 1.0);
        affineTransform2.deltaTransform(double_, double_);
        double d = Math.sqrt(double_.x * double_.x + double_.y * double_.y);
        float f6 = (float)((double)f5 * d);
        Point2D.Double double_2 = new Point2D.Double(1.0, 0.0);
        affineTransform2.deltaTransform(double_2, double_2);
        double d2 = Math.sqrt(double_2.x * double_2.x + double_2.y * double_2.y);
        float f7 = (float)((double)f5 * d2);
        float f8 = this.getAwScale(d2, d);
        int n4 = this.getAngle(double_2);
        int n5 = glyphVector.getNumGlyphs();
        int[] nArray = glyphVector.getGlyphCodes(0, n5, null);
        float[] fArray = glyphVector.getGlyphPositions(0, n5, null);
        int n6 = 0;
        for (n2 = 0; n2 < n5; ++n2) {
            if ((nArray[n2] & 0xFFFF) < 65534) continue;
            ++n6;
        }
        if (n6 > 0) {
            n2 = n5 - n6;
            objectArray = new int[n2];
            object = new float[n2 * 2];
            int n7 = 0;
            for (n = 0; n < n5; ++n) {
                if ((nArray[n] & 0xFFFF) >= 65534) continue;
                objectArray[n7] = nArray[n];
                object[n7 * 2] = fArray[n * 2];
                object[n7 * 2 + 1] = fArray[n * 2 + 1];
                ++n7;
            }
            n5 = n2;
            nArray = objectArray;
            fArray = object;
        }
        AffineTransform affineTransform4 = new AffineTransform(affineTransform);
        affineTransform4.rotate((double)n4 * Math.PI / 1800.0);
        objectArray = new float[fArray.length];
        affineTransform4.transform(fArray, 0, (float[])objectArray, 0, fArray.length / 2);
        object = FontUtilities.getFont2D(font);
        if (object instanceof TrueTypeFont) {
            String string = ((Font2D)object).getFamilyName(null);
            if (!wPrinterJob.setFont(string, f6, n = font.getStyle() | ((Font2D)object).getStyle(), n4, f8)) {
                return false;
            }
            wPrinterJob.glyphsOut(nArray, float_2.x, float_2.y, (float[])objectArray);
        } else if (object instanceof CompositeFont) {
            CompositeFont compositeFont = (CompositeFont)object;
            float f9 = f;
            float f10 = f2;
            float f11 = float_2.x;
            float f12 = float_2.y;
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            while (n9 < n5) {
                int n11;
                n8 = n9;
                n10 = nArray[n8] >>> 24;
                while (n9 < n5 && nArray[n9] >>> 24 == n10) {
                    ++n9;
                }
                PhysicalFont physicalFont = compositeFont.getSlotFont(n10);
                if (!(physicalFont instanceof TrueTypeFont)) {
                    return false;
                }
                String string = physicalFont.getFamilyName(null);
                if (!wPrinterJob.setFont(string, f6, n11 = font.getStyle() | physicalFont.getStyle(), n4, f8)) {
                    return false;
                }
                int[] nArray2 = Arrays.copyOfRange(nArray, n8, n9);
                float[] fArray2 = Arrays.copyOfRange((float[])objectArray, n8 * 2, n9 * 2);
                if (n8 != 0) {
                    Point2D.Float float_3 = new Point2D.Float(f + fArray[n8 * 2], f2 + fArray[n8 * 2 + 1]);
                    affineTransform.transform(float_3, float_3);
                    f11 = float_3.x;
                    f12 = float_3.y;
                }
                wPrinterJob.glyphsOut(nArray2, f11, f12, fArray2);
            }
        } else {
            return false;
        }
        return true;
    }

    private void textOut(String string, Font font, PhysicalFont physicalFont, FontRenderContext fontRenderContext, float f, int n, float f2, AffineTransform affineTransform, double d, float f3, float f4, float f5, float f6, float f7) {
        String string2 = physicalFont.getFamilyName(null);
        int n2 = font.getStyle() | physicalFont.getStyle();
        WPrinterJob wPrinterJob = (WPrinterJob)this.getPrinterJob();
        boolean bl = wPrinterJob.setFont(string2, f, n2, n, f2);
        if (!bl) {
            super.drawString(string, f3, f4, font, fontRenderContext, f7);
            return;
        }
        float[] fArray = null;
        if (!this.okGDIMetrics(string, font, fontRenderContext, d)) {
            string = wPrinterJob.removeControlChars(string);
            char[] cArray = string.toCharArray();
            int n3 = cArray.length;
            GlyphVector glyphVector = null;
            if (!FontUtilities.isComplexText(cArray, 0, n3)) {
                glyphVector = font.createGlyphVector(fontRenderContext, string);
            }
            if (glyphVector == null) {
                super.drawString(string, f3, f4, font, fontRenderContext, f7);
                return;
            }
            fArray = glyphVector.getGlyphPositions(0, n3, null);
            Point2D point2D = glyphVector.getGlyphPosition(glyphVector.getNumGlyphs());
            AffineTransform affineTransform2 = new AffineTransform(affineTransform);
            affineTransform2.rotate((double)n * Math.PI / 1800.0);
            float[] fArray2 = new float[fArray.length];
            affineTransform2.transform(fArray, 0, fArray2, 0, fArray.length / 2);
            fArray = fArray2;
        }
        wPrinterJob.textOut(string, f5, f6, fArray);
    }

    private boolean okGDIMetrics(String string, Font font, FontRenderContext fontRenderContext, double d) {
        Rectangle2D rectangle2D = font.getStringBounds(string, fontRenderContext);
        double d2 = rectangle2D.getWidth();
        d2 = Math.round(d2 * d);
        int n = ((WPrinterJob)this.getPrinterJob()).getGDIAdvance(string);
        if (d2 > 0.0 && n > 0) {
            double d3 = Math.abs((double)n - d2);
            double d4 = (double)n / d2;
            if (d4 < 1.0) {
                d4 = 1.0 / d4;
            }
            return d3 <= 1.0 || d4 < 1.002;
        }
        return true;
    }

    @Override
    protected boolean drawImageToPlatform(Image image, AffineTransform affineTransform, Color color, int n, int n2, int n3, int n4, boolean bl) {
        boolean bl2;
        BufferedImage bufferedImage = this.getBufferedImage(image);
        if (bufferedImage == null) {
            return true;
        }
        WPrinterJob wPrinterJob = (WPrinterJob)this.getPrinterJob();
        AffineTransform affineTransform2 = this.getTransform();
        if (affineTransform == null) {
            affineTransform = new AffineTransform();
        }
        affineTransform2.concatenate(affineTransform);
        double[] dArray = new double[6];
        affineTransform2.getMatrix(dArray);
        Point2D.Float float_ = new Point2D.Float(1.0f, 0.0f);
        Point2D.Float float_2 = new Point2D.Float(0.0f, 1.0f);
        affineTransform2.deltaTransform(float_, float_);
        affineTransform2.deltaTransform(float_2, float_2);
        Point2D.Float float_3 = new Point2D.Float(0.0f, 0.0f);
        double d = float_.distance(float_3);
        double d2 = float_2.distance(float_3);
        double d3 = wPrinterJob.getXRes();
        double d4 = wPrinterJob.getYRes();
        double d5 = d3 / 72.0;
        double d6 = d4 / 72.0;
        int n5 = affineTransform2.getType();
        boolean bl3 = bl2 = (n5 & 0x30) != 0;
        if (bl2) {
            if (d > d5) {
                d = d5;
            }
            if (d2 > d6) {
                d2 = d6;
            }
        }
        if (d != 0.0 && d2 != 0.0) {
            AffineTransform affineTransform3 = new AffineTransform(dArray[0] / d, dArray[1] / d2, dArray[2] / d, dArray[3] / d2, dArray[4] / d, dArray[5] / d2);
            Rectangle2D.Float float_4 = new Rectangle2D.Float(n, n2, n3, n4);
            Shape shape = affineTransform3.createTransformedShape(float_4);
            Rectangle2D rectangle2D = shape.getBounds2D();
            rectangle2D.setRect(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth() + 0.001, rectangle2D.getHeight() + 0.001);
            int n6 = (int)rectangle2D.getWidth();
            int n7 = (int)rectangle2D.getHeight();
            if (n6 > 0 && n7 > 0) {
                byte[] byArray;
                Object object;
                boolean bl5 = true;
                if (!bl && this.hasTransparentPixels(bufferedImage)) {
                    bl5 = false;
                    if (this.isBitmaskTransparency(bufferedImage)) {
                        if (color == null) {
                            if (this.drawBitmaskImage(bufferedImage, affineTransform, color, n, n2, n3, n4)) {
                                return true;
                            }
                        } else if (color.getTransparency() == 1) {
                            bl5 = true;
                        }
                    }
                    if (!this.canDoRedraws()) {
                        bl5 = true;
                    }
                } else {
                    color = null;
                }
                if ((n + n3 > bufferedImage.getWidth(null) || n2 + n4 > bufferedImage.getHeight(null)) && this.canDoRedraws()) {
                    bl5 = false;
                }
                if (!bl5) {
                    affineTransform2.getMatrix(dArray);
                    AffineTransform affineTransform4 = new AffineTransform(dArray[0] / d5, dArray[1] / d6, dArray[2] / d5, dArray[3] / d6, dArray[4] / d5, dArray[5] / d6);
                    Rectangle2D.Float float_5 = new Rectangle2D.Float(n, n2, n3, n4);
                    Shape shape2 = affineTransform2.createTransformedShape(float_5);
                    Rectangle2D rectangle2D2 = shape2.getBounds2D();
                    rectangle2D2.setRect(rectangle2D2.getX(), rectangle2D2.getY(), rectangle2D2.getWidth() + 0.001, rectangle2D2.getHeight() + 0.001);
                    int n8 = (int)rectangle2D2.getWidth();
                    int n9 = (int)rectangle2D2.getHeight();
                    int n16 = n8 * n9 * 3;
                    int bl6 = 0x800000;
                    double object2 = d3 < d4 ? d3 : d4;
                    int byArray2 = (int)object2;
                    double n18 = 1.0;
                    double componentSampleModel = (double)n8 / (double)n6;
                    double d7 = (double)n9 / (double)n7;
                    double d8 = componentSampleModel > d7 ? d7 : componentSampleModel;
                    int n10 = (int)((double)byArray2 / d8);
                    if (n10 < 72) {
                        n10 = 72;
                    }
                    while (n16 > bl6 && byArray2 > n10) {
                        n18 *= 2.0;
                        byArray2 /= 2;
                        n16 /= 4;
                    }
                    if (byArray2 < n10) {
                        n18 = object2 / (double)n10;
                    }
                    rectangle2D2.setRect(rectangle2D2.getX() / n18, rectangle2D2.getY() / n18, rectangle2D2.getWidth() / n18, rectangle2D2.getHeight() / n18);
                    wPrinterJob.saveState(this.getTransform(), this.getClip(), rectangle2D2, n18, n18);
                    return true;
                }
                int n14 = 5;
                IndexColorModel indexColorModel = null;
                ColorModel colorModel = bufferedImage.getColorModel();
                int n15 = bufferedImage.getType();
                if (colorModel instanceof IndexColorModel && colorModel.getPixelSize() <= 8 && (n15 == 12 || n15 == 13)) {
                    indexColorModel = (IndexColorModel)colorModel;
                    n14 = n15;
                    if (n15 == 12 && colorModel.getPixelSize() == 2) {
                        int[] nArray = new int[16];
                        indexColorModel.getRGBs(nArray);
                        boolean bl4 = indexColorModel.getTransparency() != 1;
                        int bufferedImage2 = indexColorModel.getTransparentPixel();
                        indexColorModel = new IndexColorModel(4, 16, nArray, 0, bl4, bufferedImage2, 0);
                    }
                }
                int n17 = (int)rectangle2D.getWidth();
                int n11 = (int)rectangle2D.getHeight();
                BufferedImage bufferedImage2 = null;
                boolean bl4 = true;
                if (bl4) {
                    bufferedImage2 = indexColorModel == null ? new BufferedImage(n17, n11, n14) : new BufferedImage(n17, n11, n14, indexColorModel);
                    object = bufferedImage2.createGraphics();
                    ((Graphics)object).clipRect(0, 0, bufferedImage2.getWidth(), bufferedImage2.getHeight());
                    ((Graphics2D)object).translate(-rectangle2D.getX(), -rectangle2D.getY());
                    ((Graphics2D)object).transform(affineTransform3);
                    if (color == null) {
                        color = Color.white;
                    }
                    ((Graphics)object).drawImage(bufferedImage, n, n2, n + n3, n2 + n4, n, n2, n + n3, n2 + n4, color, null);
                    ((Graphics)object).dispose();
                } else {
                    bufferedImage2 = bufferedImage;
                }
                object = new Rectangle2D.Float((float)(rectangle2D.getX() * d), (float)(rectangle2D.getY() * d2), (float)(rectangle2D.getWidth() * d), (float)(rectangle2D.getHeight() * d2));
                WritableRaster writableRaster = bufferedImage2.getRaster();
                if (writableRaster instanceof ByteComponentRaster) {
                    byArray = ((ByteComponentRaster)writableRaster).getDataStorage();
                } else if (writableRaster instanceof BytePackedRaster) {
                    byArray = ((BytePackedRaster)writableRaster).getDataStorage();
                } else {
                    return false;
                }
                int n12 = 24;
                SampleModel sampleModel = bufferedImage2.getSampleModel();
                if (sampleModel instanceof ComponentSampleModel) {
                    ComponentSampleModel multiPixelPackedSampleModel = (ComponentSampleModel)sampleModel;
                    n12 = multiPixelPackedSampleModel.getPixelStride() * 8;
                } else if (sampleModel instanceof MultiPixelPackedSampleModel) {
                    MultiPixelPackedSampleModel n19 = (MultiPixelPackedSampleModel)sampleModel;
                    n12 = n19.getPixelBitStride();
                } else if (indexColorModel != null) {
                    int shape3 = bufferedImage2.getWidth();
                    int n13 = bufferedImage2.getHeight();
                    if (shape3 > 0 && n13 > 0) {
                        n12 = byArray.length * 8 / shape3 / n13;
                    }
                }
                Shape shape2 = this.getClip();
                this.clip(affineTransform.createTransformedShape(float_4));
                this.deviceClip(this.getClip().getPathIterator(this.getTransform()));
                wPrinterJob.drawDIBImage(byArray, ((Rectangle2D.Float)object).x, ((Rectangle2D.Float)object).y, (float)Math.rint((double)((Rectangle2D.Float)object).width + 0.5), (float)Math.rint((double)((Rectangle2D.Float)object).height + 0.5), 0.0f, 0.0f, bufferedImage2.getWidth(), bufferedImage2.getHeight(), n12, indexColorModel);
                this.setClip(shape2);
            }
        }
        return true;
    }

    @Override
    public void redrawRegion(Rectangle2D rectangle2D, double d, double d2, Shape shape, AffineTransform affineTransform) throws PrinterException {
        WPrinterJob wPrinterJob = (WPrinterJob)this.getPrinterJob();
        Printable printable = this.getPrintable();
        PageFormat pageFormat = this.getPageFormat();
        int n = this.getPageIndex();
        BufferedImage bufferedImage = new BufferedImage((int)rectangle2D.getWidth(), (int)rectangle2D.getHeight(), 5);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        ProxyGraphics2D proxyGraphics2D = new ProxyGraphics2D(graphics2D, wPrinterJob);
        proxyGraphics2D.setColor(Color.white);
        proxyGraphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        proxyGraphics2D.clipRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        proxyGraphics2D.translate(-rectangle2D.getX(), -rectangle2D.getY());
        float f = (float)(wPrinterJob.getXRes() / d);
        float f2 = (float)(wPrinterJob.getYRes() / d2);
        proxyGraphics2D.scale(f / 72.0f, f2 / 72.0f);
        proxyGraphics2D.translate(-wPrinterJob.getPhysicalPrintableX(pageFormat.getPaper()) / wPrinterJob.getXRes() * 72.0, -wPrinterJob.getPhysicalPrintableY(pageFormat.getPaper()) / wPrinterJob.getYRes() * 72.0);
        proxyGraphics2D.transform(new AffineTransform(this.getPageFormat().getMatrix()));
        proxyGraphics2D.setPaint(Color.black);
        printable.print(proxyGraphics2D, pageFormat, n);
        graphics2D.dispose();
        this.deviceClip(shape.getPathIterator(affineTransform));
        Rectangle2D.Float float_ = new Rectangle2D.Float((float)(rectangle2D.getX() * d), (float)(rectangle2D.getY() * d2), (float)(rectangle2D.getWidth() * d), (float)(rectangle2D.getHeight() * d2));
        ByteComponentRaster byteComponentRaster = (ByteComponentRaster)bufferedImage.getRaster();
        wPrinterJob.drawImage3ByteBGR(byteComponentRaster.getDataStorage(), float_.x, float_.y, float_.width, float_.height, 0.0f, 0.0f, bufferedImage.getWidth(), bufferedImage.getHeight());
    }

    @Override
    protected void deviceFill(PathIterator pathIterator, Color color) {
        WPrinterJob wPrinterJob = (WPrinterJob)this.getPrinterJob();
        this.convertToWPath(pathIterator);
        wPrinterJob.selectSolidBrush(color);
        wPrinterJob.fillPath();
    }

    @Override
    protected void deviceClip(PathIterator pathIterator) {
        WPrinterJob wPrinterJob = (WPrinterJob)this.getPrinterJob();
        this.convertToWPath(pathIterator);
        wPrinterJob.selectClipPath();
    }

    @Override
    protected void deviceFrameRect(int n, int n2, int n3, int n4, Color color) {
        boolean bl;
        AffineTransform affineTransform = this.getTransform();
        int n5 = affineTransform.getType();
        boolean bl2 = bl = (n5 & 0x30) != 0;
        if (bl) {
            this.draw(new Rectangle2D.Float(n, n2, n3, n4));
            return;
        }
        Stroke stroke = this.getStroke();
        if (stroke instanceof BasicStroke) {
            BasicStroke basicStroke = (BasicStroke)stroke;
            int n6 = basicStroke.getEndCap();
            int n7 = basicStroke.getLineJoin();
            if (n6 == 2 && n7 == 0 && basicStroke.getMiterLimit() == 10.0f) {
                float f = basicStroke.getLineWidth();
                Point2D.Float float_ = new Point2D.Float(f, f);
                affineTransform.deltaTransform(float_, float_);
                float f2 = Math.min(Math.abs(float_.x), Math.abs(float_.y));
                Point2D.Float float_2 = new Point2D.Float(n, n2);
                affineTransform.transform(float_2, float_2);
                Point2D.Float float_3 = new Point2D.Float(n + n3, n2 + n4);
                affineTransform.transform(float_3, float_3);
                float f3 = (float)(float_3.getX() - float_2.getX());
                float f4 = (float)(float_3.getY() - float_2.getY());
                WPrinterJob wPrinterJob = (WPrinterJob)this.getPrinterJob();
                if (wPrinterJob.selectStylePen(n6, n7, f2, color)) {
                    wPrinterJob.frameRect((float)float_2.getX(), (float)float_2.getY(), f3, f4);
                } else {
                    double d = Math.min(wPrinterJob.getXRes(), wPrinterJob.getYRes());
                    if ((double)f2 / d < (double)0.014f) {
                        wPrinterJob.selectPen(f2, color);
                        wPrinterJob.frameRect((float)float_2.getX(), (float)float_2.getY(), f3, f4);
                    } else {
                        this.draw(new Rectangle2D.Float(n, n2, n3, n4));
                    }
                }
            } else {
                this.draw(new Rectangle2D.Float(n, n2, n3, n4));
            }
        }
    }

    @Override
    protected void deviceFillRect(int n, int n2, int n3, int n4, Color color) {
        boolean bl;
        AffineTransform affineTransform = this.getTransform();
        int n5 = affineTransform.getType();
        boolean bl2 = bl = (n5 & 0x30) != 0;
        if (bl) {
            this.fill(new Rectangle2D.Float(n, n2, n3, n4));
            return;
        }
        Point2D.Float float_ = new Point2D.Float(n, n2);
        affineTransform.transform(float_, float_);
        Point2D.Float float_2 = new Point2D.Float(n + n3, n2 + n4);
        affineTransform.transform(float_2, float_2);
        float f = (float)(float_2.getX() - float_.getX());
        float f2 = (float)(float_2.getY() - float_.getY());
        WPrinterJob wPrinterJob = (WPrinterJob)this.getPrinterJob();
        wPrinterJob.fillRect((float)float_.getX(), (float)float_.getY(), f, f2, color);
    }

    @Override
    protected void deviceDrawLine(int n, int n2, int n3, int n4, Color color) {
        Stroke stroke = this.getStroke();
        if (stroke instanceof BasicStroke) {
            WPrinterJob wPrinterJob;
            BasicStroke basicStroke = (BasicStroke)stroke;
            if (basicStroke.getDashArray() != null) {
                this.draw(new Line2D.Float(n, n2, n3, n4));
                return;
            }
            float f = basicStroke.getLineWidth();
            Point2D.Float float_ = new Point2D.Float(f, f);
            AffineTransform affineTransform = this.getTransform();
            affineTransform.deltaTransform(float_, float_);
            float f2 = Math.min(Math.abs(float_.x), Math.abs(float_.y));
            Point2D.Float float_2 = new Point2D.Float(n, n2);
            affineTransform.transform(float_2, float_2);
            Point2D.Float float_3 = new Point2D.Float(n3, n4);
            affineTransform.transform(float_3, float_3);
            int n5 = basicStroke.getEndCap();
            int n6 = basicStroke.getLineJoin();
            if (float_3.getX() == float_2.getX() && float_3.getY() == float_2.getY()) {
                n5 = 1;
            }
            if ((wPrinterJob = (WPrinterJob)this.getPrinterJob()).selectStylePen(n5, n6, f2, color)) {
                wPrinterJob.moveTo((float)float_2.getX(), (float)float_2.getY());
                wPrinterJob.lineTo((float)float_3.getX(), (float)float_3.getY());
            } else {
                double d = Math.min(wPrinterJob.getXRes(), wPrinterJob.getYRes());
                if (n5 == 1 || (n == n3 || n2 == n4) && (double)f2 / d < (double)0.014f) {
                    wPrinterJob.selectPen(f2, color);
                    wPrinterJob.moveTo((float)float_2.getX(), (float)float_2.getY());
                    wPrinterJob.lineTo((float)float_3.getX(), (float)float_3.getY());
                } else {
                    this.draw(new Line2D.Float(n, n2, n3, n4));
                }
            }
        }
    }

    private void convertToWPath(PathIterator pathIterator) {
        float[] fArray = new float[6];
        WPrinterJob wPrinterJob = (WPrinterJob)this.getPrinterJob();
        int n = pathIterator.getWindingRule() == 0 ? 1 : 2;
        wPrinterJob.setPolyFillMode(n);
        wPrinterJob.beginPath();
        while (!pathIterator.isDone()) {
            int n2 = pathIterator.currentSegment(fArray);
            switch (n2) {
                case 0: {
                    wPrinterJob.moveTo(fArray[0], fArray[1]);
                    break;
                }
                case 1: {
                    wPrinterJob.lineTo(fArray[0], fArray[1]);
                    break;
                }
                case 2: {
                    int n3 = wPrinterJob.getPenX();
                    int n4 = wPrinterJob.getPenY();
                    float f = (float)n3 + (fArray[0] - (float)n3) * 2.0f / 3.0f;
                    float f2 = (float)n4 + (fArray[1] - (float)n4) * 2.0f / 3.0f;
                    float f3 = fArray[2] - (fArray[2] - fArray[0]) * 2.0f / 3.0f;
                    float f4 = fArray[3] - (fArray[3] - fArray[1]) * 2.0f / 3.0f;
                    wPrinterJob.polyBezierTo(f, f2, f3, f4, fArray[2], fArray[3]);
                    break;
                }
                case 3: {
                    wPrinterJob.polyBezierTo(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
                    break;
                }
                case 4: {
                    wPrinterJob.closeFigure();
                }
            }
            pathIterator.next();
        }
        wPrinterJob.endPath();
    }

    static {
        String string = AccessController.doPrivileged(new GetPropertyAction("sun.java2d.print.enableGDITextLayout"));
        if (string != null && !(useGDITextLayout = Boolean.getBoolean(string)) && string.equalsIgnoreCase("prefer")) {
            useGDITextLayout = true;
            preferGDITextLayout = true;
        }
    }
}

