/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.jboss;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.plugin.jboss.JBossConfig;
import org.hyperic.hq.plugin.jboss.JBossInstance;
import org.hyperic.hq.plugin.jboss.JBossProductPlugin;
import org.hyperic.hq.plugin.jboss.JBossServerControlPlugin;
import org.hyperic.hq.plugin.jboss.JBossUtil;
import org.hyperic.hq.plugin.jboss.jmx.ServerQuery;
import org.hyperic.hq.plugin.jboss.jmx.ServiceQuery;
import org.hyperic.hq.product.AutoServerDetector;
import org.hyperic.hq.product.DaemonDetector;
import org.hyperic.hq.product.FileServerDetector;
import org.hyperic.hq.product.GenericPlugin;
import org.hyperic.hq.product.Log4JLogTrackPlugin;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.ServerDetector;
import org.hyperic.hq.product.ServerResource;
import org.hyperic.hq.product.ServerTypeInfo;
import org.hyperic.hq.product.ServiceResource;
import org.hyperic.hq.product.jmx.ServiceTypeFactory;
import org.hyperic.util.config.ConfigResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossDetector
extends DaemonDetector
implements AutoServerDetector,
FileServerDetector {
    private static final Log log = LogFactory.getLog((String)JBossDetector.class.getName());
    private static final String JBOSS_SERVICE_XML = "conf" + File.separator + "jboss-service.xml";
    private static final String JBOSS_MAIN = "org.jboss.Main";
    private static final String PROP_CP = "-Djava.class.path=";
    private static final String PROP_AGENT = "-javaagent:";
    private static final String PROP_SRV_CONFIG_URL = "-Djboss.server.config.url=";
    private static final String PROP_SRV_HOME_URL = "-Djboss.server.home.url=";
    private static final String PROP_SRV_BASE_URL = "-Djboss.server.base.url=";
    private static final String EMBEDDED_TOMCAT = "jbossweb-tomcat";
    private static final String[] PTQL_QUERIES = new String[]{"State.Name.sw=java,Args.*.eq=org.jboss.Main"};
    private static HashMap<String, String> bindings = new HashMap();

    private static File getFileFromURL(String name) {
        try {
            URI uri = new URI(name);
            File file = new File(uri);
            if (file.exists()) {
                return file;
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return null;
    }

    private static void findServerProcess(List<JBossInstance> servers, String query) {
        bindings.clear();
        long[] pids = JBossDetector.getPids((String)query);
        for (int i = 0; i < pids.length; ++i) {
            String[] args = JBossDetector.getProcArgs((long)pids[i]);
            String classpath = null;
            String runJar = null;
            String config = "default";
            String address = null;
            String srvHomeUrl = null;
            String srvConfigUrl = null;
            String srvBaseUrl = null;
            String configPath = null;
            String installPath = null;
            boolean mainArgs = false;
            for (int j = 0; j < args.length; ++j) {
                String arg = args[j];
                if (arg.equals("-classpath") || arg.equals("-cp")) {
                    classpath = args[j + 1];
                    continue;
                }
                if (arg.startsWith(PROP_CP)) {
                    classpath = arg.substring(PROP_CP.length());
                    continue;
                }
                if (arg.startsWith(PROP_AGENT)) {
                    runJar = arg.substring(PROP_AGENT.length());
                    continue;
                }
                if (arg.startsWith(PROP_SRV_CONFIG_URL)) {
                    srvConfigUrl = arg.substring(PROP_SRV_CONFIG_URL.length());
                    continue;
                }
                if (arg.startsWith(PROP_SRV_HOME_URL)) {
                    srvHomeUrl = arg.substring(PROP_SRV_HOME_URL.length());
                    continue;
                }
                if (arg.startsWith(PROP_SRV_BASE_URL)) {
                    srvBaseUrl = arg.substring(PROP_SRV_BASE_URL.length());
                    continue;
                }
                if (!mainArgs && arg.equals(JBOSS_MAIN)) {
                    mainArgs = true;
                    continue;
                }
                if (mainArgs && arg.startsWith("-c")) {
                    config = arg.substring(2, arg.length());
                    if (!config.equals("")) continue;
                    config = args[j + 1];
                    continue;
                }
                if (!mainArgs || !arg.startsWith("-b") || !(address = arg.substring(2, arg.length())).equals("")) continue;
                address = args[j + 1];
            }
            File configDir = null;
            if (srvConfigUrl != null) {
                configDir = JBossDetector.getFileFromURL(srvConfigUrl);
                if (configDir != null) {
                    configDir = configDir.getParentFile();
                }
            } else if (srvHomeUrl != null) {
                configDir = JBossDetector.getFileFromURL(srvHomeUrl);
            } else if (srvBaseUrl != null && config != null && (configDir = JBossDetector.getFileFromURL(srvBaseUrl)) != null) {
                configDir = new File(configDir, config);
            }
            if (configDir != null && configDir.exists()) {
                configPath = configDir.getAbsolutePath();
            }
            if (classpath != null) {
                StringTokenizer tok = new StringTokenizer(classpath, File.pathSeparator);
                while (tok.hasMoreTokens()) {
                    String jar = tok.nextToken();
                    if (!jar.endsWith("run.jar")) continue;
                    runJar = jar;
                    break;
                }
            }
            if (runJar == null) continue;
            File root = new File(runJar).getParentFile();
            if (root == null || root.getPath().equals(".")) {
                String cwd = JBossDetector.getProcCwd((long)pids[i]);
                if (cwd == null) continue;
                root = new File(cwd);
            }
            if ((root = root.getParentFile()) == null) continue;
            if (configPath == null) {
                configPath = JBossDetector.getServerConfigPath(root, config);
            }
            if (address != null) {
                bindings.put(configPath, address);
            }
            installPath = root.getAbsolutePath();
            servers.add(new JBossInstance(installPath, configPath, pids[i]));
        }
    }

    private static String getServerConfigPath(File root, String config) {
        File configDir = new File(root, "server" + File.separator + config);
        return configDir.getAbsolutePath();
    }

    private static void findBrandedExe(GenericPlugin plugin, List<JBossInstance> servers) {
        String query = "State.Name.eq=" + plugin.getPluginProperty("brand.exe");
        long[] pids = JBossDetector.getPids((String)query);
        for (int i = 0; i < pids.length; ++i) {
            String exe = JBossDetector.getProcExe((long)pids[i]);
            if (exe == null) continue;
            File root = new File(exe).getParentFile().getParentFile();
            String engine = plugin.getPluginProperty("brand.dir");
            if (engine != null) {
                root = new File(root, engine);
            }
            String configPath = JBossDetector.getServerConfigPath(root, "default");
            servers.add(new JBossInstance(root.getPath(), configPath, pids[i]));
        }
    }

    private static void findServiceExe(GenericPlugin plugin, List<JBossInstance> servers) {
        String query = "State.Name.eq=jboss";
        long[] pids = JBossDetector.getPids((String)query);
        for (int i = 0; i < pids.length; ++i) {
            long pid = pids[i];
            String exe = JBossDetector.getProcExe((long)pid);
            if (exe == null) {
                log.debug((Object)("Unable to determine exe for pid=" + pid));
                continue;
            }
            File root = new File(exe).getParentFile();
            if (root.getName().equals("bin")) {
                root = root.getParentFile();
                log.debug((Object)("installpath derived from exe=" + exe));
            } else {
                String msg = exe + " outside installpath";
                String cwd = JBossDetector.getProcCwd((long)pids[i]);
                if (cwd == null) {
                    log.debug((Object)(msg + ", unable to determine cwd for pid=" + pid));
                    continue;
                }
                root = new File(cwd).getParentFile();
                log.debug((Object)(msg + ", using cwd=" + cwd));
            }
            String configPath = JBossDetector.getServerConfigPath(root, "default");
            servers.add(new JBossInstance(root.getPath(), configPath, pid));
        }
    }

    private static List<JBossInstance> getServerProcessList(GenericPlugin plugin) {
        ArrayList<JBossInstance> servers = new ArrayList<JBossInstance>();
        for (int i = 0; i < PTQL_QUERIES.length; ++i) {
            JBossDetector.findServerProcess(servers, PTQL_QUERIES[i]);
        }
        if (JBossDetector.isWin32()) {
            JBossDetector.findBrandedExe(plugin, servers);
            JBossDetector.findServiceExe(plugin, servers);
        }
        return servers;
    }

    static String getRunningInstallPath(GenericPlugin plugin) {
        List<JBossInstance> servers = JBossDetector.getServerProcessList(plugin);
        if (servers.isEmpty()) {
            return null;
        }
        JBossInstance instance = servers.get(0);
        return instance.getHomePath();
    }

    public Set discoverServiceTypes(ConfigResponse serverConfig) throws PluginException {
        MBeanServerConnection mServer;
        Set serviceTypes = new HashSet();
        try {
            mServer = JBossUtil.getMBeanServerConnection(serverConfig.toProperties());
        }
        catch (Exception e) {
            throw new PluginException(e.getMessage(), (Throwable)e);
        }
        try {
            Set<ObjectName> objectNames = mServer.queryNames(new ObjectName("spring.application:*"), null);
            ServiceTypeFactory serviceTypeFactory = new ServiceTypeFactory();
            serviceTypes = serviceTypeFactory.create(this.getProductPlugin(), (ServerTypeInfo)this.getTypeInfo(), mServer, objectNames);
        }
        catch (Exception e) {
            throw new PluginException(e.getMessage(), (Throwable)e);
        }
        return serviceTypes;
    }

    public List<ServerResource> getServerResources(ConfigResponse platformConfig) throws PluginException {
        ArrayList<ServerResource> servers = new ArrayList<ServerResource>();
        List<JBossInstance> paths = JBossDetector.getServerProcessList((GenericPlugin)this);
        for (JBossInstance inst : paths) {
            List<ServerResource> found = this.getServerList(inst.getConfigPath(), inst.getPid());
            if (found == null) continue;
            servers.addAll(found);
        }
        return servers;
    }

    private String getBindAddress(JBossConfig cfg, String installpath) {
        String where;
        String address = bindings.get(installpath);
        if (address == null) {
            address = this.getListenAddress(cfg.getJnpPort());
            if (address == null || address.equals("localhost")) {
                address = cfg.getJnpAddress();
                where = "configuration";
            } else {
                where = "TCP listen table";
            }
        } else {
            where = "-b argument";
        }
        this.getLog().debug((Object)("Bind address=" + address + " (determined from " + where + ")"));
        return address;
    }

    public List<ServerResource> getServerList(String installpath) throws PluginException {
        return this.getServerList(installpath, 0L);
    }

    public List<ServerResource> getServerList(String installpath, long pid) throws PluginException {
        File configDir = new File(installpath);
        this.getLog().debug((Object)("[getServerList] configDir='" + configDir + "'"));
        File serviceXML = new File(configDir, JBOSS_SERVICE_XML);
        File distDir = configDir.getParentFile().getParentFile();
        if (distDir.getName().equals("deploy")) {
            return null;
        }
        String serverName = configDir.getName();
        String fullVersion = JBossDetector.getVersion(configDir, "jboss-j2ee.jar");
        if (fullVersion == null) {
            fullVersion = JBossDetector.getVersion(configDir.getParentFile().getParentFile(), "jboss-j2se.jar");
        }
        if (fullVersion == null) {
            this.getLog().debug((Object)("unable to determine JBoss version in: " + configDir));
            return null;
        }
        String typeVersion = fullVersion.substring(0, 3);
        if (!this.getTypeInfo().getVersion().equals(typeVersion)) {
            this.getLog().debug((Object)(configDir + " (" + fullVersion + ")" + " is not a " + this.getName()));
            return null;
        }
        this.getLog().debug((Object)("discovered JBoss server [" + serverName + "] in " + configDir));
        ConfigResponse _config = new ConfigResponse();
        ConfigResponse controlConfig = new ConfigResponse();
        ConfigResponse metricConfig = new ConfigResponse();
        JBossConfig cfg = JBossConfig.getConfig(serviceXML);
        String address = this.getBindAddress(cfg, installpath);
        String jnpUrl = "jnp://" + address + ":" + cfg.getJnpPort();
        this.getLog().debug((Object)("JNP url=" + jnpUrl));
        _config.setValue("java.naming.provider.url", jnpUrl);
        Properties props = this.getManager().getProperties();
        String[] credProps = new String[]{"java.naming.provider.url", "java.naming.security.principal", "java.naming.security.credentials"};
        for (int i = 0; i < credProps.length; ++i) {
            String value = props.getProperty(credProps[i]);
            if (value == null) continue;
            _config.setValue(credProps[i], value);
        }
        String script = distDir + File.separator + JBossServerControlPlugin.getControlScript(JBossDetector.isWin32());
        controlConfig.setValue("program", JBossDetector.getCanonicalPath((String)script));
        controlConfig.setValue("configSet", serverName);
        String logDir = ".." + File.separator + ".." + File.separator + ".." + File.separator + "logs";
        File brandedLogDir = new File(installpath, logDir);
        if (!brandedLogDir.exists()) {
            logDir = "log";
        }
        metricConfig.setValue(Log4JLogTrackPlugin.PROP_FILES_SERVER, logDir + File.separator + "server.log");
        ServerResource server = this.createServerResource(installpath);
        server.setConnectProperties(new String[]{"java.naming.provider.url"});
        if (pid > 0L) {
            this.populateListeningPorts(pid, _config, true);
        }
        server.setProductConfig(_config);
        server.setMeasurementConfig(metricConfig);
        server.setControlConfig(controlConfig);
        if (JBossProductPlugin.isBrandedServer(configDir, this.getPluginProperty("brand.ear"))) {
            String brandName = this.getPluginProperty("brand.name");
            server.setName(JBossDetector.getPlatformName() + " " + brandName);
            server.setIdentifier(brandName);
        } else {
            server.setName(server.getName() + " " + serverName);
        }
        File home = cfg.getJBossHome();
        if (home != null) {
            this.adjustClassPath(home.getPath());
        }
        this.adjustClassPath(installpath);
        ArrayList<ServerResource> servers = new ArrayList<ServerResource>();
        if (pid > 0L) {
            this.discoverServerConfig(server, pid);
        }
        servers.add(server);
        return servers;
    }

    public List<ServerResource> getServerResources(ConfigResponse platformConfig, String path) throws PluginException {
        return this.getServerList(JBossDetector.getParentDir((String)path, (int)2));
    }

    protected List<ServiceResource> discoverServices(ConfigResponse serverConfig) throws PluginException {
        try {
            return this.discoverJBossServices(serverConfig);
        }
        catch (SecurityException e) {
            throw new PluginException(e.getMessage(), (Throwable)e);
        }
    }

    private List<ServiceResource> discoverJBossServices(ConfigResponse serverConfig) throws PluginException {
        MBeanServerConnection mServer;
        String url = serverConfig.getValue("java.naming.provider.url");
        try {
            mServer = JBossUtil.getMBeanServerConnection(serverConfig.toProperties());
        }
        catch (Exception e) {
            throw new PluginException(e.getMessage(), (Throwable)e);
        }
        this.configure(serverConfig);
        ServerQuery serverQuery = new ServerQuery((ServerDetector)this);
        serverQuery.setURL(url);
        serverQuery.getAttributes(mServer);
        serverQuery.findServices(mServer);
        List queries = serverQuery.getServiceQueries();
        this.getLog().debug((Object)("discovered " + queries.size() + " services"));
        ArrayList<ServiceResource> services = new ArrayList<ServiceResource>();
        for (int i = 0; i < queries.size(); ++i) {
            ServiceQuery query = (ServiceQuery)queries.get(i);
            ServiceResource service = new ServiceResource();
            service.setName(query.getQualifiedName());
            service.setType(query.getResourceType());
            ConfigResponse _config = new ConfigResponse((Map)query.getResourceConfig());
            if (query.hasControl()) {
                ConfigResponse controlConfig = new ConfigResponse((Map)query.getControlConfig());
                service.setControlConfig(controlConfig);
            }
            service.setProductConfig(_config);
            service.setMeasurementConfig();
            _config = new ConfigResponse((Map)query.getCustomProperties());
            service.setCustomProperties(_config);
            services.add(service);
        }
        ConfigResponse cprops = new ConfigResponse();
        String[] attrs = this.getCustomPropertiesSchema().getOptionNames();
        for (int i = 0; i < attrs.length; ++i) {
            String key = attrs[i];
            String val = serverQuery.getAttribute(key);
            if (val == null) continue;
            cprops.setValue(key, val);
        }
        this.setCustomProperties(cprops);
        return services;
    }

    public static String getVersion(File installPath, String jar) {
        Attributes attributes;
        File file = new File(installPath, "lib" + File.separator + jar);
        if (!file.exists()) {
            log.debug((Object)("[getVersion] file '" + file + "' not found"));
            return null;
        }
        try {
            JarFile jarFile = new JarFile(file);
            log.debug((Object)("[getVersion] jarFile='" + jarFile.getName() + "'"));
            attributes = jarFile.getManifest().getMainAttributes();
            jarFile.close();
        }
        catch (IOException e) {
            log.debug((Object)e, (Throwable)e);
            return null;
        }
        String version = attributes.getValue("Implementation-Version");
        log.debug((Object)("[getVersion] version='" + version + "'"));
        if (version == null) {
            return null;
        }
        if (version.length() < 3) {
            return null;
        }
        if (!Character.isDigit(version.charAt(0)) || version.charAt(1) != '.' || !Character.isDigit(version.charAt(2))) {
            return null;
        }
        return version;
    }

    private void populateListeningPorts(long pid, ConfigResponse productConfig, boolean b) {
        try {
            Class<?> du = Class.forName("org.hyperic.hq.product.DetectionUtil");
            Method plp = du.getMethod("populateListeningPorts", Long.TYPE, ConfigResponse.class, Boolean.TYPE);
            plp.invoke(null, pid, productConfig, b);
        }
        catch (ClassNotFoundException ex) {
            log.debug((Object)"[populateListeningPorts] Class 'DetectionUtil' not found", (Throwable)ex);
        }
        catch (NoSuchMethodException ex) {
            log.debug((Object)"[populateListeningPorts] Method 'populateListeningPorts' not found", (Throwable)ex);
        }
        catch (Exception ex) {
            log.debug((Object)"[populateListeningPorts] Problem with Method 'populateListeningPorts'", (Throwable)ex);
        }
    }
}

